package org.eclipse.draw2d {
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.lang.Arguments;
dynamic public class BendpointConnectionRouter extends AbstractRouter {
  private var constraints: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__I, [11]));
  public static var A_POINT: PrecisionPoint = new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__, []));
  public override function getConstraint__Lorg_eclipse_draw2d_Connection_2(connection: Connection): Object {
    return constraints.get__Ljava_lang_Object_2(connection);
  }
  public override function remove__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    constraints.remove__Ljava_lang_Object_2(connection);
  }
  public override function route__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    var points: PointList = conn.getPoints__();
    points.removeAllPoints__();
    var bendpoints: List = List(this.getConstraint__Lorg_eclipse_draw2d_Connection_2(conn));
    if (bendpoints === null)
      bendpoints = Collections.EMPTY_LIST;
    var ref1: Point;
    var ref2: Point;
    if (bendpoints.isEmpty__()) {
      ref1 = conn.getTargetAnchor__().getReferencePoint__();
      ref2 = conn.getSourceAnchor__().getReferencePoint__();
    } else {
      ref1 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__Lorg_eclipse_draw2d_geometry_Point_2, [(Bendpoint(bendpoints.get__I(0))).getLocation__()]));
      conn.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(ref1);
      ref2 = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__Lorg_eclipse_draw2d_geometry_Point_2, [(Bendpoint(bendpoints.get__I(bendpoints.size__() - 1))).getLocation__()]));
      conn.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(ref2);
    }
    A_POINT.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(conn.getSourceAnchor__().getLocation__Lorg_eclipse_draw2d_geometry_Point_2(ref1));
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(A_POINT);
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(A_POINT);
    for (var i: int = 0; i < bendpoints.size__(); i++) {
      var bp: Bendpoint = Bendpoint(bendpoints.get__I(i));
      points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(bp.getLocation__());
    }
    A_POINT.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(conn.getTargetAnchor__().getLocation__Lorg_eclipse_draw2d_geometry_Point_2(ref2));
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(A_POINT);
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(A_POINT);
    conn.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
    return;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(connection: Connection, constraint: Object): void {
    constraints.put__Ljava_lang_Object_2Ljava_lang_Object_2(connection, constraint);
    return;
  }
}
}
