package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Integer;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class BorderLayout extends AbstractHintLayout {
  public static var CENTER: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [2]));
  public static var TOP: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [8]));
  public static var BOTTOM: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [32]));
  public static var LEFT: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [1]));
  public static var RIGHT: Integer = new Integer(new Arguments(java.lang.Integer.Integer__I, [4]));
  private var center: IFigure;
  private var left: IFigure;
  private var top: IFigure;
  private var bottom: IFigure;
  private var right: IFigure;
  private var vGap: int = 0;
  private var hGap: int = 0;
  public override function calculateMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var minWHint: int = 0;
    var minHHint: int = 0;
    if (wHint < 0) {
      minWHint = -1;
    }
    if (hHint < 0) {
      minHHint = -1;
    }
    var border: Insets = container.getInsets__();
    wHint = Math__.max__II(minWHint, wHint - border.getWidth__());
    hHint = Math__.max__II(minHHint, hHint - border.getHeight__());
    var minSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var middleRowWidth: int = 0;
    var middleRowHeight: int = 0;
    var rows: int = 0;
    var columns: int = 0;
    if (top !== null && top.isVisible__()) {
      var childSize: Dimension = top.getMinimumSize__II(wHint, hHint);
      hHint = Math__.max__II(minHHint, hHint - (childSize.height + vGap));
      minSize.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(childSize);
      rows += 1;
    }
    if (bottom !== null && bottom.isVisible__()) {
      var childSize_1: Dimension = bottom.getMinimumSize__II(wHint, hHint);
      hHint = Math__.max__II(minHHint, hHint - (childSize_1.height + vGap));
      minSize.width = Math__.max__II(minSize.width, childSize_1.width);
      minSize.height += childSize_1.height;
      rows += 1;
    }
    if (left !== null && left.isVisible__()) {
      var childSize_2: Dimension = left.getMinimumSize__II(wHint, hHint);
      middleRowWidth = childSize_2.width;
      middleRowHeight = childSize_2.height;
      wHint = Math__.max__II(minWHint, wHint - (childSize_2.width + hGap));
      columns += 1;
    }
    if (right !== null && right.isVisible__()) {
      var childSize_3: Dimension = right.getMinimumSize__II(wHint, hHint);
      middleRowWidth += childSize_3.width;
      middleRowHeight = Math__.max__II(childSize_3.height, middleRowHeight);
      wHint = Math__.max__II(minWHint, wHint - (childSize_3.width + hGap));
      columns += 1;
    }
    if (center !== null && center.isVisible__()) {
      var childSize_4: Dimension = center.getMinimumSize__II(wHint, hHint);
      middleRowWidth += childSize_4.width;
      middleRowHeight = Math__.max__II(childSize_4.height, middleRowHeight);
      columns += 1;
    }
    rows += columns > 0 ? 1 : 0;
    minSize.height += middleRowHeight + border.getHeight__() + ((rows - 1) * vGap);
    minSize.width = Math__.max__II(minSize.width, middleRowWidth) + border.getWidth__() + ((columns - 1) * hGap);
    return minSize;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var minWHint: int = 0;
    var minHHint: int = 0;
    if (wHint < 0)
      minWHint = -1;
    if (hHint < 0)
      minHHint = -1;
    var border: Insets = container.getInsets__();
    wHint = Math__.max__II(minWHint, wHint - border.getWidth__());
    hHint = Math__.max__II(minHHint, hHint - border.getHeight__());
    var prefSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var middleRowWidth: int = 0;
    var middleRowHeight: int = 0;
    var rows: int = 0;
    var columns: int = 0;
    if (top !== null && top.isVisible__()) {
      var childSize: Dimension = top.getPreferredSize__II(wHint, hHint);
      hHint = Math__.max__II(minHHint, hHint - (childSize.height + vGap));
      prefSize.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(childSize);
      rows += 1;
    }
    if (bottom !== null && bottom.isVisible__()) {
      var childSize_1: Dimension = bottom.getPreferredSize__II(wHint, hHint);
      hHint = Math__.max__II(minHHint, hHint - (childSize_1.height + vGap));
      prefSize.width = Math__.max__II(prefSize.width, childSize_1.width);
      prefSize.height += childSize_1.height;
      rows += 1;
    }
    if (left !== null && left.isVisible__()) {
      var childSize_2: Dimension = left.getPreferredSize__II(wHint, hHint);
      middleRowWidth = childSize_2.width;
      middleRowHeight = childSize_2.height;
      wHint = Math__.max__II(minWHint, wHint - (childSize_2.width + hGap));
      columns += 1;
    }
    if (right !== null && right.isVisible__()) {
      var childSize_3: Dimension = right.getPreferredSize__II(wHint, hHint);
      middleRowWidth += childSize_3.width;
      middleRowHeight = Math__.max__II(childSize_3.height, middleRowHeight);
      wHint = Math__.max__II(minWHint, wHint - (childSize_3.width + hGap));
      columns += 1;
    }
    if (center !== null && center.isVisible__()) {
      var childSize_4: Dimension = center.getPreferredSize__II(wHint, hHint);
      middleRowWidth += childSize_4.width;
      middleRowHeight = Math__.max__II(childSize_4.height, middleRowHeight);
      columns += 1;
    }
    rows += columns > 0 ? 1 : 0;
    prefSize.height += middleRowHeight + border.getHeight__() + ((rows - 1) * vGap);
    prefSize.width = Math__.max__II(prefSize.width, middleRowWidth) + border.getWidth__() + ((columns - 1) * hGap);
    return prefSize;
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    var area: Rectangle = container.getClientArea__();
    var rect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    var childSize: Dimension;
    if (top !== null && top.isVisible__()) {
      childSize = top.getPreferredSize__II(area.width, -1);
      rect.setLocation__II(area.x, area.y);
      rect.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(childSize);
      rect.width = area.width;
      top.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      area.y += rect.height + vGap;
      area.height -= rect.height + vGap;
    }
    if (bottom !== null && bottom.isVisible__()) {
      childSize = bottom.getPreferredSize__II(Math__.max__II(area.width, 0), -1);
      rect.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(childSize);
      rect.width = area.width;
      rect.setLocation__II(area.x, area.y + area.height - rect.height);
      bottom.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      area.height -= rect.height + vGap;
    }
    if (left !== null && left.isVisible__()) {
      childSize = left.getPreferredSize__II(-1, Math__.max__II(0, area.height));
      rect.setLocation__II(area.x, area.y);
      rect.width = childSize.width;
      rect.height = Math__.max__II(0, area.height);
      left.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      area.x += rect.width + hGap;
      area.width -= rect.width + hGap;
    }
    if (right !== null && right.isVisible__()) {
      childSize = right.getPreferredSize__II(-1, Math__.max__II(0, area.height));
      rect.width = childSize.width;
      rect.height = Math__.max__II(0, area.height);
      rect.setLocation__II(area.x + area.width - rect.width, area.y);
      right.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      area.width -= rect.width + hGap;
    }
    if (center !== null && center.isVisible__()) {
      if (area.width < 0)
        area.width = 0;
      if (area.height < 0)
        area.height = 0;
      center.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(area);
    }
    return;
  }
  public override function remove__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    if (center === child) {
      center = null;
    } else if (top === child) {
      top = null;
    } else if (bottom === child) {
      bottom = null;
    } else if (right === child) {
      right = null;
    } else if (left === child) {
      left = null;
    }
    return;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(child: IFigure, constraint: Object): void {
    this.remove__Lorg_eclipse_draw2d_IFigure_2(child);
    super.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(child, constraint);
    if (constraint === null) {
      return;
    }
    switch ((Integer(constraint)).intValue__()) {
      case 2 :
        center = child;
        break;
      case 8 :
        top = child;
        break;
      case 32 :
        bottom = child;
        break;
      case 4 :
        right = child;
        break;
      case 1 :
        left = child;
        break;
      default :
        break;
    }
    return;
  }
  public function setHorizontalSpacing__I(gap: int): void {
    hGap = gap;
    return;
  }
  public function setVerticalSpacing__I(gap: int): void {
    vGap = gap;
    return;
  }
}
}
