package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import java.lang.IllegalArgumentException;
import java.lang.Arguments;
dynamic public class BufferedGraphicsSource implements GraphicsSource {
  private var imageBuffer: Image;
  private var imageGC: GC;
  private var controlGC: GC;
  private var control: Control;
  private var inUse: Rectangle;
  public function BufferedGraphicsSource(c: Control) {
    control = c;
    return;
  }
  public function flushGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(region: Rectangle): void {
    if (inUse.isEmpty__())
      return;
    var restoreCaret: Boolean = false;
    var canvas: Canvas = null;
    if (control is Canvas) {
      canvas = Canvas(control);
      var caret: Caret = canvas.getCaret__();
      if (caret !== null)
        restoreCaret = caret.isVisible__();
      if (restoreCaret)
        caret.setVisible__Z(false);
    }
    if (imageBuffer !== null) {
      imageGC.dispose__();
      controlGC.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(this.getImage__(), 0, 0, inUse.width, inUse.height, inUse.x, inUse.y, inUse.width, inUse.height);
      imageBuffer.dispose__();
      imageBuffer = null;
      imageGC = null;
    }
    controlGC.dispose__();
    controlGC = null;
    if (restoreCaret)
      canvas.getCaret__().setVisible__Z(true);
    return;
  }
  public function getGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(region: Rectangle): Graphics {
    if (control === null || control.isDisposed__())
      return null;
    var ptSWT: Point = control.getSize__();
    inUse = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, ptSWT.x, ptSWT.y]));
    inUse.intersect__Lorg_eclipse_draw2d_geometry_Rectangle_2(region);
    if (inUse.isEmpty__())
      return null;
    try {
      imageBuffer = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [null, inUse.width, inUse.height]));
    } catch (noMoreHandles : SWTError) {
      imageBuffer = null;
    } catch (tooBig : IllegalArgumentException) {
      imageBuffer = null;
    }
    controlGC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [control, control.getStyle__() & (67108864 | 33554432)]));
    var graphics: Graphics;
    if (imageBuffer !== null) {
      imageGC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [imageBuffer, control.getStyle__() & (67108864 | 33554432)]));
      imageGC.setBackground__Lorg_eclipse_swt_graphics_Color_2(controlGC.getBackground__());
      imageGC.setForeground__Lorg_eclipse_swt_graphics_Color_2(controlGC.getForeground__());
      imageGC.setFont__Lorg_eclipse_swt_graphics_Font_2(controlGC.getFont__());
      imageGC.setLineStyle__I(controlGC.getLineStyle__());
      imageGC.setLineWidth__I(controlGC.getLineWidth__());
      imageGC.setXORMode__Z(controlGC.getXORMode__());
      graphics = new SWTGraphics(imageGC);
      graphics.translate__Lorg_eclipse_draw2d_geometry_Point_2(inUse.getLocation__().negate__());
    } else {
      graphics = new SWTGraphics(controlGC);
    }
    graphics.setClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(inUse);
    return graphics;
  }
  public function getImage__(): Image {
    return imageBuffer;
  }
  public function getImageGC__(): GC {
    return imageGC;
  }
}
}
