package org.eclipse.draw2d {
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;
import java.lang.Runnable;
import java.lang.IllegalArgumentException;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.Class__;
dynamic public class ButtonModel {
  public static const ENABLED_PROPERTY: String = "enabled";
  public static const PRESSED_PROPERTY: String = "pressed";
  public static const SELECTED_PROPERTY: String = "selected";
  public static const ROLLOVER_ENABLED_PROPERTY: String = "rollover enabled";
  public static const MOUSEOVER_PROPERTY: String = "mouseover";
  public static const ARMED_PROPERTY: String = "armed";
  public static const ARMED_FLAG: int = 1;
  public static const PRESSED_FLAG: int = 2;
  public static const MOUSEOVER_FLAG: int = 4;
  public static const SELECTED_FLAG: int = 8;
  public static const ENABLED_FLAG: int = 16;
  public static const ROLLOVER_ENABLED_FLAG: int = 32;
  public static const MAX_FLAG: int = 32;
  private var state: int = 16;
  private var data: Object;
  public static const DEFAULT_FIRING_BEHAVIOR: int = 0;
  public static const REPEAT_FIRING_BEHAVIOR: int = 1;
  public var actionName: String;
  public var group: ButtonGroup = null;
  private var listeners: EventListenerList = new EventListenerList();
  public var firingBehavior: ButtonStateTransitionListener;
  public function ButtonModel() {
    {
      this.installFiringBehavior__();
    }
    return;
  }
  public function addActionListener__Lorg_eclipse_draw2d_ActionListener_2(listener: ActionListener): void {
    if (listener === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    listeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"), listener);
    return;
  }
  public function addChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(listener: ChangeListener): void {
    if (listener === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    listeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"), listener);
    return;
  }
  public function addStateTransitionListener__Lorg_eclipse_draw2d_ButtonStateTransitionListener_2(listener: ButtonStateTransitionListener): void {
    if (listener === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    listeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"), listener);
    return;
  }
  public function fireActionPerformed__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"));
    var action: ActionEvent = new ActionEvent(new Arguments(org.eclipse.draw2d.ActionEvent.ActionEvent__Ljava_lang_Object_2, [this]));
    while (iter.hasNext__())
      (ActionListener(iter.next__())).actionPerformed__Lorg_eclipse_draw2d_ActionEvent_2(action);
    return;
  }
  public function fireCanceled__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"));
    while (iter.hasNext__())
      (ButtonStateTransitionListener(iter.next__())).canceled__();
    return;
  }
  public function firePressed__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"));
    while (iter.hasNext__())
      (ButtonStateTransitionListener(iter.next__())).pressed__();
    return;
  }
  public function fireReleased__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"));
    while (iter.hasNext__())
      (ButtonStateTransitionListener(iter.next__())).released__();
    return;
  }
  public function fireResume__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"));
    while (iter.hasNext__())
      (ButtonStateTransitionListener(iter.next__())).resume__();
    return;
  }
  public function fireStateChanged__Ljava_lang_String_2(property: String): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"));
    var change: ChangeEvent = new ChangeEvent(new Arguments(org.eclipse.draw2d.ChangeEvent.ChangeEvent__Ljava_lang_Object_2Ljava_lang_String_2, [this, property]));
    while (iter.hasNext__())
      (ChangeListener(iter.next__())).handleStateChanged__Lorg_eclipse_draw2d_ChangeEvent_2(change);
    return;
  }
  public function fireSuspend__(): void {
    var iter: Iterator = listeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"));
    while (iter.hasNext__())
      (ButtonStateTransitionListener(iter.next__())).suspend__();
    return;
  }
  public function getFlag__I(which: int): Boolean {
    return (state & which) != 0;
  }
  public function getGroup__(): ButtonGroup {
    return group;
  }
  public function getUserData__(): Object {
    return data;
  }
  public function installFiringBehavior__(): void {
    this.setFiringBehavior__I(0);
  }
  public function isArmed__(): Boolean {
    return (state & 1) != 0;
  }
  public function isEnabled__(): Boolean {
    return (state & 16) != 0;
  }
  public function isMouseOver__(): Boolean {
    return (state & 4) != 0;
  }
  public function isPressed__(): Boolean {
    return (state & 2) != 0;
  }
  public function isSelected__(): Boolean {
    if (group === null) {
      return (state & 8) != 0;
    } else {
      return group.isSelected__Lorg_eclipse_draw2d_ButtonModel_2(this);
    }
    return false;
  }
  public function removeActionListener__Lorg_eclipse_draw2d_ActionListener_2(listener: ActionListener): void {
    listeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"), listener);
    return;
  }
  public function removeChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(listener: ChangeListener): void {
    listeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"), listener);
    return;
  }
  public function removeStateTransitionListener__Lorg_eclipse_draw2d_ButtonStateTransitionListener_2(listener: ButtonStateTransitionListener): void {
    listeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ButtonStateTransitionListener"), listener);
    return;
  }
  public function setArmed__Z(value: Boolean): void {
    if (this.isArmed__() == value)
      return;
    if (!this.isEnabled__())
      return;
    this.setFlag__IZ(1, value);
    this.fireStateChanged__Ljava_lang_String_2("armed");
  }
  public function setEnabled__Z(value: Boolean): void {
    if (this.isEnabled__() == value)
      return;
    if (!value) {
      this.setMouseOver__Z(false);
      this.setArmed__Z(false);
      this.setPressed__Z(false);
    }
    this.setFlag__IZ(16, value);
    this.fireStateChanged__Ljava_lang_String_2("enabled");
    return;
  }
  public function setFiringBehavior__I(type: int): void {
    if (firingBehavior !== null)
      this.removeStateTransitionListener__Lorg_eclipse_draw2d_ButtonStateTransitionListener_2(firingBehavior);
    switch (type) {
      case 1 :
        firingBehavior = new ButtonModel$RepeatFiringBehavior(this);
        break;
      default :
        firingBehavior = new ButtonModel$DefaultFiringBehavior(this);
    }
    this.addStateTransitionListener__Lorg_eclipse_draw2d_ButtonStateTransitionListener_2(firingBehavior);
    return;
  }
  public function setFlag__IZ(flag: int, value: Boolean): void {
    if (value)
      state |= flag;
    else
      state &= ~flag;
    return;
  }
  public function setGroup__Lorg_eclipse_draw2d_ButtonGroup_2(bg: ButtonGroup): void {
    if (group === bg)
      return;
    if (group !== null)
      group.remove__Lorg_eclipse_draw2d_ButtonModel_2(this);
    group = bg;
    if (group !== null)
      group.add__Lorg_eclipse_draw2d_ButtonModel_2(this);
  }
  public function setMouseOver__Z(value: Boolean): void {
    if (this.isMouseOver__() == value)
      return;
    if (this.isPressed__())
      if (value)
        this.fireResume__();
      else
        this.fireSuspend__();
    this.setFlag__IZ(4, value);
    this.fireStateChanged__Ljava_lang_String_2("mouseover");
  }
  public function setPressed__Z(value: Boolean): void {
    if (this.isPressed__() == value)
      return;
    this.setFlag__IZ(2, value);
    if (value)
      this.firePressed__();
    else {
      if (this.isArmed__())
        this.fireReleased__();
      else
        this.fireCanceled__();
    }
    this.fireStateChanged__Ljava_lang_String_2("pressed");
    return;
  }
  public function setSelected__Z(value: Boolean): void {
    if (group === null) {
      if (this.isSelected__() == value)
        return;
    } else {
      group.setSelected__Lorg_eclipse_draw2d_ButtonModel_2Z(this, value);
      if (this.getFlag__I(8) == this.isSelected__())
        return;
    }
    this.setFlag__IZ(8, value);
    this.fireStateChanged__Ljava_lang_String_2("selected");
    return;
  }
  public function setUserData__Ljava_lang_Object_2(data_1: Object): void {
    this.data = data_1;
    return;
  }
}
}
