package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ChopboxAnchor extends AbstractConnectionAnchor {
  public function ChopboxAnchor__(): Object {
    return this;
  }
  public function ChopboxAnchor__Lorg_eclipse_draw2d_IFigure_2(owner: IFigure): Object {
    return this;
  }
  public override function getLocation__Lorg_eclipse_draw2d_geometry_Point_2(reference: Point): Point {
    var r: Rectangle = Rectangle.SINGLETON;
    r.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBox__());
    r.translate__II(-1, -1);
    r.resize__II(1, 1);
    this.getOwner__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(r);
    var centerX: Number = r.x + 0.5 * r.width;
    var centerY: Number = r.y + 0.5 * r.height;
    if (r.isEmpty__() || (reference.x == int(centerX) && reference.y == int(centerY)))
      return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [int(centerX), int(centerY)]));
    var dx: Number = reference.x - centerX;
    var dy: Number = reference.y - centerY;
    var scale: Number = 0.5 / Math__.max__FF(Math__.abs__F(dx) / r.width, Math__.abs__F(dy) / r.height);
    dx *= scale;
    dy *= scale;
    centerX += dx;
    centerY += dy;
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [Math__.round__F(centerX), Math__.round__F(centerY)]));
  }
  public function getBox__(): Rectangle {
    return this.getOwner__().getBounds__();
  }
  public override function getReferencePoint__(): Point {
    var ref: Point = this.getBox__().getCenter__();
    this.getOwner__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(ref);
    return ref;
  }
  public function equals__Ljava_lang_Object_2(obj: Object): Boolean {
    if (obj is ChopboxAnchor) {
      var other: ChopboxAnchor = ChopboxAnchor(obj);
      return other.getOwner__() === this.getOwner__() && other.getBox__().equals__Ljava_lang_Object_2(this.getBox__());
    }
    return false;
  }
  public function hashCode__(): int {
    if (this.getOwner__() !== null)
      return Object(this.getOwner__()).hashCode__();
    else
      return Object(Object.prototype).hashCode__.call(this);
  }
  public function ChopboxAnchor(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is IFigure) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.AbstractConnectionAnchor.AbstractConnectionAnchor__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.AbstractConnectionAnchor.AbstractConnectionAnchor__Lorg_eclipse_draw2d_IFigure_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        ChopboxAnchor__();
        break;
      case 1:
        ChopboxAnchor__Lorg_eclipse_draw2d_IFigure_2(args1[0]);
        break;
    }
  }
  public static const ChopboxAnchor__ : int = 0;
  public static const ChopboxAnchor__Lorg_eclipse_draw2d_IFigure_2 : int = 1;
}
}
