package org.eclipse.draw2d {
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.Class__;
dynamic public class Clickable extends Figure {
  public static var ROLLOVER_ENABLED_FLAG: int = Figure.MAX_FLAG << 1;
  public static var STYLE_BUTTON_FLAG: int = Figure.MAX_FLAG << 2;
  public static var STYLE_TOGGLE_FLAG: int = Figure.MAX_FLAG << 3;
  public static var MAX_FLAG: int = STYLE_TOGGLE_FLAG;
  public static var STYLE_BUTTON: int = STYLE_BUTTON_FLAG;
  public static var STYLE_TOGGLE: int = STYLE_TOGGLE_FLAG;
  public static const DEFAULT_FIRING: int = 0;
  public static const REPEAT_FIRING: int = 1;
  private var eventHandler: ClickableEventHandler;
  private var model: ButtonModel;
  private var modelObserver: Clickable$ModelObserver;
  public function Clickable__(): Object {
    {
      this.init__();
      this.setRequestFocusEnabled__Z(true);
      this.setFocusTraversable__Z(true);
    }
    return this;
  }
  public function Clickable__Lorg_eclipse_draw2d_IFigure_2(contents: IFigure): Object {
    {
      this.init__();
      this.setRequestFocusEnabled__Z(true);
      this.setFocusTraversable__Z(true);
    }
    return this;
  }
  public function Clickable__Lorg_eclipse_draw2d_IFigure_2I(contents: IFigure, style: int): Object {
    {
      this.init__();
      this.setRequestFocusEnabled__Z(true);
      this.setFocusTraversable__Z(true);
    }
    this.setContents__Lorg_eclipse_draw2d_IFigure_2(contents);
    this.setStyle__I(style);
    return this;
  }
  public function addActionListener__Lorg_eclipse_draw2d_ActionListener_2(listener: ActionListener): void {
    this.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"), listener);
    return;
  }
  public function addChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(listener: ChangeListener): void {
    this.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"), listener);
    return;
  }
  public function createDefaultModel__(): ButtonModel {
    if (this.isStyle__I(STYLE_TOGGLE))
      return new ToggleModel();
    else
      return new ButtonModel();
  }
  public function createEventHandler__(): ClickableEventHandler {
    return new ClickableEventHandler();
  }
  public function createModelObserver__(): Clickable$ModelObserver {
    return new org.eclipse.draw2d.Clickable$1(this);
  }
  public function doClick__(): void {
    this.fireActionPerformed__();
  }
  public function fireActionPerformed__(): void {
    var action: ActionEvent = new ActionEvent(new Arguments(org.eclipse.draw2d.ActionEvent.ActionEvent__Ljava_lang_Object_2, [this]));
    var listeners: Iterator = this.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"));
    while (listeners.hasNext__())
      (ActionListener(listeners.next__())).actionPerformed__Lorg_eclipse_draw2d_ActionEvent_2(action);
  }
  public function fireStateChanged__Lorg_eclipse_draw2d_ChangeEvent_2(modelChange: ChangeEvent): void {
    var change: ChangeEvent = new ChangeEvent(new Arguments(org.eclipse.draw2d.ChangeEvent.ChangeEvent__Ljava_lang_Object_2Ljava_lang_String_2, [this, modelChange.getPropertyName__()]));
    var listeners: Iterator = this.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"));
    while (listeners.hasNext__())
      (ChangeListener(listeners.next__())).handleStateChanged__Lorg_eclipse_draw2d_ChangeEvent_2(change);
  }
  public function getModel__(): ButtonModel {
    return model;
  }
  public function hookEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(handler: ClickableEventHandler): void {
    if (handler === null)
      return;
    this.addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(handler);
    this.addMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(handler);
    this.addChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(handler);
    this.addKeyListener__Lorg_eclipse_draw2d_KeyListener_2(handler);
    this.addFocusListener__Lorg_eclipse_draw2d_FocusListener_2(handler);
  }
  public function init__(): void {
    this.setModel__Lorg_eclipse_draw2d_ButtonModel_2(this.createDefaultModel__());
    this.setEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(this.createEventHandler__());
  }
  public function isRolloverEnabled__(): Boolean {
    return (flags & ROLLOVER_ENABLED_FLAG) != 0;
  }
  public function isSelected__(): Boolean {
    return this.getModel__().isSelected__();
  }
  public function isStyle__I(style: int): Boolean {
    return ((style & flags) == style);
  }
  public override function paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    super.paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics);
    if (this.hasFocus__()) {
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.black);
      graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
      var area: Rectangle = this.getClientArea__();
      if (this.isStyle__I(STYLE_BUTTON))
        graphics.drawFocus__IIII(area.x, area.y, area.width, area.height);
      else
        graphics.drawFocus__IIII(area.x, area.y, area.width - 1, area.height - 1);
    }
    return;
  }
  public override function paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.isStyle__I(STYLE_BUTTON) && (this.getModel__().isArmed__() || this.getModel__().isSelected__())) {
      graphics.translate__II(1, 1);
      graphics.pushState__();
      super.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.popState__();
      graphics.translate__II(-1, -1);
    } else
      super.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics);
    return;
  }
  public function removeActionListener__Lorg_eclipse_draw2d_ActionListener_2(listener: ActionListener): void {
    this.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ActionListener"), listener);
    return;
  }
  public function removeChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(listener: ChangeListener): void {
    this.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.ChangeListener"), listener);
    return;
  }
  public function setContents__Lorg_eclipse_draw2d_IFigure_2(contents: IFigure): void {
    this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new StackLayout());
    if (this.getChildren__().size__() > 0)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(IFigure(this.getChildren__().get__I(0)));
    this.add__Lorg_eclipse_draw2d_IFigure_2(contents);
    return;
  }
  public override function setEnabled__Z(value: Boolean): void {
    if (this.isEnabled__() == value)
      return;
    super.setEnabled__Z(value);
    this.getModel__().setEnabled__Z(value);
    this.setChildrenEnabled__Z(value);
  }
  public function setEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(h: ClickableEventHandler): void {
    if (eventHandler !== null)
      this.unhookEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(eventHandler);
    eventHandler = h;
    if (eventHandler !== null)
      this.hookEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(eventHandler);
  }
  public function setFiringMethod__I(type: int): void {
    this.getModel__().setFiringBehavior__I(type);
  }
  public function setModel__Lorg_eclipse_draw2d_ButtonModel_2(model_1: ButtonModel): void {
    if (this.model !== null) {
      this.model.removeChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(modelObserver);
      this.model.removeActionListener__Lorg_eclipse_draw2d_ActionListener_2(modelObserver);
      modelObserver = null;
    }
    this.model = model_1;
    if (model_1 !== null) {
      modelObserver = this.createModelObserver__();
      model_1.addActionListener__Lorg_eclipse_draw2d_ActionListener_2(modelObserver);
      model_1.addChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(modelObserver);
    }
    return;
  }
  public function setRolloverEnabled__Z(value: Boolean): void {
    if (this.isRolloverEnabled__() == value)
      return;
    this.setFlag__IZ(ROLLOVER_ENABLED_FLAG, value);
    this.repaint__();
  }
  public function setSelected__Z(value: Boolean): void {
    this.getModel__().setSelected__Z(value);
  }
  public function setStyle__I(style: int): void {
    if ((style & STYLE_BUTTON) != 0) {
      this.setFlag__IZ(STYLE_BUTTON_FLAG, true);
      if (!(this.getBorder__() is ButtonBorder))
        this.setBorder__Lorg_eclipse_draw2d_Border_2(new ButtonBorder(new Arguments(org.eclipse.draw2d.ButtonBorder.ButtonBorder__, [])));
      this.setOpaque__Z(true);
    } else {
      this.setFlag__IZ(STYLE_BUTTON_FLAG, false);
      this.setOpaque__Z(false);
    }
    if ((style & STYLE_TOGGLE) != 0) {
      this.setFlag__IZ(STYLE_TOGGLE_FLAG, true);
      this.setModel__Lorg_eclipse_draw2d_ButtonModel_2(this.createDefaultModel__());
    }
    return;
  }
  public function unhookEventHandler__Lorg_eclipse_draw2d_ClickableEventHandler_2(handler: ClickableEventHandler): void {
    if (handler === null)
      return;
    this.removeMouseListener__Lorg_eclipse_draw2d_MouseListener_2(handler);
    this.removeMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(handler);
    this.removeChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(handler);
  }
  public function Clickable(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is IFigure) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is IFigure && vargs[1] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0], 0];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Clickable__();
        break;
      case 1:
        Clickable__Lorg_eclipse_draw2d_IFigure_2I(args2[0], args2[1]);
        Clickable__Lorg_eclipse_draw2d_IFigure_2(args1[0]);
        break;
      case 2:
        Clickable__Lorg_eclipse_draw2d_IFigure_2I(args2[0], args2[1]);
        break;
    }
  }
  public static const Clickable__ : int = 0;
  public static const Clickable__Lorg_eclipse_draw2d_IFigure_2 : int = 1;
  public static const Clickable__Lorg_eclipse_draw2d_IFigure_2I : int = 2;
}
}
