package org.eclipse.draw2d {
dynamic public class ClickableEventHandler extends MouseMotionListener$Stub implements MouseListener, FigureListener, ChangeListener, KeyListener, FocusListener {
  private var lastEvent: MouseEvent;
  public function focusLost__Lorg_eclipse_draw2d_FocusEvent_2(fe: FocusEvent): void {
    var loser: Clickable = Clickable(fe.loser);
    loser.repaint__();
    loser.getModel__().setArmed__Z(false);
    loser.getModel__().setPressed__Z(false);
    return;
  }
  public function focusGained__Lorg_eclipse_draw2d_FocusEvent_2(fe: FocusEvent): void {
    var clickable: Clickable = Clickable(fe.gainer);
    clickable.repaint__();
    return;
  }
  public function figureMoved__Lorg_eclipse_draw2d_IFigure_2(source: IFigure): void {
    if (lastEvent === null)
      return;
    this.mouseDragged__Lorg_eclipse_draw2d_MouseEvent_2(lastEvent);
  }
  public function handleStateChanged__Lorg_eclipse_draw2d_ChangeEvent_2(change: ChangeEvent): void {
    var clickable: Clickable = Clickable(change.getSource__());
    if (change.getPropertyName__() === "mouseover" && !clickable.isRolloverEnabled__())
      return;
    clickable.repaint__();
  }
  public function mouseDoubleClicked__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
  }
  public override function mouseDragged__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
    lastEvent = me;
    var click: Clickable = Clickable(me.getSource__());
    var model: ButtonModel = click.getModel__();
    if (model.isPressed__()) {
      var over: Boolean = click.containsPoint__Lorg_eclipse_draw2d_geometry_Point_2(me.getLocation__());
      model.setArmed__Z(over);
      model.setMouseOver__Z(over);
    }
    return;
  }
  public override function mouseEntered__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
    var click: Clickable = Clickable(me.getSource__());
    click.getModel__().setMouseOver__Z(true);
    click.addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(this);
    return;
  }
  public override function mouseExited__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
    var click: Clickable = Clickable(me.getSource__());
    click.getModel__().setMouseOver__Z(false);
    click.removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(this);
    return;
  }
  public override function mouseMoved__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
  }
  public function mousePressed__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
    if (me.button != 1)
      return;
    lastEvent = me;
    var click: Clickable = Clickable(me.getSource__());
    var model: ButtonModel = click.getModel__();
    click.requestFocus__();
    model.setArmed__Z(true);
    model.setPressed__Z(true);
    me.consume__();
  }
  public function mouseReleased__Lorg_eclipse_draw2d_MouseEvent_2(me: MouseEvent): void {
    if (me.button != 1)
      return;
    var model: ButtonModel = (Clickable(me.getSource__())).getModel__();
    if (!model.isPressed__())
      return;
    model.setPressed__Z(false);
    model.setArmed__Z(false);
    me.consume__();
  }
  public function keyPressed__Lorg_eclipse_draw2d_KeyEvent_2(ke: KeyEvent): void {
    var model: ButtonModel = (Clickable(ke.getSource__())).getModel__();
    if (ke.character == 32 || ke.character == 13) {
      model.setPressed__Z(true);
      model.setArmed__Z(true);
    }
    return;
  }
  public function keyReleased__Lorg_eclipse_draw2d_KeyEvent_2(ke: KeyEvent): void {
    var model: ButtonModel = (Clickable(ke.getSource__())).getModel__();
    if (ke.character == 32 || ke.character == 13) {
      model.setPressed__Z(false);
      model.setArmed__Z(false);
    }
    return;
  }
}
}
