package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import java.lang.Arguments;
dynamic public class CompoundBorder extends AbstractBorder {
  public var inner: Border;
  public var outer: Border;
  public function CompoundBorder__(): Object {
    return this;
  }
  public function CompoundBorder__Lorg_eclipse_draw2d_Border_2Lorg_eclipse_draw2d_Border_2(outer: Border, inner: Border): Object {
    this.outer = outer;
    this.inner = inner;
    return this;
  }
  public function getInnerBorder__(): Border {
    return inner;
  }
  public override function getInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets {
    var insets: Insets = null;
    if (inner !== null)
      insets = inner.getInsets__Lorg_eclipse_draw2d_IFigure_2(figure);
    else
      insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__, []));
    if (outer !== null) {
      var moreInsets: Insets = outer.getInsets__Lorg_eclipse_draw2d_IFigure_2(figure);
      insets = insets.getAdded__Lorg_eclipse_draw2d_geometry_Insets_2(moreInsets);
    }
    return insets;
  }
  public override function getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Dimension {
    var prefSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [inner.getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(fig)]));
    var outerInsets: Insets = outer.getInsets__Lorg_eclipse_draw2d_IFigure_2(fig);
    prefSize.expand__II(outerInsets.getWidth__(), outerInsets.getHeight__());
    prefSize.union__Lorg_eclipse_draw2d_geometry_Dimension_2(outer.getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(fig));
    return prefSize;
  }
  public function getOuterBorder__(): Border {
    return outer;
  }
  public override function isOpaque__(): Boolean {
    return ((inner !== null) ? inner.isOpaque__() : false) && ((outer !== null) ? outer.isOpaque__() : false);
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure: IFigure, g: Graphics, insets: Insets): void {
    if (outer !== null) {
      g.pushState__();
      outer.paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure, g, insets);
      g.popState__();
      insets = insets.getAdded__Lorg_eclipse_draw2d_geometry_Insets_2(outer.getInsets__Lorg_eclipse_draw2d_IFigure_2(figure));
    }
    if (inner !== null)
      inner.paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure, g, insets);
    return;
  }
  public function CompoundBorder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Border && vargs[1] is Border) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        CompoundBorder__();
        break;
      case 1:
        CompoundBorder__Lorg_eclipse_draw2d_Border_2Lorg_eclipse_draw2d_Border_2(args1[0], args1[1]);
        break;
    }
  }
  public static const CompoundBorder__ : int = 0;
  public static const CompoundBorder__Lorg_eclipse_draw2d_Border_2Lorg_eclipse_draw2d_Border_2 : int = 1;
}
}
