package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ConnectionEndpointLocator implements Locator {
  private var end: Boolean;
  private var conn: Connection;
  private var uDistance: int;
  private var vDistance: int;
  public static var figureBounds: Rectangle;
  public var transposer: Transposer = new Transposer();
  public function ConnectionEndpointLocator(c: Connection, isEnd: Boolean) {
    end = isEnd;
    conn = c;
    uDistance = 14;
    vDistance = 4;
    figureBounds = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    return;
  }
  private function calculateConnectionLocation__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(loc: Point, topLeft: Point, center: Point): int {
    var m1: Number = 0;
    var m2: Number = 0;
    m1 = Number((topLeft.y - center.y)) / Number((topLeft.x - center.x));
    if (loc.x - center.x != 0)
      m2 = Number((loc.y - center.y)) / Number((loc.x - center.x));
    if (loc.x == center.x) {
      if (loc.y < center.y)
        return 3;
      else
        return 1;
    } else if (Math__.abs__D(m2) <= Math__.abs__D(m1)) {
      if (loc.x < center.x)
        return 4;
      else
        return 2;
    } else {
      if (loc.y < center.y)
        return 3;
      else
        return 1;
    }
    return 0;
  }
  private function calculateConnectionLocation__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(startPoint: Point, endPoint: Point): int {
    if (Math__.abs__I(endPoint.x - startPoint.x) > Math__.abs__I(endPoint.y - startPoint.y)) {
      if (endPoint.x > startPoint.x)
        return 2;
      else
        return 4;
    } else {
      if (endPoint.y > startPoint.y)
        return 1;
      else
        return 3;
    }
    return 0;
  }
  private function calculateTan__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(startPoint: Point, endPoint: Point): Number {
    var tan: Number = 0;
    if (endPoint.x == startPoint.x)
      tan = 1.0;
    else
      tan = Number((endPoint.y - startPoint.y)) / Number((endPoint.x - startPoint.x));
    if (tan > 1)
      tan = 1.0;
    else if (tan < -1)
      tan = -1.0;
    return tan;
  }
  private function calculateYShift__II(figureWidth: int, figureHeight: int): int {
    var yShift: int = 0;
    if (vDistance < 0)
      yShift = -figureHeight;
    else if (vDistance == 0)
      yShift = int(-figureHeight / 2);
    return yShift;
  }
  private function getConnection__(): Connection {
    return conn;
  }
  private function getConnectionOwner__(): IFigure {
    var connOwner: IFigure;
    if (this.isEnd__())
      connOwner = conn.getTargetAnchor__().getOwner__();
    else
      connOwner = conn.getSourceAnchor__().getOwner__();
    return connOwner;
  }
  public function getUDistance__(): int {
    return uDistance;
  }
  public function getVDistance__(): int {
    return vDistance;
  }
  private function isEnd__(): Boolean {
    return end;
  }
  public function relocate__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    var conn_1: Connection = this.getConnection__();
    var startPoint: Point = Point.SINGLETON;
    var endPoint: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
    var startPointPosition: int = 0;
    var endPointPosition: int = 1;
    if (this.isEnd__()) {
      startPointPosition = conn_1.getPoints__().size__() - 1;
      endPointPosition = startPointPosition - 1;
    }
    conn_1.getPoints__().getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(startPoint, startPointPosition);
    conn_1.getPoints__().getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(endPoint, endPointPosition);
    var connOwner: IFigure = this.getConnectionOwner__();
    var quadrant: int;
    if (connOwner !== null) {
      var connOwnerBounds: Rectangle = connOwner.getBounds__();
      var connOwnerCenter: Point = connOwnerBounds.getCenter__();
      var connOwnerTL: Point = connOwnerBounds.getTopLeft__();
      quadrant = this.calculateConnectionLocation__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(startPoint, connOwnerTL, connOwnerCenter);
    } else
      quadrant = this.calculateConnectionLocation__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(startPoint, endPoint);
    var cos: int = 1;
    transposer.setEnabled__Z(false);
    if (quadrant == 1 || quadrant == 3)
      transposer.setEnabled__Z(true);
    if (quadrant == 3 || quadrant == 4)
      cos = -1;
    var figureSize: Dimension = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(figure.getPreferredSize__());
    startPoint = transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(startPoint);
    endPoint = transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(endPoint);
    var tan: Number = this.calculateTan__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(startPoint, endPoint);
    var figureWidth: int = figureSize.width;
    var figureHeight: int = figureSize.height;
    var yShift: int = this.calculateYShift__II(figureWidth, figureHeight);
    var figurePoint: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [startPoint.x + (uDistance * cos) + figureWidth * (int((cos - 1) / 2)), int((startPoint.y + cos * uDistance * tan + vDistance + yShift))]));
    figureBounds.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(figureSize));
    figureBounds.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(transposer.t__Lorg_eclipse_draw2d_geometry_Point_2(figurePoint));
    figure.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(figureBounds);
    return;
  }
  public function setUDistance__I(distance: int): void {
    uDistance = distance;
    return;
  }
  public function setVDistance__I(distance: int): void {
    vDistance = distance;
    return;
  }
}
}
