package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import java.lang.Arguments;
dynamic public class ConnectionLocator extends AbstractLocator {
  public static const START: int = 2;
  public static const SOURCE: int = 2;
  public static const END: int = 3;
  public static const TARGET: int = 3;
  public static const MIDPOINT: int = 4;
  public static const MIDDLE: int = 4;
  private var connection: Connection;
  private var alignment: int;
  public function ConnectionLocator__Lorg_eclipse_draw2d_Connection_2(connection: Connection): Object {
    return this;
  }
  public function ConnectionLocator__Lorg_eclipse_draw2d_Connection_2I(connection: Connection, align: int): Object {
    this.setConnection__Lorg_eclipse_draw2d_Connection_2(connection);
    this.setAlignment__I(align);
    return this;
  }
  public function getAlignment__(): int {
    return alignment;
  }
  public function getConnection__(): Connection {
    return connection;
  }
  public override function getReferencePoint__(): Point {
    var p: Point = this.getLocation__Lorg_eclipse_draw2d_geometry_PointList_2(this.getConnection__().getPoints__());
    this.getConnection__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(p);
    return p;
  }
  public function getLocation__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): Point {
    switch (this.getAlignment__()) {
      case 2 :
        return points.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(Point.SINGLETON, 0);
      case 3 :
        return points.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(Point.SINGLETON, points.size__() - 1);
      case 4 :
        if (points.size__() % 2 == 0) {
          var i: int = int(points.size__() / 2);
          var j: int = i - 1;
          var p1: Point = points.getPoint__I(j);
          var p2: Point = points.getPoint__I(i);
          var d: Dimension = p2.getDifference__Lorg_eclipse_draw2d_geometry_Point_2(p1);
          return Point.SINGLETON.setLocation__II(p1.x + int(d.width / 2), p1.y + int(d.height / 2));
        }
        var i_1: int = int((points.size__() - 1) / 2);
        return points.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(Point.SINGLETON, i_1);
      default :
        return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
    }
  }
  public function setAlignment__I(align: int): void {
    alignment = align;
  }
  public function setConnection__Lorg_eclipse_draw2d_Connection_2(connection_1: Connection): void {
    this.connection = connection_1;
  }
  public function ConnectionLocator(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Connection) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Connection && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 4];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ConnectionLocator__Lorg_eclipse_draw2d_Connection_2I(args1[0], args1[1]);
        ConnectionLocator__Lorg_eclipse_draw2d_Connection_2(args0[0]);
        break;
      case 1:
        ConnectionLocator__Lorg_eclipse_draw2d_Connection_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const ConnectionLocator__Lorg_eclipse_draw2d_Connection_2 : int = 0;
  public static const ConnectionLocator__Lorg_eclipse_draw2d_Connection_2I : int = 1;
}
}
