package org.eclipse.draw2d {
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.Math__;
dynamic public class DefaultRangeModel implements RangeModel {
  public var propertyListeners: PropertyChangeSupport;
  private var minimum: int = 0;
  private var maximum: int = 100;
  private var extent: int = 20;
  private var value: int = 0;
  public function DefaultRangeModel() {
    propertyListeners = new PropertyChangeSupport(this);
    return;
  }
  public function addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    propertyListeners.addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener);
    return;
  }
  public function firePropertyChange__Ljava_lang_String_2II(string: String, oldValue: int, newValue: int): void {
    propertyListeners.firePropertyChange__Ljava_lang_String_2II(string, oldValue, newValue);
    return;
  }
  public function getExtent__(): int {
    return extent;
  }
  public function getMaximum__(): int {
    return maximum;
  }
  public function getMinimum__(): int {
    return minimum;
  }
  public function getValue__(): int {
    return value;
  }
  public function isEnabled__(): Boolean {
    return (this.getMaximum__() - this.getMinimum__()) > this.getExtent__();
  }
  public function removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    propertyListeners.removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener);
  }
  public function setAll__III(min: int, ext: int, max: int): void {
    var oldMin: int = minimum;
    var oldExtent: int = extent;
    var oldMax: int = maximum;
    maximum = max;
    minimum = min;
    extent = ext;
    if (oldMax != max)
      this.firePropertyChange__Ljava_lang_String_2II("maximum", oldMax, max);
    if (oldExtent != ext)
      this.firePropertyChange__Ljava_lang_String_2II("extent", oldExtent, ext);
    if (oldMin != min)
      this.firePropertyChange__Ljava_lang_String_2II("minimum", oldMin, min);
    this.setValue__I(this.getValue__());
  }
  public function setExtent__I(extent_1: int): void {
    if (this.extent == extent_1)
      return;
    var oldValue: int = this.extent;
    this.extent = extent_1;
    this.firePropertyChange__Ljava_lang_String_2II("extent", oldValue, extent_1);
    this.setValue__I(this.getValue__());
  }
  public function setMaximum__I(maximum_1: int): void {
    if (this.maximum == maximum_1)
      return;
    var oldValue: int = this.maximum;
    this.maximum = maximum_1;
    this.firePropertyChange__Ljava_lang_String_2II("maximum", oldValue, maximum_1);
    this.setValue__I(this.getValue__());
  }
  public function setMinimum__I(minimum_1: int): void {
    if (this.minimum == minimum_1)
      return;
    var oldValue: int = this.minimum;
    this.minimum = minimum_1;
    this.firePropertyChange__Ljava_lang_String_2II("minimum", oldValue, minimum_1);
    this.setValue__I(this.getValue__());
  }
  public function setValue__I(value_1: int): void {
    value_1 = Math__.max__II(this.getMinimum__(), Math__.min__II(this.getMaximum__() - this.getExtent__(), value_1));
    if (this.value == value_1)
      return;
    var oldValue: int = this.value;
    this.value = value_1;
    this.firePropertyChange__Ljava_lang_String_2II("value", oldValue, value_1);
  }
  public function toString__(): String {
    return Object(Object.prototype).toString__.call(this) + " (" + minimum + ", " + maximum + ", " + extent + ", " + value + ")";
  }
}
}
