package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Runnable;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class DeferredUpdateManager extends UpdateManager {
  private var damage: Rectangle;
  private var dirtyRegions: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var graphicsSource: GraphicsSource;
  private var invalidFigures: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  private var root: IFigure;
  private var updateQueued: Boolean;
  private var updating: Boolean;
  private var validating: Boolean;
  private var afterUpdate: DeferredUpdateManager$RunnableChain;
  public function DeferredUpdateManager__(): Object {
    return this;
  }
  public function DeferredUpdateManager__Lorg_eclipse_draw2d_GraphicsSource_2(gs: GraphicsSource): Object {
    this.setGraphicsSource__Lorg_eclipse_draw2d_GraphicsSource_2(gs);
    return this;
  }
  public override function addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2IIII(figure: IFigure, x: int, y: int, w: int, h: int): void {
    if (w == 0 || h == 0 || !figure.isShowing__())
      return;
    var rect: Rectangle = Rectangle(dirtyRegions.get__Ljava_lang_Object_2(figure));
    if (rect === null) {
      rect = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [x, y, w, h]));
      dirtyRegions.put__Ljava_lang_Object_2Ljava_lang_Object_2(figure, rect);
    } else
      rect.union__IIII(x, y, w, h);
    this.queueWork__();
    return;
  }
  public override function addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): void {
    if (invalidFigures.contains__Ljava_lang_Object_2(f))
      return;
    this.queueWork__();
    invalidFigures.add__Ljava_lang_Object_2(f);
  }
  public function getGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(region: Rectangle): Graphics {
    if (graphicsSource === null)
      return null;
    return graphicsSource.getGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(region);
  }
  public override function paint__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    if (!validating) {
      var graphics: SWTGraphics = new SWTGraphics(gc);
      if (!updating) {
        var rect: Rectangle = graphics.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, [])));
        var map: HashMap = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
        map.put__Ljava_lang_Object_2Ljava_lang_Object_2(root, rect);
        this.firePainting__Lorg_eclipse_draw2d_geometry_Rectangle_2Ljava_util_Map_2(rect, map);
      }
      this.performValidation__();
      root.paint__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.dispose__();
    } else {
      this.addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(root, new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [gc.getClipping__()])));
    }
    return;
  }
  public override function performUpdate__(): void {
    if (this.isDisposed__() || updating)
      return;
    updating = true;
    try {
      this.performValidation__();
      updateQueued = false;
      this.repairDamage__();
      if (afterUpdate !== null) {
        var chain: DeferredUpdateManager$RunnableChain = afterUpdate;
        afterUpdate = null;
        chain.run__();
        if (afterUpdate !== null)
          this.queueWork__();
      }
    } finally {
      updating = false;
    }
    return;
  }
  public override function performValidation__(): void {
    if (invalidFigures.isEmpty__() || validating)
      return;
    try {
      var fig: IFigure;
      validating = true;
      this.fireValidating__();
      for (var i: int = 0; i < invalidFigures.size__(); i++) {
        fig = IFigure(invalidFigures.get__I(i));
        invalidFigures.set__ILjava_lang_Object_2(i, null);
        fig.validate__();
      }
    } finally {
      invalidFigures.clear__();
      validating = false;
    }
    return;
  }
  public override function performUpdate__Lorg_eclipse_draw2d_geometry_Rectangle_2(exposed: Rectangle): void {
    this.addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(root, exposed);
    this.performUpdate__();
    return;
  }
  public function queueWork__(): void {
    if (!updateQueued) {
      this.sendUpdateRequest__();
      updateQueued = true;
    }
    return;
  }
  public function sendUpdateRequest__(): void {
    var display: Display = Display.getCurrent__();
    if (display === null) {
      throw new SWTException(new Arguments(org.eclipse.swt.SWTException.SWTException__I, [22]));
    }
    display.asyncExec__Ljava_lang_Runnable_2(new DeferredUpdateManager$UpdateRequest(this));
    return;
  }
  public function releaseGraphics__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    graphics.dispose__();
    graphicsSource.flushGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(damage);
    return;
  }
  public function repairDamage__(): void {
    var keys: Iterator = Iterator(dirtyRegions.keySet__().iterator__());
    var contribution: Rectangle;
    var figure: IFigure;
    var walker: IFigure;
    while (keys.hasNext__()) {
      figure = IFigure(keys.next__());
      walker = figure.getParent__();
      contribution = Rectangle(dirtyRegions.get__Ljava_lang_Object_2(figure));
      contribution.intersect__Lorg_eclipse_draw2d_geometry_Rectangle_2(figure.getBounds__());
      while (!contribution.isEmpty__() && walker !== null) {
        walker.translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(contribution);
        contribution.intersect__Lorg_eclipse_draw2d_geometry_Rectangle_2(walker.getBounds__());
        walker = walker.getParent__();
      }
      if (damage === null)
        damage = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [contribution]));
      else
        damage.union__Lorg_eclipse_draw2d_geometry_Rectangle_2(contribution);
    }
    if (!dirtyRegions.isEmpty__()) {
      var oldRegions: Map = dirtyRegions;
      dirtyRegions = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
      this.firePainting__Lorg_eclipse_draw2d_geometry_Rectangle_2Ljava_util_Map_2(damage, oldRegions);
    }
    if (damage !== null && !damage.isEmpty__()) {
      var graphics: Graphics = this.getGraphics__Lorg_eclipse_draw2d_geometry_Rectangle_2(damage);
      if (graphics !== null) {
        root.paint__Lorg_eclipse_draw2d_Graphics_2(graphics);
        this.releaseGraphics__Lorg_eclipse_draw2d_Graphics_2(graphics);
      }
    }
    damage = null;
    return;
  }
  public override function runWithUpdate__Ljava_lang_Runnable_2(runnable: Runnable): void {
    afterUpdate = new DeferredUpdateManager$RunnableChain(runnable, afterUpdate);
    if (!updating)
      this.queueWork__();
    return;
  }
  public override function setGraphicsSource__Lorg_eclipse_draw2d_GraphicsSource_2(gs: GraphicsSource): void {
    graphicsSource = gs;
    return;
  }
  public override function setRoot__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    root = figure;
    return;
  }
  public function validateFigures__(): void {
    this.performValidation__();
    return;
  }
  public function DeferredUpdateManager(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is GraphicsSource) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        DeferredUpdateManager__();
        break;
      case 1:
        DeferredUpdateManager__Lorg_eclipse_draw2d_GraphicsSource_2(args1[0]);
        break;
    }
  }
  public static const DeferredUpdateManager__ : int = 0;
  public static const DeferredUpdateManager__Lorg_eclipse_draw2d_GraphicsSource_2 : int = 1;
}
}
