package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class EllipseAnchor extends AbstractConnectionAnchor {
  public function EllipseAnchor__(): Object {
    return this;
  }
  public function EllipseAnchor__Lorg_eclipse_draw2d_IFigure_2(owner: IFigure): Object {
    return this;
  }
  public override function getLocation__Lorg_eclipse_draw2d_geometry_Point_2(reference: Point): Point {
    var r: Rectangle = Rectangle.SINGLETON;
    r.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getOwner__().getBounds__());
    r.translate__II(-1, -1);
    r.resize__II(1, 1);
    this.getOwner__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(r);
    var ref: Point = r.getCenter__().negate__().translate__Lorg_eclipse_draw2d_geometry_Point_2(reference);
    if (ref.x == 0)
      return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [reference.x, (ref.y > 0) ? r.bottom__() : r.y]));
    if (ref.y == 0)
      return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [(ref.x > 0) ? r.right__() : r.x, reference.y]));
    var dx: Number = (ref.x > 0) ? 0.5 : -0.5;
    var dy: Number = (ref.y > 0) ? 0.5 : -0.5;
    var k: Number = Number((ref.y * r.width)) / (ref.x * r.height);
    k = k * k;
    return r.getCenter__().translate__II(int((r.width * dx / Math__.sqrt__D(1 + k))), int((r.height * dy / Math__.sqrt__D(1 + 1 / k))));
  }
  public function EllipseAnchor(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is IFigure) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.AbstractConnectionAnchor.AbstractConnectionAnchor__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.AbstractConnectionAnchor.AbstractConnectionAnchor__Lorg_eclipse_draw2d_IFigure_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        EllipseAnchor__();
        break;
      case 1:
        EllipseAnchor__Lorg_eclipse_draw2d_IFigure_2(args1[0]);
        break;
    }
  }
  public static const EllipseAnchor__ : int = 0;
  public static const EllipseAnchor__Lorg_eclipse_draw2d_IFigure_2 : int = 1;
}
}
