package org.eclipse.draw2d {
import java.util.Iterator;
import java.util.Iterator;
import java.lang.Class__;
import java.lang.UnsupportedOperationException;
import java.lang.IllegalArgumentException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class EventListenerList {
  private var array: JavaArray;
  public function addListener__Ljava_lang_Class_2Ljava_lang_Object_2(c: Class__, listener: Object): void {
    if (listener === null || c === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    var oldSize: int = (array === null) ? 0 : array.length;
    var newArray: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(oldSize + 2);
    if (oldSize != 0)
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(array, 0, newArray, 0, oldSize);
    newArray[oldSize++] = c;
    newArray[oldSize] = listener;
    array = newArray;
  }
  public function containsListener__Ljava_lang_Class_2(c: Class__): Boolean {
    if (array === null)
      return false;
    for (var i: int = 0; i < array.length; i += 2)
      if (array[i] === c)
        return true;
    return false;
  }
  public function getListeners__Ljava_lang_Class_2(listenerType: Class__): Iterator {
    return new EventListenerList$TypeIterator(array, listenerType);
  }
  public function removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(c: Class__, listener: Object): void {
    if (array === null || array.length == 0)
      return;
    if (listener === null || c === null)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__, []));
    var index: int = 0;
    while (index < array.length) {
      if (array[index] === c && array[index + 1] === listener)
        break;
      index += 2;
    }
    if (index == array.length)
      return;
    var newArray: JavaArray = new JavaArray("[Ljava/lang/Object;").lengths(array.length - 2);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(array, 0, newArray, 0, index);
    System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(array, index + 2, newArray, index, array.length - index - 2);
    array = newArray;
  }
}
}
