package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import java.lang.Arguments;
dynamic public class FanRouter extends AutomaticRouter {
  private var separation: int = 10;
  public function getSeparation__(): int {
    return separation;
  }
  public override function handleCollision__Lorg_eclipse_draw2d_geometry_PointList_2I(points: PointList, index: int): void {
    var start: Point = points.getFirstPoint__();
    var end: Point = points.getLastPoint__();
    if (start.equals__Ljava_lang_Object_2(end))
      return;
    var midPoint: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [int((end.x + start.x) / 2), int((end.y + start.y) / 2)]));
    var position: int = end.getPosition__Lorg_eclipse_draw2d_geometry_Point_2(start);
    var ray: Ray;
    if (position == 4 || position == 16)
      ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [start, end]));
    else
      ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2, [end, start]));
    var length: Number = ray.length__();
    var xSeparation: Number = separation * ray.x / length;
    var ySeparation: Number = separation * ray.y / length;
    var bendPoint: Point;
    if (index % 2 == 0) {
      bendPoint = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__DD, [midPoint.x + (int(index / 2)) * (-1 * ySeparation), midPoint.y + (int(index / 2)) * xSeparation]));
    } else {
      bendPoint = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__DD, [midPoint.x + (int(index / 2)) * ySeparation, midPoint.y + (int(index / 2)) * (-1 * xSeparation)]));
    }
    if (!bendPoint.equals__Ljava_lang_Object_2(midPoint))
      points.insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(bendPoint, 1);
    return;
  }
  public function setSeparation__I(value: int): void {
    separation = value;
    return;
  }
}
}
