package org.eclipse.draw2d {
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import java.util.List;
import java.util.ArrayList;
import java.lang.Integer;
import java.lang.IndexOutOfBoundsException;
import java.lang.IllegalArgumentException;
import java.lang.Class__;
import java.lang.RuntimeException;
import java.util.Collection;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.Class__;
dynamic public class Figure implements IFigure {
  public static var PRIVATE_RECT: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
  public static var PRIVATE_POINT: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
  public static var FLAG_VALID: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1])).intValue__();
  public static var FLAG_OPAQUE: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1 << 1])).intValue__();
  public static var FLAG_VISIBLE: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1 << 2])).intValue__();
  public static var FLAG_FOCUSABLE: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1 << 3])).intValue__();
  public static var FLAG_ENABLED: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1 << 4])).intValue__();
  public static var FLAG_FOCUS_TRAVERSABLE: int = new Integer(new Arguments(java.lang.Integer.Integer__I, [1 << 5])).intValue__();
  public static const FLAG_REALIZED: int = 1 << 31;
  public static var MAX_FLAG: int = FLAG_FOCUS_TRAVERSABLE;
  public var bounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, 0, 0]));
  private var layoutManager: LayoutManager;
  public var flags: int = FLAG_VISIBLE | FLAG_ENABLED;
  private var parent: IFigure;
  private var cursor: Cursor;
  private var propertyListeners: PropertyChangeSupport;
  private var eventListeners: EventListenerList = new EventListenerList();
  private var children: List = Collections.EMPTY_LIST;
  public var prefSize: Dimension;
  public var minSize: Dimension;
  public var maxSize: Dimension;
  public var font: Font;
  public var bgColor: Color;
  public var fgColor: Color;
  public var border: Border;
  public var toolTip: IFigure;
  private var ancestorHelper: AncestorHelper;
  public static var NO_MANAGER: UpdateManager = new org.eclipse.draw2d.Figure$1();
  public function add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure: IFigure, constraint: Object): void {
    this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2I(figure, constraint, -1);
  }
  public function add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2I(figure: IFigure, constraint: Object, index: int): void {
    if (children === Collections.EMPTY_LIST)
      children = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [2]));
    if (index < -1 || index > children.size__())
      throw new IndexOutOfBoundsException(new Arguments(java.lang.IndexOutOfBoundsException.IndexOutOfBoundsException__Ljava_lang_String_2, ["Index does not exist"]));
    for (var f: IFigure = this; f !== null; f = f.getParent__())
      if (figure === f)
        throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Figure being added introduces cycle"]));
    if (figure.getParent__() !== null)
      figure.getParent__().remove__Lorg_eclipse_draw2d_IFigure_2(figure);
    if (index == -1)
      children.add__Ljava_lang_Object_2(figure);
    else
      children.add__ILjava_lang_Object_2(index, figure);
    figure.setParent__Lorg_eclipse_draw2d_IFigure_2(this);
    if (layoutManager !== null)
      layoutManager.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure, constraint);
    this.revalidate__();
    if (this.getFlag__I(-2147483648))
      figure.addNotify__();
    figure.repaint__();
  }
  public function add__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2I(figure, null, -1);
  }
  public function add__Lorg_eclipse_draw2d_IFigure_2I(figure: IFigure, index: int): void {
    this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2I(figure, null, index);
  }
  public function addAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(ancestorListener: AncestorListener): void {
    if (ancestorHelper === null)
      ancestorHelper = new AncestorHelper(this);
    ancestorHelper.addAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(ancestorListener);
  }
  public function addCoordinateListener__Lorg_eclipse_draw2d_CoordinateListener_2(listener: CoordinateListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.CoordinateListener"), listener);
  }
  public function addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(listener: FigureListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FigureListener"), listener);
  }
  public function addFocusListener__Lorg_eclipse_draw2d_FocusListener_2(listener: FocusListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FocusListener"), listener);
  }
  public function addKeyListener__Lorg_eclipse_draw2d_KeyListener_2(listener: KeyListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.KeyListener"), listener);
  }
  public function addLayoutListener__Lorg_eclipse_draw2d_LayoutListener_2(listener: LayoutListener): void {
    if (layoutManager is Figure$LayoutNotifier) {
      var notifier: Figure$LayoutNotifier = Figure$LayoutNotifier(layoutManager);
      notifier.listeners.add__Ljava_lang_Object_2(listener);
    } else
      layoutManager = new Figure$LayoutNotifier(this, layoutManager, listener);
    return;
  }
  public function addListener__Ljava_lang_Class_2Ljava_lang_Object_2(clazz: Class__, listener: Object): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(clazz, listener);
    return;
  }
  public function addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(listener: MouseListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener"), listener);
    return;
  }
  public function addMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(listener: MouseMotionListener): void {
    eventListeners.addListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"), listener);
    return;
  }
  public function addNotify__(): void {
    if (this.getFlag__I(-2147483648))
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["addNotify() should not be called multiple times"]));
    this.setFlag__IZ(-2147483648, true);
    for (var i: int = 0; i < children.size__(); i++)
      (IFigure(children.get__I(i))).addNotify__();
    return;
  }
  public function addPropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(property: String, listener: PropertyChangeListener): void {
    if (propertyListeners === null)
      propertyListeners = new PropertyChangeSupport(this);
    propertyListeners.addPropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(property, listener);
    return;
  }
  public function addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    if (propertyListeners === null)
      propertyListeners = new PropertyChangeSupport(this);
    propertyListeners.addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener);
    return;
  }
  public function containsPoint__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): Boolean {
    return this.containsPoint__II(p.x, p.y);
  }
  public function containsPoint__II(x: int, y: int): Boolean {
    return this.getBounds__().contains__II(x, y);
  }
  public function erase__(): void {
    if (this.getParent__() === null || !this.isVisible__())
      return;
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this.getBounds__()]));
    this.getParent__().translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(r);
    this.getParent__().repaint__IIII(r.x, r.y, r.width, r.height);
  }
  public function findDescendantAtExcluding__IILorg_eclipse_draw2d_TreeSearch_2(x: int, y: int, search: TreeSearch): IFigure {
    PRIVATE_POINT.setLocation__II(x, y);
    this.translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(PRIVATE_POINT);
    if (!this.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON).contains__Lorg_eclipse_draw2d_geometry_Point_2(PRIVATE_POINT))
      return null;
    x = PRIVATE_POINT.x;
    y = PRIVATE_POINT.y;
    var fig: IFigure;
    for (var i: int = children.size__(); i > 0;) {
      i--;
      fig = IFigure(children.get__I(i));
      if (fig.isVisible__()) {
        fig = fig.findFigureAt__IILorg_eclipse_draw2d_TreeSearch_2(x, y, search);
        if (fig !== null)
          return fig;
      }
    }
    return null;
  }
  public function findFigureAt__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): IFigure {
    return this.findFigureAtExcluding__IILjava_util_Collection_2(pt.x, pt.y, Collections.EMPTY_LIST);
  }
  public function findFigureAt__II(x: int, y: int): IFigure {
    return this.findFigureAt__IILorg_eclipse_draw2d_TreeSearch_2(x, y, Figure$IdentitySearch.INSTANCE);
  }
  public function findFigureAt__IILorg_eclipse_draw2d_TreeSearch_2(x: int, y: int, search: TreeSearch): IFigure {
    if (!this.containsPoint__II(x, y))
      return null;
    if (search.prune__Lorg_eclipse_draw2d_IFigure_2(this))
      return null;
    var child: IFigure = this.findDescendantAtExcluding__IILorg_eclipse_draw2d_TreeSearch_2(x, y, search);
    if (child !== null)
      return child;
    if (search.accept__Lorg_eclipse_draw2d_IFigure_2(this))
      return this;
    return null;
  }
  public function findFigureAtExcluding__IILjava_util_Collection_2(x: int, y: int, c: Collection): IFigure {
    return this.findFigureAt__IILorg_eclipse_draw2d_TreeSearch_2(x, y, new ExclusionSearch(c));
  }
  public function findMouseEventTargetAt__II(x: int, y: int): IFigure {
    if (!this.containsPoint__II(x, y))
      return null;
    var f: IFigure = this.findMouseEventTargetInDescendantsAt__II(x, y);
    if (f !== null)
      return f;
    if (this.isMouseEventTarget__())
      return this;
    return null;
  }
  public function findMouseEventTargetInDescendantsAt__II(x: int, y: int): IFigure {
    PRIVATE_POINT.setLocation__II(x, y);
    this.translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(PRIVATE_POINT);
    if (!this.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON).contains__Lorg_eclipse_draw2d_geometry_Point_2(PRIVATE_POINT))
      return null;
    var fig: IFigure;
    for (var i: int = children.size__(); i > 0;) {
      i--;
      fig = IFigure(children.get__I(i));
      if (fig.isVisible__() && fig.isEnabled__()) {
        if (fig.containsPoint__II(PRIVATE_POINT.x, PRIVATE_POINT.y)) {
          fig = fig.findMouseEventTargetAt__II(PRIVATE_POINT.x, PRIVATE_POINT.y);
          return fig;
        }
      }
    }
    return null;
  }
  public function fireCoordinateSystemChanged__(): void {
    if (!eventListeners.containsListener__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.CoordinateListener")))
      return;
    var figureListeners: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.CoordinateListener"));
    while (figureListeners.hasNext__())
      (CoordinateListener(figureListeners.next__())).coordinateSystemChanged__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public function fireFigureMoved__(): void {
    if (!eventListeners.containsListener__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FigureListener")))
      return;
    var figureListeners: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FigureListener"));
    while (figureListeners.hasNext__())
      (FigureListener(figureListeners.next__())).figureMoved__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public function fireMoved__(): void {
    this.fireFigureMoved__();
    this.fireCoordinateSystemChanged__();
  }
  public function firePropertyChange__Ljava_lang_String_2ZZ(property: String, old: Boolean, current: Boolean): void {
    if (propertyListeners === null)
      return;
    propertyListeners.firePropertyChange__Ljava_lang_String_2ZZ(property, old, current);
  }
  public function firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2(property: String, old: Object, current: Object): void {
    if (propertyListeners === null)
      return;
    propertyListeners.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2(property, old, current);
  }
  public function firePropertyChange__Ljava_lang_String_2II(property: String, old: int, current: int): void {
    if (propertyListeners === null)
      return;
    propertyListeners.firePropertyChange__Ljava_lang_String_2II(property, old, current);
  }
  public function getBackgroundColor__(): Color {
    if (bgColor === null && this.getParent__() !== null)
      return this.getParent__().getBackgroundColor__();
    return bgColor;
  }
  public function getBorder__(): Border {
    return border;
  }
  public function getBounds__(): Rectangle {
    return bounds;
  }
  public function getChildren__(): List {
    return children;
  }
  public function getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Rectangle {
    rect.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
    rect.crop__Lorg_eclipse_draw2d_geometry_Insets_2(this.getInsets__());
    if (this.useLocalCoordinates__())
      rect.setLocation__II(0, 0);
    return rect;
  }
  public function getClientArea__(): Rectangle {
    return this.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, [])));
  }
  public function getCursor__(): Cursor {
    if (cursor === null && this.getParent__() !== null)
      return this.getParent__().getCursor__();
    return cursor;
  }
  public function getFlag__I(flag: int): Boolean {
    return (flags & flag) != 0;
  }
  public function getFont__(): Font {
    if (font !== null)
      return font;
    if (this.getParent__() !== null)
      return this.getParent__().getFont__();
    return null;
  }
  public function getForegroundColor__(): Color {
    if (fgColor === null && this.getParent__() !== null)
      return this.getParent__().getForegroundColor__();
    return fgColor;
  }
  public function getInsets__(): Insets {
    if (this.getBorder__() !== null)
      return this.getBorder__().getInsets__Lorg_eclipse_draw2d_IFigure_2(this);
    return org.eclipse.draw2d.IFigure$$fields.NO_INSETS;
  }
  public function getLayoutManager__(): LayoutManager {
    if (layoutManager is Figure$LayoutNotifier)
      return (Figure$LayoutNotifier(layoutManager)).realLayout;
    return layoutManager;
  }
  public function getListeners__Ljava_lang_Class_2(clazz: Class__): Iterator {
    if (eventListeners === null)
      return Iterator(Collections.EMPTY_LIST.iterator__());
    return eventListeners.getListeners__Ljava_lang_Class_2(clazz);
  }
  public function getLocalBackgroundColor__(): Color {
    return bgColor;
  }
  public function getLocalFont__(): Font {
    return font;
  }
  public function getLocalForegroundColor__(): Color {
    return fgColor;
  }
  public function getLocation__(): Point {
    return this.getBounds__().getLocation__();
  }
  public function getMaximumSize__(): Dimension {
    if (maxSize !== null)
      return maxSize;
    return org.eclipse.draw2d.IFigure$$fields.MAX_DIMENSION;
  }
  public function getMinimumSize__(): Dimension {
    return this.getMinimumSize__II(-1, -1);
  }
  public function getMinimumSize__II(wHint: int, hHint: int): Dimension {
    if (minSize !== null)
      return minSize;
    if (this.getLayoutManager__() !== null) {
      var d: Dimension = this.getLayoutManager__().getMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(this, wHint, hHint);
      if (d !== null)
        return d;
    }
    return this.getPreferredSize__II(wHint, hHint);
  }
  public function getParent__(): IFigure {
    return parent;
  }
  public function getPreferredSize__(): Dimension {
    return this.getPreferredSize__II(-1, -1);
  }
  public function getPreferredSize__II(wHint: int, hHint: int): Dimension {
    if (prefSize !== null)
      return prefSize;
    if (this.getLayoutManager__() !== null) {
      var d: Dimension = this.getLayoutManager__().getPreferredSize__Lorg_eclipse_draw2d_IFigure_2II(this, wHint, hHint);
      if (d !== null)
        return d;
    }
    return this.getSize__();
  }
  public function getSize__(): Dimension {
    return this.getBounds__().getSize__();
  }
  public function getToolTip__(): IFigure {
    return toolTip;
  }
  public function getUpdateManager__(): UpdateManager {
    if (this.getParent__() !== null)
      return this.getParent__().getUpdateManager__();
    return NO_MANAGER;
  }
  public function handleFocusGained__Lorg_eclipse_draw2d_FocusEvent_2(event: FocusEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FocusListener"));
    while (iter.hasNext__())
      (FocusListener(iter.next__())).focusGained__Lorg_eclipse_draw2d_FocusEvent_2(event);
  }
  public function handleFocusLost__Lorg_eclipse_draw2d_FocusEvent_2(event: FocusEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FocusListener"));
    while (iter.hasNext__())
      (FocusListener(iter.next__())).focusLost__Lorg_eclipse_draw2d_FocusEvent_2(event);
  }
  public function handleKeyPressed__Lorg_eclipse_draw2d_KeyEvent_2(event: KeyEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.KeyListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (KeyListener(iter.next__())).keyPressed__Lorg_eclipse_draw2d_KeyEvent_2(event);
  }
  public function handleKeyReleased__Lorg_eclipse_draw2d_KeyEvent_2(event: KeyEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.KeyListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (KeyListener(iter.next__())).keyReleased__Lorg_eclipse_draw2d_KeyEvent_2(event);
  }
  public function handleMouseDoubleClicked__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseListener(iter.next__())).mouseDoubleClicked__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseDragged__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseMotionListener(iter.next__())).mouseDragged__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseEntered__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseMotionListener(iter.next__())).mouseEntered__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseExited__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseMotionListener(iter.next__())).mouseExited__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseHover__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseMotionListener(iter.next__())).mouseHover__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseMoved__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseMotionListener(iter.next__())).mouseMoved__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMousePressed__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseListener(iter.next__())).mousePressed__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function handleMouseReleased__Lorg_eclipse_draw2d_MouseEvent_2(event: MouseEvent): void {
    var iter: Iterator = eventListeners.getListeners__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener"));
    while (!event.isConsumed__() && iter.hasNext__())
      (MouseListener(iter.next__())).mouseReleased__Lorg_eclipse_draw2d_MouseEvent_2(event);
  }
  public function hasFocus__(): Boolean {
    var dispatcher: EventDispatcher = this.internalGetEventDispatcher__();
    if (dispatcher === null)
      return false;
    return dispatcher.getFocusOwner__() === this;
  }
  public function internalGetEventDispatcher__(): EventDispatcher {
    if (this.getParent__() !== null)
      return this.getParent__().internalGetEventDispatcher__();
    return null;
  }
  public function intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Boolean {
    return this.getBounds__().intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
  }
  public function invalidate__(): void {
    if (layoutManager !== null)
      layoutManager.invalidate__();
    this.setValid__Z(false);
  }
  public function invalidateTree__(): void {
    this.invalidate__();
    for (var iter: Iterator = Iterator(children.iterator__()); iter.hasNext__();) {
      var child: IFigure = IFigure(iter.next__());
      child.invalidateTree__();
    }
    return;
  }
  public function isCoordinateSystem__(): Boolean {
    return this.useLocalCoordinates__();
  }
  public function isEnabled__(): Boolean {
    return (flags & FLAG_ENABLED) != 0;
  }
  public function isFocusTraversable__(): Boolean {
    return (flags & FLAG_FOCUS_TRAVERSABLE) != 0;
  }
  public function isMouseEventTarget__(): Boolean {
    return (eventListeners.containsListener__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener")) || eventListeners.containsListener__Ljava_lang_Class_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener")));
  }
  public function isMirrored__(): Boolean {
    if (this.getParent__() !== null)
      return this.getParent__().isMirrored__();
    return false;
  }
  public function isOpaque__(): Boolean {
    return (flags & FLAG_OPAQUE) != 0;
  }
  public function isRequestFocusEnabled__(): Boolean {
    return (flags & FLAG_FOCUSABLE) != 0;
  }
  public function isShowing__(): Boolean {
    return this.isVisible__() && (this.getParent__() === null || this.getParent__().isShowing__());
  }
  public function isValid__(): Boolean {
    return (flags & FLAG_VALID) != 0;
  }
  public function isValidationRoot__(): Boolean {
    return false;
  }
  public function isVisible__(): Boolean {
    return this.getFlag__I(FLAG_VISIBLE);
  }
  public function layout__(): void {
    if (layoutManager !== null)
      layoutManager.layout__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public function paint__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.getLocalBackgroundColor__() !== null)
      graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(this.getLocalBackgroundColor__());
    if (this.getLocalForegroundColor__() !== null)
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(this.getLocalForegroundColor__());
    if (font !== null)
      graphics.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
    graphics.pushState__();
    try {
      this.paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.restoreState__();
      this.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics);
      this.paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics);
    } finally {
      graphics.popState__();
    }
    return;
  }
  public function paintBorder__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.getBorder__() !== null)
      this.getBorder__().paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(this, graphics, org.eclipse.draw2d.IFigure$$fields.NO_INSETS);
    return;
  }
  public function paintChildren__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    var child: IFigure;
    var clip: Rectangle = Rectangle.SINGLETON;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      if (child.isVisible__() && child.intersects__Lorg_eclipse_draw2d_geometry_Rectangle_2(graphics.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(clip))) {
        graphics.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(child.getBounds__());
        child.paint__Lorg_eclipse_draw2d_Graphics_2(graphics);
        graphics.restoreState__();
      }
    }
    return;
  }
  public function paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (children.isEmpty__())
      return;
    var optimizeClip: Boolean = this.getBorder__() === null || this.getBorder__().isOpaque__();
    if (this.useLocalCoordinates__()) {
      graphics.translate__II(this.getBounds__().x + this.getInsets__().left, this.getBounds__().y + this.getInsets__().top);
      if (!optimizeClip)
        graphics.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(PRIVATE_RECT));
      graphics.pushState__();
      this.paintChildren__Lorg_eclipse_draw2d_Graphics_2(graphics);
      graphics.popState__();
      graphics.restoreState__();
    } else {
      if (optimizeClip)
        this.paintChildren__Lorg_eclipse_draw2d_Graphics_2(graphics);
      else {
        graphics.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(PRIVATE_RECT));
        graphics.pushState__();
        this.paintChildren__Lorg_eclipse_draw2d_Graphics_2(graphics);
        graphics.popState__();
        graphics.restoreState__();
      }
    }
    return;
  }
  public function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.isOpaque__())
      graphics.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
    if (this.getBorder__() is AbstractBackground)
      (AbstractBackground(this.getBorder__())).paintBackground__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(this, graphics, org.eclipse.draw2d.IFigure$$fields.NO_INSETS);
    return;
  }
  public function primTranslate__II(dx: int, dy: int): void {
    bounds.x += dx;
    bounds.y += dy;
    if (this.useLocalCoordinates__()) {
      this.fireCoordinateSystemChanged__();
      return;
    }
    for (var i: int = 0; i < children.size__(); i++)
      (IFigure(children.get__I(i))).translate__II(dx, dy);
    return;
  }
  public function remove__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    if ((figure.getParent__() !== this))
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Figure is not a child"]));
    if (this.getFlag__I(-2147483648))
      figure.removeNotify__();
    if (layoutManager !== null)
      layoutManager.remove__Lorg_eclipse_draw2d_IFigure_2(figure);
    figure.erase__();
    figure.setParent__Lorg_eclipse_draw2d_IFigure_2(null);
    children.remove__Ljava_lang_Object_2(figure);
    this.revalidate__();
    return;
  }
  public function removeAll__(): void {
    var list: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__Ljava_util_Collection_2, [this.getChildren__()]));
    for (var i: int = 0; i < list.size__(); i++) {
      this.remove__Lorg_eclipse_draw2d_IFigure_2(IFigure(list.get__I(i)));
    }
    return;
  }
  public function removeAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(listener: AncestorListener): void {
    if (ancestorHelper !== null) {
      ancestorHelper.removeAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(listener);
      if (ancestorHelper.isEmpty__()) {
        ancestorHelper.dispose__();
        ancestorHelper = null;
      }
    }
    return;
  }
  public function removeCoordinateListener__Lorg_eclipse_draw2d_CoordinateListener_2(listener: CoordinateListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.CoordinateListener"), listener);
    return;
  }
  public function removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(listener: FigureListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FigureListener"), listener);
    return;
  }
  public function removeFocusListener__Lorg_eclipse_draw2d_FocusListener_2(listener: FocusListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.FocusListener"), listener);
    return;
  }
  public function removeKeyListener__Lorg_eclipse_draw2d_KeyListener_2(listener: KeyListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.KeyListener"), listener);
    return;
  }
  public function removeLayoutListener__Lorg_eclipse_draw2d_LayoutListener_2(listener: LayoutListener): void {
    if (layoutManager is Figure$LayoutNotifier) {
      var notifier: Figure$LayoutNotifier = Figure$LayoutNotifier(layoutManager);
      notifier.listeners.remove__Ljava_lang_Object_2(listener);
      if (notifier.listeners.isEmpty__())
        layoutManager = notifier.realLayout;
    }
    return;
  }
  public function removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(clazz: Class__, listener: Object): void {
    if (eventListeners === null)
      return;
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(clazz, listener);
  }
  public function removeMouseListener__Lorg_eclipse_draw2d_MouseListener_2(listener: MouseListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseListener"), listener);
  }
  public function removeMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(listener: MouseMotionListener): void {
    eventListeners.removeListener__Ljava_lang_Class_2Ljava_lang_Object_2(Class__.forName__Ljava_lang_String_2("org.eclipse.draw2d.MouseMotionListener"), listener);
  }
  public function removeNotify__(): void {
    for (var i: int = 0; i < children.size__(); i++)
      (IFigure(children.get__I(i))).removeNotify__();
    if (this.internalGetEventDispatcher__() !== null)
      this.internalGetEventDispatcher__().requestRemoveFocus__Lorg_eclipse_draw2d_IFigure_2(this);
    this.setFlag__IZ(-2147483648, false);
  }
  public function removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener: PropertyChangeListener): void {
    if (propertyListeners === null)
      return;
    propertyListeners.removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(listener);
  }
  public function removePropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(property: String, listener: PropertyChangeListener): void {
    if (propertyListeners === null)
      return;
    propertyListeners.removePropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2(property, listener);
  }
  public function repaint__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): void {
    this.repaint__IIII(rect.x, rect.y, rect.width, rect.height);
  }
  public function repaint__IIII(x: int, y: int, w: int, h: int): void {
    if (this.isVisible__())
      this.getUpdateManager__().addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2IIII(this, x, y, w, h);
  }
  public function repaint__(): void {
    this.repaint__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
  }
  public function requestFocus__(): void {
    if (!this.isRequestFocusEnabled__() || this.hasFocus__())
      return;
    var dispatcher: EventDispatcher = this.internalGetEventDispatcher__();
    if (dispatcher === null)
      return;
    dispatcher.requestFocus__Lorg_eclipse_draw2d_IFigure_2(this);
  }
  public function revalidate__(): void {
    this.invalidate__();
    if (this.getParent__() === null || this.isValidationRoot__())
      this.getUpdateManager__().addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(this);
    else
      this.getParent__().revalidate__();
  }
  public function setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(bg: Color): void {
    bgColor = bg;
    this.repaint__();
  }
  public function setBorder__Lorg_eclipse_draw2d_Border_2(border_1: Border): void {
    this.border = border_1;
    this.revalidate__();
    this.repaint__();
  }
  public function setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): void {
    var x: int = bounds.x;
    var y: int = bounds.y;
    var resize: Boolean = (rect.width != bounds.width) || (rect.height != bounds.height);
    var translate: Boolean = (rect.x != x) || (rect.y != y);
    if ((resize || translate) && this.isVisible__())
      this.erase__();
    if (translate) {
      var dx: int = rect.x - x;
      var dy: int = rect.y - y;
      this.primTranslate__II(dx, dy);
    }
    bounds.width = rect.width;
    bounds.height = rect.height;
    if (translate || resize) {
      if (resize)
        this.invalidate__();
      this.fireFigureMoved__();
      this.repaint__();
    }
    return;
  }
  public function setChildrenDirection__I(direction: int): void {
    var iterator: Figure$FigureIterator = new Figure$FigureIterator(this);
    var child: IFigure;
    while (iterator.hasNext__()) {
      child = iterator.nextFigure__();
      if (child is Orientable)
        (Orientable(child)).setDirection__I(direction);
    }
    return;
  }
  public function setChildrenEnabled__Z(value: Boolean): void {
    var iterator: Figure$FigureIterator = new Figure$FigureIterator(this);
    while (iterator.hasNext__())
      iterator.nextFigure__().setEnabled__Z(value);
    return;
  }
  public function setChildrenOrientation__I(orientation: int): void {
    var iterator: Figure$FigureIterator = new Figure$FigureIterator(this);
    var child: IFigure;
    while (iterator.hasNext__()) {
      child = iterator.nextFigure__();
      if (child is Orientable)
        (Orientable(child)).setOrientation__I(orientation);
    }
    return;
  }
  public function setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(child: IFigure, constraint: Object): void {
    if (child.getParent__() !== this)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Figure must be a child"]));
    if (layoutManager !== null)
      layoutManager.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(child, constraint);
    this.revalidate__();
    return;
  }
  public function setCursor__Lorg_eclipse_swt_graphics_Cursor_2(cursor_1: Cursor): void {
    if (this.cursor === cursor_1)
      return;
    this.cursor = cursor_1;
    var dispatcher: EventDispatcher = this.internalGetEventDispatcher__();
    if (dispatcher !== null)
      dispatcher.updateCursor__();
  }
  public function setEnabled__Z(value: Boolean): void {
    if (this.isEnabled__() == value)
      return;
    this.setFlag__IZ(FLAG_ENABLED, value);
  }
  public function setFlag__IZ(flag: int, value: Boolean): void {
    if (value)
      flags |= flag;
    else
      flags &= ~flag;
  }
  public function setFocusTraversable__Z(focusTraversable: Boolean): void {
    if (this.isFocusTraversable__() == focusTraversable)
      return;
    this.setFlag__IZ(FLAG_FOCUS_TRAVERSABLE, focusTraversable);
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): void {
    if (font !== f) {
      font = f;
      this.revalidate__();
      this.repaint__();
    }
    return;
  }
  public function setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(fg: Color): void {
    if (fgColor !== null && fgColor.equals__Ljava_lang_Object_2(fg))
      return;
    fgColor = fg;
    this.repaint__();
  }
  public function setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(manager: LayoutManager): void {
    if (layoutManager is Figure$LayoutNotifier)
      (Figure$LayoutNotifier(layoutManager)).realLayout = manager;
    else
      layoutManager = manager;
    this.revalidate__();
  }
  public function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    if (this.getLocation__().equals__Ljava_lang_Object_2(p))
      return;
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this.getBounds__()]));
    r.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(p);
    this.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
  }
  public function setMaximumSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): void {
    if (maxSize !== null && maxSize.equals__Ljava_lang_Object_2(d))
      return;
    maxSize = d;
    this.revalidate__();
  }
  public function setMinimumSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): void {
    if (minSize !== null && minSize.equals__Ljava_lang_Object_2(d))
      return;
    minSize = d;
    this.revalidate__();
  }
  public function setOpaque__Z(opaque: Boolean): void {
    if (this.isOpaque__() == opaque)
      return;
    this.setFlag__IZ(FLAG_OPAQUE, opaque);
    this.repaint__();
  }
  public function setParent__Lorg_eclipse_draw2d_IFigure_2(p: IFigure): void {
    var oldParent: IFigure = parent;
    parent = p;
    this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("parent", oldParent, p);
  }
  public function setPreferredSize__Lorg_eclipse_draw2d_geometry_Dimension_2(size: Dimension): void {
    if (prefSize !== null && prefSize.equals__Ljava_lang_Object_2(size))
      return;
    prefSize = size;
    this.revalidate__();
  }
  public function setPreferredSize__II(w: int, h: int): void {
    this.setPreferredSize__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [w, h])));
  }
  public function setRequestFocusEnabled__Z(requestFocusEnabled: Boolean): void {
    if (this.isRequestFocusEnabled__() == requestFocusEnabled)
      return;
    this.setFlag__IZ(FLAG_FOCUSABLE, requestFocusEnabled);
  }
  public function setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): void {
    this.setSize__II(d.width, d.height);
  }
  public function setSize__II(w: int, h: int): void {
    var bounds_1: Rectangle = this.getBounds__();
    if (bounds_1.width == w && bounds_1.height == h)
      return;
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this.getBounds__()]));
    r.setSize__II(w, h);
    this.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
  }
  public function setToolTip__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): void {
    if (toolTip === f)
      return;
    toolTip = f;
  }
  public function setValid__Z(value: Boolean): void {
    this.setFlag__IZ(FLAG_VALID, value);
  }
  public function setVisible__Z(visible: Boolean): void {
    var currentVisibility: Boolean = this.isVisible__();
    if (visible == currentVisibility)
      return;
    if (currentVisibility)
      this.erase__();
    this.setFlag__IZ(FLAG_VISIBLE, visible);
    if (visible)
      this.repaint__();
    this.revalidate__();
  }
  public function translate__II(x: int, y: int): void {
    this.primTranslate__II(x, y);
    this.fireFigureMoved__();
  }
  public function translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (this.useLocalCoordinates__())
      t.performTranslate__II(-this.getBounds__().x - this.getInsets__().left, -this.getBounds__().y - this.getInsets__().top);
  }
  public function translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (this.getParent__() !== null) {
      this.getParent__().translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
      this.getParent__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
    }
    return;
  }
  public function translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (this.useLocalCoordinates__())
      t.performTranslate__II(this.getBounds__().x + this.getInsets__().left, this.getBounds__().y + this.getInsets__().top);
    return;
  }
  public function translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    if (this.getParent__() !== null) {
      this.getParent__().translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
      this.getParent__().translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t);
    }
    return;
  }
  public function useLocalCoordinates__(): Boolean {
    return false;
  }
  public function validate__(): void {
    if (this.isValid__())
      return;
    this.setValid__Z(true);
    this.layout__();
    for (var i: int = 0; i < children.size__(); i++)
      (IFigure(children.get__I(i))).validate__();
  }
}
}
