package org.eclipse.draw2d {
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.IllegalArgumentException;
import org.eclipse.swt.graphics.Point;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FigureCanvas extends Canvas {
  public static const ACCEPTED_STYLES: int = 67108864 | 33554432 | 512 | 256 | 262144 | 1048576 | 536870912 | 2048;
  public static const DEFAULT_STYLES: int = 1048576 | 262144 | 512 | 256;
  public static const REQUIRED_STYLES: int = 1048576 | 512 | 256;
  public static var NEVER: int = 0;
  public static var AUTOMATIC: int = 1;
  public static var ALWAYS: int = 2;
  private var vBarVisibility: int = AUTOMATIC;
  private var hBarVisibility: int = AUTOMATIC;
  private var viewport: Viewport;
  private var font: Font;
  private var hBarOffset: int;
  private var vBarOffset: int;
  private var horizontalChangeListener: PropertyChangeListener;
  private var verticalChangeListener: PropertyChangeListener;
  private var lws: LightweightSystem;
  public function FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2(parent: Composite): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    return this;
  }
  public function FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2I(parent: Composite, style: int): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    return this;
  }
  public function FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2(style: int, parent: Composite): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    return this;
  }
  public function FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(parent: Composite, lws: LightweightSystem): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    return this;
  }
  public function FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(style: int, parent: Composite, lws: LightweightSystem): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    this.getHorizontalBar__().setVisible__Z(false);
    this.getVerticalBar__().setVisible__Z(false);
    this.lws = lws;
    lws.setControl__Lorg_eclipse_swt_widgets_Canvas_2(this);
    this.hook__();
    return this;
  }
  public function FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2(parent: Composite, style: int, lws: LightweightSystem): Object {
    horizontalChangeListener = new org.eclipse.draw2d.FigureCanvas$1(FigureCanvas(this));
    verticalChangeListener = new org.eclipse.draw2d.FigureCanvas$2(FigureCanvas(this));
    return this;
  }
  private static function checkStyle__I(style: int): int {
    if ((style & 1049344) != 1049344)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Required style missing on FigureCanvas"]));
    if ((style & ~638847744) != 0)
      throw new IllegalArgumentException(new Arguments(java.lang.IllegalArgumentException.IllegalArgumentException__Ljava_lang_String_2, ["Invalid style being set on FigureCanvas"]));
    return style;
  }
  public override function computeSize__IIZ(wHint: int, hHint: int, changed: Boolean): org.eclipse.swt.graphics.Point {
    var borderSize: int = this.computeTrim__IIII(0, 0, 0, 0).x * -2;
    if (wHint >= 0)
      wHint = Math__.max__II(0, wHint - borderSize);
    if (hHint >= 0)
      hHint = Math__.max__II(0, hHint - borderSize);
    var size: Dimension = this.getLightweightSystem__().getRootFigure__().getPreferredSize__II(wHint, hHint).getExpanded__II(borderSize, borderSize);
    size.union__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [wHint, hHint])));
    return new org.eclipse.swt.graphics.Point(size.width, size.height);
  }
  public function getContents__(): IFigure {
    return this.getViewport__().getContents__();
  }
  public override function getFont__(): Font {
    if (font === null)
      font = super.getFont__();
    return font;
  }
  public function getHorizontalScrollBarVisibility__(): int {
    return hBarVisibility;
  }
  public function getLightweightSystem__(): LightweightSystem {
    return lws;
  }
  public function getVerticalScrollBarVisibility__(): int {
    return vBarVisibility;
  }
  public function getViewport__(): Viewport {
    if (viewport === null)
      this.setViewport__Lorg_eclipse_draw2d_Viewport_2(new Viewport(new Arguments(org.eclipse.draw2d.Viewport.Viewport__Z, [true])));
    return viewport;
  }
  private function hook__(): void {
    this.getLightweightSystem__().getUpdateManager__().addUpdateListener__Lorg_eclipse_draw2d_UpdateListener_2(new org.eclipse.draw2d.FigureCanvas$3(this));
    this.getHorizontalBar__().addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.draw2d.FigureCanvas$4(this));
    this.getVerticalBar__().addSelectionListener__Lorg_eclipse_swt_events_SelectionListener_2(new org.eclipse.draw2d.FigureCanvas$5(this));
  }
  private function hookViewport__(): void {
    this.getViewport__().getHorizontalRangeModel__().addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(horizontalChangeListener);
    this.getViewport__().getVerticalRangeModel__().addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(verticalChangeListener);
  }
  private function unhookViewport__(): void {
    this.getViewport__().getHorizontalRangeModel__().removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(horizontalChangeListener);
    this.getViewport__().getVerticalRangeModel__().removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(verticalChangeListener);
  }
  private function layoutViewport__(): void {
    var result: ScrollPaneSolver$Result;
    result = ScrollPaneSolver.solve__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_Viewport_2IIII(new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [this.getBounds__()])).setLocation__II(0, 0), this.getViewport__(), this.getHorizontalScrollBarVisibility__(), this.getVerticalScrollBarVisibility__(), this.computeTrim__IIII(0, 0, 0, 0).width, this.computeTrim__IIII(0, 0, 0, 0).height);
    this.getLightweightSystem__().setIgnoreResize__Z(true);
    try {
      if (this.getHorizontalBar__().getVisible__() != result.showH)
        this.getHorizontalBar__().setVisible__Z(result.showH);
      if (this.getVerticalBar__().getVisible__() != result.showV)
        this.getVerticalBar__().setVisible__Z(result.showV);
      var r: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [this.getClientArea__()]));
      r.setLocation__II(0, 0);
      this.getLightweightSystem__().getRootFigure__().setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    } finally {
      this.getLightweightSystem__().setIgnoreResize__Z(false);
    }
    return;
  }
  public function scrollSmoothTo__II(x_1: int, y_1: int): void {
    x_1 = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getHorizontalRangeModel__(), x_1);
    y_1 = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getVerticalRangeModel__(), y_1);
    var oldX: int = this.getViewport__().getViewLocation__().x;
    var oldY: int = this.getViewport__().getViewLocation__().y;
    var dx: int = x_1 - oldX;
    var dy: int = y_1 - oldY;
    if (dx == 0 && dy == 0)
      return;
    var viewingArea: Dimension = this.getViewport__().getClientArea__().getSize__();
    var minFrames: int = 3;
    var maxFrames: int = 6;
    if (dx == 0 || dy == 0) {
      minFrames = 6;
      maxFrames = 13;
    }
    var frames: int = int((Math__.abs__I(dx) + Math__.abs__I(dy)) / 15);
    frames = Math__.max__II(frames, minFrames);
    frames = Math__.min__II(frames, maxFrames);
    var stepX: int = Math__.min__II((int(dx / frames)), (int(viewingArea.width / 3)));
    var stepY: int = Math__.min__II((int(dy / frames)), (int(viewingArea.height / 3)));
    for (var i: int = 1; i < frames; i++) {
      this.scrollTo__II(oldX + i * stepX, oldY + i * stepY);
      this.getViewport__().getUpdateManager__().performUpdate__();
    }
    this.scrollTo__II(x_1, y_1);
    return;
  }
  public function scrollTo__II(x_1: int, y_1: int): void {
    x_1 = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getHorizontalRangeModel__(), x_1);
    y_1 = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getVerticalRangeModel__(), y_1);
    if (x_1 == this.getViewport__().getViewLocation__().x)
      this.scrollToY__I(y_1);
    else if (y_1 == this.getViewport__().getViewLocation__().y)
      this.scrollToX__I(x_1);
    else
      this.getViewport__().setViewLocation__II(x_1, y_1);
    return;
  }
  public function scrollToX__I(hOffset: int): void {
    hOffset = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getHorizontalRangeModel__(), hOffset);
    var hOffsetOld: int = this.getViewport__().getViewLocation__().x;
    if (hOffset == hOffsetOld)
      return;
    var dx: int = -hOffset + hOffsetOld;
    var clientArea: org.eclipse.draw2d.geometry.Rectangle = this.getViewport__().getBounds__().getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(this.getViewport__().getInsets__());
    var blit: org.eclipse.draw2d.geometry.Rectangle = clientArea.getResized__II(-Math__.abs__I(dx), 0);
    var expose: org.eclipse.draw2d.geometry.Rectangle = clientArea.getCopy__();
    var dest: org.eclipse.draw2d.geometry.Point = clientArea.getTopLeft__();
    expose.width = Math__.abs__I(dx);
    if (dx < 0) {
      blit.translate__II(-dx, 0);
      expose.x = dest.x + blit.width;
    } else
      dest.x += dx;
    var children_1: JavaArray = this.getChildren__();
    var manualMove: JavaArray = new JavaArray("[Z").lengths(children_1.length);
    for (var i: int = 0; i < children_1.length; i++) {
      var bounds: org.eclipse.swt.graphics.Rectangle = children_1[i].getBounds__();
      manualMove[i] = blit.width <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
    }
    this.scroll__IIIIIIZ(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
    for (var i_1: int = 0; i_1 < children_1.length; i_1++) {
      if (children_1[i_1].isDisposed__())
        continue;
      var bounds_1: org.eclipse.swt.graphics.Rectangle = children_1[i_1].getBounds__();
      if (manualMove[i_1])
        children_1[i_1].setBounds__IIII(bounds_1.x + dx, bounds_1.y, bounds_1.width, bounds_1.height);
    }
    this.getViewport__().setIgnoreScroll__Z(true);
    this.getViewport__().setHorizontalLocation__I(hOffset);
    this.getViewport__().setIgnoreScroll__Z(false);
    this.redraw__IIIIZ(expose.x, expose.y, expose.width, expose.height, true);
    return;
  }
  public function scrollToY__I(vOffset: int): void {
    vOffset = this.verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(this.getViewport__().getVerticalRangeModel__(), vOffset);
    var vOffsetOld: int = this.getViewport__().getViewLocation__().y;
    if (vOffset == vOffsetOld)
      return;
    var dy: int = -vOffset + vOffsetOld;
    var clientArea: org.eclipse.draw2d.geometry.Rectangle = this.getViewport__().getBounds__().getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(this.getViewport__().getInsets__());
    var blit: org.eclipse.draw2d.geometry.Rectangle = clientArea.getResized__II(0, -Math__.abs__I(dy));
    var expose: org.eclipse.draw2d.geometry.Rectangle = clientArea.getCopy__();
    var dest: org.eclipse.draw2d.geometry.Point = clientArea.getTopLeft__();
    expose.height = Math__.abs__I(dy);
    if (dy < 0) {
      blit.translate__II(0, -dy);
      expose.y = dest.y + blit.height;
    } else
      dest.y += dy;
    var children_1: JavaArray = this.getChildren__();
    var manualMove: JavaArray = new JavaArray("[Z").lengths(children_1.length);
    for (var i: int = 0; i < children_1.length; i++) {
      var bounds: org.eclipse.swt.graphics.Rectangle = children_1[i].getBounds__();
      manualMove[i] = blit.height <= 0 || bounds.x > blit.x + blit.width || bounds.y > blit.y + blit.height || bounds.x + bounds.width < blit.x || bounds.y + bounds.height < blit.y;
    }
    this.scroll__IIIIIIZ(dest.x, dest.y, blit.x, blit.y, blit.width, blit.height, true);
    for (var i_1: int = 0; i_1 < children_1.length; i_1++) {
      if (children_1[i_1].isDisposed__())
        continue;
      var bounds_1: org.eclipse.swt.graphics.Rectangle = children_1[i_1].getBounds__();
      if (manualMove[i_1])
        children_1[i_1].setBounds__IIII(bounds_1.x, bounds_1.y + dy, bounds_1.width, bounds_1.height);
    }
    this.getViewport__().setIgnoreScroll__Z(true);
    this.getViewport__().setVerticalLocation__I(vOffset);
    this.getViewport__().setIgnoreScroll__Z(false);
    this.redraw__IIIIZ(expose.x, expose.y, expose.width, expose.height, true);
    return;
  }
  public function setBorder__Lorg_eclipse_draw2d_Border_2(border: Border): void {
    this.getLightweightSystem__().getRootFigure__().setBorder__Lorg_eclipse_draw2d_Border_2(border);
    return;
  }
  public function setContents__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    this.getViewport__().setContents__Lorg_eclipse_draw2d_IFigure_2(figure);
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.font = font_1;
    super.setFont__Lorg_eclipse_swt_graphics_Font_2(font_1);
    return;
  }
  public function setHorizontalScrollBarVisibility__I(v: int): void {
    hBarVisibility = v;
    return;
  }
  public function setScrollBarVisibility__I(both: int): void {
    this.setHorizontalScrollBarVisibility__I(both);
    this.setVerticalScrollBarVisibility__I(both);
    return;
  }
  public function setVerticalScrollBarVisibility__I(v: int): void {
    vBarVisibility = v;
    return;
  }
  public function setViewport__Lorg_eclipse_draw2d_Viewport_2(vp: Viewport): void {
    if (viewport !== null)
      this.unhookViewport__();
    viewport = vp;
    lws.setContents__Lorg_eclipse_draw2d_IFigure_2(viewport);
    this.hookViewport__();
    return;
  }
  private function verifyScrollBarOffset__Lorg_eclipse_draw2d_RangeModel_2I(model: RangeModel, value: int): int {
    value = Math__.max__II(model.getMinimum__(), value);
    return Math__.min__II(model.getMaximum__() - model.getExtent__(), value);
  }
  public static function access$0(arg0: FigureCanvas, arg1: int): void {
    arg0.hBarOffset = arg1;
  }
  public static function access$1(arg0: FigureCanvas): int {
    return arg0.hBarOffset;
  }
  public static function access$2(arg0: FigureCanvas, arg1: int): void {
    arg0.vBarOffset = arg1;
  }
  public static function access$3(arg0: FigureCanvas): int {
    return arg0.vBarOffset;
  }
  public static function access$4(arg0: FigureCanvas): void {
    arg0.layoutViewport__();
  }
  public function FigureCanvas(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Composite) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is Composite) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is Composite && vargs[1] is LightweightSystem) {
        args = vargs;
        id = 3;
      } else if (vargs.length == 3 && vargs[0] is int && vargs[1] is Composite && vargs[2] is LightweightSystem) {
        args = vargs;
        id = 4;
      } else if (vargs.length == 3 && vargs[0] is Composite && vargs[1] is int && vargs[2] is LightweightSystem) {
        args = vargs;
        id = 5;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args5 = [args0[0], 536870912, new LightweightSystem(new Arguments(org.eclipse.draw2d.LightweightSystem.LightweightSystem__, []))];
        args4 = [args5[1] | 1311488, args5[0], args5[2]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        args5 = [args1[0], args1[1], new LightweightSystem(new Arguments(org.eclipse.draw2d.LightweightSystem.LightweightSystem__, []))];
        args4 = [args5[1] | 1311488, args5[0], args5[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        args4 = [args2[0], args2[1], new LightweightSystem(new Arguments(org.eclipse.draw2d.LightweightSystem.LightweightSystem__, []))];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        args5 = [args3[0], 536870912, args3[1]];
        args4 = [args5[1] | 1311488, args5[0], args5[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
      case 4:
        var args4: Array = [args[0], args[1], args[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
      case 5:
        var args5: Array = [args[0], args[1], args[2]];
        args4 = [args5[1] | 1311488, args5[0], args5[2]];
        superArgs = new Arguments(org.eclipse.swt.widgets.Canvas.Canvas__Lorg_eclipse_swt_widgets_Composite_2I, [args4[1], FigureCanvas.checkStyle__I(args4[0])]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2(args5[0], args5[1], args5[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2(args0[0]);
        break;
      case 1:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2(args5[0], args5[1], args5[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2I(args1[0], args1[1]);
        break;
      case 2:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2(args2[0], args2[1]);
        break;
      case 3:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2(args5[0], args5[1], args5[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args3[0], args3[1]);
        break;
      case 4:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        break;
      case 5:
        FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2(args4[0], args4[1], args4[2]);
        FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2(args5[0], args5[1], args5[2]);
        break;
    }
  }
  public static const FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2 : int = 0;
  public static const FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2I : int = 1;
  public static const FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2 : int = 2;
  public static const FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2 : int = 3;
  public static const FigureCanvas__ILorg_eclipse_swt_widgets_Composite_2Lorg_eclipse_draw2d_LightweightSystem_2 : int = 4;
  public static const FigureCanvas__Lorg_eclipse_swt_widgets_Composite_2ILorg_eclipse_draw2d_LightweightSystem_2 : int = 5;
}
}
