package org.eclipse.draw2d {
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;
import java.lang.Math__;
import org.eclipse.draw2d.geometry.Point;
import java.util.ArrayList;
import java.lang.Arguments;
dynamic public class FigureUtilities {
  public static const RGB_VALUE_MULTIPLIER: Number = 0.6000000238418579;
  public static var gc: GC;
  public static var appliedFont: Font;
  public static var metrics: FontMetrics;
  public static var ghostFillColor: Color = new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, 31, 31, 31]));
  public static function darker__Lorg_eclipse_swt_graphics_Color_2(color: Color): Color {
    return new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, int((color.getRed__() * 0.6000000238418579)), int((color.getGreen__() * 0.6000000238418579)), int((color.getBlue__() * 0.6000000238418579))]));
  }
  public static function getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(f: Font): FontMetrics {
    setFont__Lorg_eclipse_swt_graphics_Font_2(f);
    if (metrics === null)
      metrics = getGC__().getFontMetrics__();
    return metrics;
  }
  public static function getGC__(): GC {
    if (gc === null) {
      gc = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__, []))]));
      appliedFont = gc.getFont__();
    }
    return gc;
  }
  public static function getTextDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): org.eclipse.swt.graphics.Point {
    setFont__Lorg_eclipse_swt_graphics_Font_2(f);
    return getGC__().textExtent__Ljava_lang_String_2(s);
  }
  public static function getRoot__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): IFigure {
    while (figure.getParent__() !== null)
      figure = figure.getParent__();
    return figure;
  }
  public static function getStringDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): org.eclipse.swt.graphics.Point {
    setFont__Lorg_eclipse_swt_graphics_Font_2(f);
    return getGC__().stringExtent__Ljava_lang_String_2(s);
  }
  public static function getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(text: String, f: Font): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_swt_graphics_Point_2, [getTextDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(text, f)]));
  }
  public static function getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_swt_graphics_Point_2, [getStringDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s, f)]));
  }
  public static function getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_draw2d_geometry_Dimension_2(s: String, f: Font, result: Dimension): void {
    var pt: org.eclipse.swt.graphics.Point = getTextDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s, f);
    result.width = pt.x;
    result.height = pt.y;
  }
  public static function getTextWidth__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s: String, f: Font): int {
    return getTextDimension__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(s, f).x;
  }
  public static function lighter__Lorg_eclipse_swt_graphics_Color_2(rgb: Color): Color {
    var r: int = rgb.getRed__();
    var g: int = rgb.getGreen__();
    var b: int = rgb.getBlue__();
    return new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, Math__.max__II(2, Math__.min__II(int((r / 0.6000000238418579)), 255)), Math__.max__II(2, Math__.min__II(int((g / 0.6000000238418579)), 255)), Math__.max__II(2, Math__.min__II(int((b / 0.6000000238418579)), 255))]));
  }
  public static function makeGhostShape__Lorg_eclipse_draw2d_Shape_2(s: Shape): Shape {
    s.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(ghostFillColor);
    s.setFillXOR__Z(true);
    s.setOutlineXOR__Z(true);
    return s;
  }
  public static function mixColors__Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2D(c1: Color, c2: Color, weight: Number): Color {
    return new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, int((c1.getRed__() * weight + c2.getRed__() * (1 - weight))), int((c1.getGreen__() * weight + c2.getGreen__() * (1 - weight))), int((c1.getBlue__() * weight + c2.getBlue__() * (1 - weight)))]));
  }
  public static function mixColors__Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(c1: Color, c2: Color): Color {
    return new Color(new Arguments(org.eclipse.swt.graphics.Color.Color__Lorg_eclipse_swt_graphics_Device_2III, [null, int((c1.getRed__() + c2.getRed__()) / 2), int((c1.getGreen__() + c2.getGreen__()) / 2), int((c1.getBlue__() + c2.getBlue__()) / 2)]));
  }
  public static function paintEtchedBorder__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(g: Graphics, r: Rectangle, shadow: Color, highlight: Color): void {
    var x: int = r.x;
    var y: int = r.y;
    var w: int = r.width;
    var h: int = r.height;
    g.setLineStyle__I(1);
    g.setLineWidth__I(1);
    g.setXORMode__Z(false);
    w -= 2;
    h -= 2;
    g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(shadow);
    g.drawRectangle__IIII(x, y, w, h);
    x++;
    y++;
    g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(highlight);
    g.drawRectangle__IIII(x, y, w, h);
  }
  public static function paintGrid__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Point_2II(g: Graphics, f: IFigure, origin: org.eclipse.draw2d.geometry.Point, distanceX: int, distanceY: int): void {
    var clip: Rectangle = g.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON);
    if (distanceX > 0) {
      if (origin.x >= clip.x)
        while (origin.x - distanceX >= clip.x)
          origin.x -= distanceX;
      else
        while (origin.x < clip.x)
          origin.x += distanceX;
      for (var i: int = origin.x; i < clip.x + clip.width; i += distanceX)
        g.drawLine__IIII(i, clip.y, i, clip.y + clip.height);
    }
    if (distanceY > 0) {
      if (origin.y >= clip.y)
        while (origin.y - distanceY >= clip.y)
          origin.y -= distanceY;
      else
        while (origin.y < clip.y)
          origin.y += distanceY;
      for (var i_1: int = origin.y; i_1 < clip.y + clip.height; i_1 += distanceY)
        g.drawLine__IIII(clip.x, i_1, clip.x + clip.width, i_1);
    }
    return;
  }
  public static function paintEtchedBorder__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2(g: Graphics, r: Rectangle): void {
    var rgb: Color = g.getBackgroundColor__();
    var shadow: Color = darker__Lorg_eclipse_swt_graphics_Color_2(rgb);
    var highlight: Color = lighter__Lorg_eclipse_swt_graphics_Color_2(rgb);
    paintEtchedBorder__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(g, r, shadow, highlight);
    return;
  }
  public static function setFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): void {
    if (appliedFont === f || f.equals__Ljava_lang_Object_2(appliedFont))
      return;
    getGC__().setFont__Lorg_eclipse_swt_graphics_Font_2(f);
    appliedFont = f;
    metrics = null;
  }
  public static function findCommonAncestor__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(l: IFigure, r: IFigure): IFigure {
    if (l === r)
      return l;
    var left: ArrayList = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    var right: ArrayList = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
    while (l !== null) {
      left.add__Ljava_lang_Object_2(l);
      l = l.getParent__();
    }
    while (r !== null) {
      right.add__Ljava_lang_Object_2(r);
      r = r.getParent__();
    }
    if (left.isEmpty__() || right.isEmpty__())
      return null;
    var il: int = left.size__() - 1;
    var ir: int = right.size__() - 1;
    do {
      if (left.get__I(il) !== right.get__I(ir))
        break;
      il--;
      ir--;
    } while (il >= 0 && ir >= 0);
    return IFigure(left.get__I(il + 1));
  }
  public static function isAncestor__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(ancestor: IFigure, descendant: IFigure): Boolean {
    while (descendant !== null) {
      descendant = descendant.getParent__();
      if (descendant === ancestor)
        return true;
    }
    return false;
  }
}
}
