package org.eclipse.draw2d {
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.lang.Math__;
import java.lang.Integer;
import java.util.List;
import java.util.Iterator;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class FlowLayout extends AbstractHintLayout {
  public static const ALIGN_CENTER: int = 0;
  public static const ALIGN_LEFTTOP: int = 1;
  public static const ALIGN_RIGHTBOTTOM: int = 2;
  public static const HORIZONTAL: Boolean = true;
  public static const VERTICAL: Boolean = false;
  public var horizontal: Boolean = true;
  public var fill: Boolean = false;
  public var transposer: Transposer;
  public var majorAlignment: int = 1;
  public var minorAlignment: int = 1;
  public var minorSpacing: int = 5;
  public var majorSpacing: int = 5;
  public var data: FlowLayout$WorkingData = null;
  public function FlowLayout__(): Object {
    {
      transposer = new Transposer();
      transposer.setEnabled__Z(!horizontal);
    }
    return this;
  }
  public function FlowLayout__Z(isHorizontal: Boolean): Object {
    {
      transposer = new Transposer();
      transposer.setEnabled__Z(!horizontal);
    }
    this.setHorizontal__Z(isHorizontal);
    return this;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    if (wHint > -1)
      wHint = Math__.max__II(0, wHint - container.getInsets__().getWidth__());
    if (hHint > -1)
      hHint = Math__.max__II(0, hHint - container.getInsets__().getHeight__());
    var maxWidth: int;
    if (this.isHorizontal__()) {
      maxWidth = wHint;
      hHint = -1;
    } else {
      maxWidth = hHint;
      wHint = -1;
    }
    if (maxWidth < 0) {
      maxWidth = 2147483647;
    }
    var prefSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    var children: List = container.getChildren__();
    var width: int = 0;
    var height: int = 0;
    var child: IFigure;
    var childSize: Dimension;
    for (var i: int = 0; i < children.size__(); i++) {
      child = IFigure(children.get__I(i));
      childSize = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getChildSize__Lorg_eclipse_draw2d_IFigure_2II(child, wHint, hHint));
      if (i == 0) {
        width = childSize.width;
        height = childSize.height;
      } else if (width + childSize.width + this.getMinorSpacing__() > maxWidth) {
        prefSize.height += height + this.getMajorSpacing__();
        prefSize.width = Math__.max__II(prefSize.width, width);
        width = childSize.width;
        height = childSize.height;
      } else {
        width += childSize.width + this.getMinorSpacing__();
        height = Math__.max__II(height, childSize.height);
      }
    }
    prefSize.height += height;
    prefSize.width = Math__.max__II(prefSize.width, width);
    prefSize = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(prefSize);
    prefSize.width += container.getInsets__().getWidth__();
    prefSize.height += container.getInsets__().getHeight__();
    prefSize.union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getBorderPreferredSize__Lorg_eclipse_draw2d_IFigure_2(container));
    return prefSize;
  }
  public function getChildSize__Lorg_eclipse_draw2d_IFigure_2II(child: IFigure, wHint: int, hHint: int): Dimension {
    return child.getPreferredSize__II(wHint, hHint);
  }
  public function getMajorAlignment__(): int {
    return majorAlignment;
  }
  public function getMajorSpacing__(): int {
    return majorSpacing;
  }
  public function getMinorAlignment__(): int {
    return minorAlignment;
  }
  public function getMinorSpacing__(): int {
    return minorSpacing;
  }
  public function initRow__(): void {
    data.rowX = 0;
    data.rowHeight = 0;
    data.rowWidth = 0;
    data.rowCount = 0;
  }
  public function initVariables__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    data.row = new JavaArray("[Lorg/eclipse/draw2d/IFigure;").lengths(parent.getChildren__().size__());
    data.bounds = new JavaArray("[Lorg/eclipse/draw2d/geometry/Rectangle;").lengths(data.row.length);
    data.maxWidth = data.area.width;
  }
  public function isHorizontal__(): Boolean {
    return horizontal;
  }
  public override function isSensitiveHorizontally__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return this.isHorizontal__();
  }
  public override function isSensitiveVertically__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): Boolean {
    return !this.isHorizontal__();
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    data = new FlowLayout$WorkingData(this);
    var relativeArea: Rectangle = parent.getClientArea__();
    data.area = transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(relativeArea);
    var iterator: Iterator = Iterator(parent.getChildren__().iterator__());
    var dx: int;
    var wHint: int = -1;
    var hHint: int = -1;
    if (this.isHorizontal__())
      wHint = parent.getClientArea__().width;
    else
      hHint = parent.getClientArea__().height;
    this.initVariables__Lorg_eclipse_draw2d_IFigure_2(parent);
    this.initRow__();
    var i: int = 0;
    while (iterator.hasNext__()) {
      var f: IFigure = IFigure(iterator.next__());
      var pref: Dimension = transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getChildSize__Lorg_eclipse_draw2d_IFigure_2II(f, wHint, hHint));
      var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, pref.width, pref.height]));
      if (data.rowCount > 0) {
        if (data.rowWidth + pref.width > data.maxWidth)
          this.layoutRow__Lorg_eclipse_draw2d_IFigure_2(parent);
      }
      r.x = data.rowX;
      r.y = data.rowY;
      dx = r.width + this.getMinorSpacing__();
      data.rowX += dx;
      data.rowWidth += dx;
      data.rowHeight = Math__.max__II(data.rowHeight, r.height);
      data.row[data.rowCount] = f;
      data.bounds[data.rowCount] = r;
      data.rowCount++;
      i++;
    }
    if (data.rowCount != 0)
      this.layoutRow__Lorg_eclipse_draw2d_IFigure_2(parent);
    data = null;
    return;
  }
  public function layoutRow__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    var majorAdjustment: int = 0;
    var minorAdjustment: int = 0;
    var correctMajorAlignment: int = majorAlignment;
    var correctMinorAlignment: int = minorAlignment;
    majorAdjustment = data.area.width - data.rowWidth + this.getMinorSpacing__();
    switch (correctMajorAlignment) {
      case 1 :
        majorAdjustment = 0;
        break;
      case 0 :
        majorAdjustment /= 2;
        break;
      case 2 :
        break;
    }
    for (var j: int = 0; j < data.rowCount; j++) {
      if (fill) {
        data.bounds[j].height = data.rowHeight;
      } else {
        minorAdjustment = data.rowHeight - data.bounds[j].height;
        switch (correctMinorAlignment) {
          case 1 :
            minorAdjustment = 0;
            break;
          case 0 :
            minorAdjustment /= 2;
            break;
          case 2 :
            break;
        }
        data.bounds[j].y += minorAdjustment;
      }
      data.bounds[j].x += majorAdjustment;
      this.setBoundsOfChild__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(parent, data.row[j], transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(data.bounds[j]));
    }
    data.rowY += this.getMajorSpacing__() + data.rowHeight;
    this.initRow__();
    return;
  }
  public function setBoundsOfChild__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(parent: IFigure, child: IFigure, bounds: Rectangle): void {
    parent.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(Rectangle.SINGLETON);
    bounds.translate__II(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
    child.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    return;
  }
  public function setStretchMinorAxis__Z(value: Boolean): void {
    fill = value;
    return;
  }
  public function setHorizontal__Z(flag: Boolean): void {
    if (horizontal == flag)
      return;
    this.invalidate__();
    horizontal = flag;
    transposer.setEnabled__Z(!horizontal);
  }
  public function setMajorAlignment__I(align: int): void {
    majorAlignment = align;
  }
  public function setMajorSpacing__I(n: int): void {
    majorSpacing = n;
  }
  public function setMinorAlignment__I(align: int): void {
    minorAlignment = align;
  }
  public function setMinorSpacing__I(n: int): void {
    minorSpacing = n;
  }
  public function FlowLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        FlowLayout__();
        break;
      case 1:
        FlowLayout__Z(args1[0]);
        break;
    }
  }
  public static const FlowLayout__ : int = 0;
  public static const FlowLayout__Z : int = 1;
}
}
