package org.eclipse.draw2d {
import java.util.List;
import java.util.List;
dynamic public class FocusTraverseManager {
  internal var currentFocusOwner: IFigure;
  public function FocusTraverseManager() {
    return;
  }
  private function findDeepestRightmostChildOf__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): IFigure {
    while (fig.getChildren__().size__() != 0) {
      fig = IFigure(fig.getChildren__().get__I(fig.getChildren__().size__() - 1));
    }
    return fig;
  }
  public function getNextFocusableFigure__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(root: IFigure, prevFocus: IFigure): IFigure {
    var found: Boolean = false;
    var nextFocus: IFigure = prevFocus;
    if (prevFocus === null) {
      if (root.getChildren__().size__() != 0) {
        nextFocus = (IFigure(root.getChildren__().get__I(0)));
        if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
          return nextFocus;
      } else
        return null;
    }
    var siblingPos: int = nextFocus.getParent__().getChildren__().indexOf__Ljava_lang_Object_2(nextFocus);
    while (!found) {
      var parent: IFigure = nextFocus.getParent__();
      var siblings: List = parent.getChildren__();
      if (nextFocus.getChildren__().size__() != 0) {
        nextFocus = IFigure(nextFocus.getChildren__().get__I(0));
        siblingPos = 0;
        if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
          found = true;
      } else if (siblingPos < siblings.size__() - 1) {
        nextFocus = (IFigure((siblings.get__I(++siblingPos))));
        if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
          found = true;
      } else {
        var untraversedSiblingFound: Boolean = false;
        while (!untraversedSiblingFound) {
          var p: IFigure = nextFocus.getParent__();
          var gp: IFigure = p.getParent__();
          if (gp !== null) {
            var parentSiblingCount: int = gp.getChildren__().size__();
            var parentIndex: int = gp.getChildren__().indexOf__Ljava_lang_Object_2(p);
            if (parentIndex < parentSiblingCount - 1) {
              nextFocus = (IFigure(p.getParent__().getChildren__().get__I(parentIndex + 1)));
              siblingPos = parentIndex + 1;
              untraversedSiblingFound = true;
              if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
                found = true;
            } else
              nextFocus = p;
          } else {
            nextFocus = null;
            untraversedSiblingFound = true;
            found = true;
          }
        }
      }
    }
    return nextFocus;
  }
  public function getPreviousFocusableFigure__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(root: IFigure, prevFocus: IFigure): IFigure {
    if (prevFocus === null)
      return null;
    var found: Boolean = false;
    var nextFocus: IFigure = prevFocus;
    while (!found) {
      var parent: IFigure = nextFocus.getParent__();
      if (parent === null)
        return null;
      var siblings: List = parent.getChildren__();
      var siblingPos: int = siblings.indexOf__Ljava_lang_Object_2(nextFocus);
      if (siblingPos != 0) {
        var child: IFigure = this.findDeepestRightmostChildOf__Lorg_eclipse_draw2d_IFigure_2(IFigure(siblings.get__I(siblingPos - 1)));
        if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(child)) {
          found = true;
          nextFocus = child;
        } else if (Object(child).equals__Ljava_lang_Object_2(nextFocus)) {
          if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
            found = true;
        } else
          nextFocus = child;
      } else {
        nextFocus = parent;
        if (this.isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(nextFocus))
          found = true;
      }
    }
    return nextFocus;
  }
  public function getCurrentFocusOwner__(): IFigure {
    return currentFocusOwner;
  }
  private function isFocusEligible__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Boolean {
    return (fig !== null && fig.isFocusTraversable__() && fig.isShowing__());
  }
  public function setCurrentFocusOwner__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): void {
    currentFocusOwner = fig;
  }
}
}
