package org.eclipse.draw2d {
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.lang.Arguments;
dynamic public class FreeformHelper implements FreeformListener {
  private var host: FreeformFigure;
  private var freeformExtent: Rectangle;
  private var figureListener: FigureListener = new FreeformHelper$ChildTracker(FreeformHelper(this));
  function FreeformHelper(host: FreeformFigure) {
    this.host = host;
    return;
  }
  public function getFreeformExtent__(): Rectangle {
    if (freeformExtent !== null)
      return freeformExtent;
    var r: Rectangle;
    var children: List = host.getChildren__();
    for (var i: int = 0; i < children.size__(); i++) {
      var child: IFigure = IFigure(children.get__I(i));
      if (child is FreeformFigure)
        r = (FreeformFigure(child)).getFreeformExtent__();
      else
        r = child.getBounds__();
      if (freeformExtent === null)
        freeformExtent = r.getCopy__();
      else
        freeformExtent.union__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    }
    var insets: Insets = host.getInsets__();
    if (freeformExtent === null)
      freeformExtent = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [0, 0, insets.getWidth__(), insets.getHeight__()]));
    else {
      host.translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(freeformExtent);
      freeformExtent.expand__Lorg_eclipse_draw2d_geometry_Insets_2(insets);
    }
    return freeformExtent;
  }
  public function hookChild__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    this.invalidate__();
    if (child is FreeformFigure)
      (FreeformFigure(child)).addFreeformListener__Lorg_eclipse_draw2d_FreeformListener_2(this);
    else
      child.addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
  }
  public function invalidate__(): void {
    freeformExtent = null;
    host.fireExtentChanged__();
    if (host.getParent__() !== null)
      host.getParent__().revalidate__();
    else
      host.revalidate__();
  }
  public function notifyFreeformExtentChanged__(): void {
    this.invalidate__();
  }
  public function setFreeformBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds: Rectangle): void {
    host.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    bounds = bounds.getCopy__();
    host.translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(bounds);
    var children: List = host.getChildren__();
    for (var i: int = 0; i < children.size__(); i++) {
      var child: IFigure = IFigure(children.get__I(i));
      if (child is FreeformFigure)
        (FreeformFigure(child)).setFreeformBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(bounds);
    }
    return;
  }
  public function unhookChild__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    this.invalidate__();
    if (child is FreeformFigure)
      (FreeformFigure(child)).removeFreeformListener__Lorg_eclipse_draw2d_FreeformListener_2(this);
    else
      child.removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(figureListener);
    return;
  }
}
}
