package org.eclipse.draw2d {
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.SWT;
import java.util.Map;
import java.util.HashMap;
import java.lang.Math__;
import java.util.List;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class GridLayout extends AbstractLayout {
  public var numColumns: int = 1;
  public var makeColumnsEqualWidth: Boolean = false;
  public var marginWidth: int = 5;
  public var marginHeight: int = 5;
  public var horizontalSpacing: int = 5;
  public var verticalSpacing: int = 5;
  public var constraints: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  public function GridLayout__(): Object {
    return this;
  }
  public function GridLayout__IZ(numColumns: int, makeColumnsEqualWidth: Boolean): Object {
    this.numColumns = numColumns;
    this.makeColumnsEqualWidth = makeColumnsEqualWidth;
    return this;
  }
  public function getChildSize__Lorg_eclipse_draw2d_IFigure_2II(child: IFigure, wHint: int, hHint: int): Dimension {
    return child.getPreferredSize__II(wHint, hHint);
  }
  public function getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid: JavaArray, row: int, column: int, rowCount: int, columnCount: int, first: Boolean): GridData {
    var figure: IFigure = grid[row][column];
    if (figure !== null) {
      var data: GridData = GridData(this.getConstraint__Lorg_eclipse_draw2d_IFigure_2(figure));
      var hSpan: int = Math__.max__II(1, Math__.min__II(data.horizontalSpan, columnCount));
      var vSpan: int = Math__.max__II(1, data.verticalSpan);
      var i: int = first ? row + vSpan - 1 : row - vSpan + 1;
      var j: int = first ? column + hSpan - 1 : column - hSpan + 1;
      if (0 <= i && i < rowCount) {
        if (0 <= j && j < columnCount) {
          if (figure === grid[i][j])
            return data;
        }
      }
    }
    return null;
  }
  public function initChildren__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    var children: List = container.getChildren__();
    for (var i: int = 0; i < children.size__(); i++) {
      var child: IFigure = IFigure(children.get__I(i));
      if (child.getLayoutManager__() === null)
        child.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(this);
    }
    return;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var size: Dimension = this.layout__Lorg_eclipse_draw2d_IFigure_2ZIIIIZ(container, false, 0, 0, wHint, hHint, true);
    if (wHint != -1)
      size.width = wHint;
    if (hHint != -1)
      size.height = hHint;
    return size;
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(container: IFigure): void {
    var rect: Rectangle = container.getClientArea__();
    this.layout__Lorg_eclipse_draw2d_IFigure_2ZIIIIZ(container, true, rect.x, rect.y, rect.width, rect.height, true);
  }
  public function layout__Lorg_eclipse_draw2d_IFigure_2ZIIIIZ(container: IFigure, move: Boolean, x: int, y: int, width: int, height: int, flushCache: Boolean): Dimension {
    if (numColumns < 1)
      return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [marginWidth * 2, marginHeight * 2]));
    var children: List = container.getChildren__();
    for (var i: int = 0; i < children.size__(); i++) {
      var child: IFigure = IFigure(children.get__I(i));
      var data: GridData = GridData(this.getConstraint__Lorg_eclipse_draw2d_IFigure_2(child));
      if (data === null)
        this.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(child, data = new GridData(new Arguments(org.eclipse.draw2d.GridData.GridData__, [])));
      if (flushCache)
        data.flushCache__();
      data.computeSize__Lorg_eclipse_draw2d_IFigure_2Z(child, flushCache);
    }
    var row: int = 0;
    var column: int = 0;
    var rowCount: int = 0;
    var columnCount: int = numColumns;
    var grid: JavaArray = new JavaArray("[[Lorg/eclipse/draw2d/IFigure;").lengths(4, columnCount);
    for (var i_1: int = 0; i_1 < children.size__(); i_1++) {
      var child_1: IFigure = IFigure(children.get__I(i_1));
      var data_1: GridData = GridData(this.getConstraint__Lorg_eclipse_draw2d_IFigure_2(child_1));
      var hSpan: int = Math__.max__II(1, Math__.min__II(data_1.horizontalSpan, columnCount));
      var vSpan: int = Math__.max__II(1, data_1.verticalSpan);
      while (true) {
        var lastRow: int = row + vSpan;
        if (lastRow >= grid.length) {
          var newGrid: JavaArray = new JavaArray("[[Lorg/eclipse/draw2d/IFigure;").lengths(lastRow + 4, columnCount);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(grid, 0, newGrid, 0, grid.length);
          grid = newGrid;
        }
        if (grid[row] === null) {
          grid[row] = new JavaArray("[Lorg/eclipse/draw2d/IFigure;").lengths(columnCount);
        }
        while (column < columnCount && grid[row][column] !== null) {
          column++;
        }
        var endCount: int = column + hSpan;
        if (endCount <= columnCount) {
          var index: int = column;
          while (index < endCount && grid[row][index] === null) {
            index++;
          }
          if (index == endCount)
            break;
          column = index;
        }
        if (column + hSpan >= columnCount) {
          column = 0;
          row++;
        }
      }
      for (var j: int = 0; j < vSpan; j++) {
        if (grid[row + j] === null) {
          grid[row + j] = new JavaArray("[Lorg/eclipse/draw2d/IFigure;").lengths(columnCount);
        }
        for (var k: int = 0; k < hSpan; k++) {
          grid[row + j][column + k] = child_1;
        }
      }
      rowCount = Math__.max__II(rowCount, row + vSpan);
      column += hSpan;
    }
    var availableWidth: int = width - horizontalSpacing * (columnCount - 1) - marginWidth * 2;
    var expandCount: int = 0;
    var widths: JavaArray = new JavaArray("[I").lengths(columnCount);
    var minWidths: JavaArray = new JavaArray("[I").lengths(columnCount);
    var expandColumn: JavaArray = new JavaArray("[Z").lengths(columnCount);
    for (var j_1: int = 0; j_1 < columnCount; j_1++) {
      for (var i_2: int = 0; i_2 < rowCount; i_2++) {
        var data_2: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_2, j_1, rowCount, columnCount, true);
        if (data_2 !== null) {
          var hSpan_1: int = Math__.max__II(1, Math__.min__II(data_2.horizontalSpan, columnCount));
          if (hSpan_1 == 1) {
            var w: int = data_2.cacheWidth + data_2.horizontalIndent;
            widths[j_1] = Math__.max__II(widths[j_1], w);
            if (data_2.grabExcessHorizontalSpace) {
              if (!expandColumn[j_1])
                expandCount++;
              expandColumn[j_1] = true;
            }
            if (data_2.widthHint != -1 || !data_2.grabExcessHorizontalSpace) {
              minWidths[j_1] = Math__.max__II(minWidths[j_1], w);
            }
          }
        }
      }
      for (var i_3: int = 0; i_3 < rowCount; i_3++) {
        var data_3: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_3, j_1, rowCount, columnCount, false);
        if (data_3 !== null) {
          var hSpan_2: int = Math__.max__II(1, Math__.min__II(data_3.horizontalSpan, columnCount));
          if (hSpan_2 > 1) {
            var spanWidth: int = 0;
            var spanMinWidth: int = 0;
            var spanExpandCount: int = 0;
            for (var k_1: int = 0; k_1 < hSpan_2; k_1++) {
              spanWidth += widths[j_1 - k_1];
              spanMinWidth += minWidths[j_1 - k_1];
              if (expandColumn[j_1 - k_1])
                spanExpandCount++;
            }
            if (data_3.grabExcessHorizontalSpace && spanExpandCount == 0) {
              expandCount++;
              expandColumn[j_1] = true;
            }
            var w_1: int = data_3.cacheWidth + data_3.horizontalIndent - spanWidth - (hSpan_2 - 1) * horizontalSpacing;
            if (w_1 > 0) {
              if (spanExpandCount == 0) {
                widths[j_1] += w_1;
              } else {
                var delta: int = int(w_1 / spanExpandCount);
                var remainder: int = w_1 % spanExpandCount;
                var last: int = -1;
                for (var k_2: int = 0; k_2 < hSpan_2; k_2++) {
                  if (expandColumn[j_1 - k_2]) {
                    widths[last = j_1 - k_2] += delta;
                  }
                }
                if (last > -1)
                  widths[last] += remainder;
              }
            }
            if (data_3.widthHint != -1 || !data_3.grabExcessHorizontalSpace) {
              w_1 = data_3.cacheWidth + data_3.horizontalIndent - spanMinWidth - (hSpan_2 - 1) * horizontalSpacing;
              if (w_1 > 0) {
                if (spanExpandCount == 0) {
                  minWidths[j_1] += w_1;
                } else {
                  var delta_1: int = int(w_1 / spanExpandCount);
                  var remainder_1: int = w_1 % spanExpandCount;
                  var last_1: int = -1;
                  for (var k_3: int = 0; k_3 < hSpan_2; k_3++) {
                    if (expandColumn[j_1 - k_3]) {
                      minWidths[last_1 = j_1 - k_3] += delta_1;
                    }
                  }
                  if (last_1 > -1)
                    minWidths[last_1] += remainder_1;
                }
              }
            }
          }
        }
      }
    }
    if (makeColumnsEqualWidth) {
      var minColumnWidth: int = 0;
      var columnWidth: int = 0;
      for (var i_4: int = 0; i_4 < columnCount; i_4++) {
        minColumnWidth = Math__.max__II(minColumnWidth, minWidths[i_4]);
        columnWidth = Math__.max__II(columnWidth, widths[i_4]);
      }
      columnWidth = width == -1 || expandCount == 0 ? columnWidth : Math__.max__II(minColumnWidth, int(availableWidth / columnCount));
      for (var i_5: int = 0; i_5 < columnCount; i_5++) {
        expandColumn[i_5] = expandCount > 0;
        widths[i_5] = columnWidth;
      }
    } else {
      if (width != -1 && expandCount > 0) {
        var totalWidth: int = 0;
        for (var i_6: int = 0; i_6 < columnCount; i_6++) {
          totalWidth += widths[i_6];
        }
        var count: int = expandCount;
        var delta_2: int = int((availableWidth - totalWidth) / count);
        var remainder_2: int = (availableWidth - totalWidth) % count;
        var last_2: int = -1;
        while (totalWidth != availableWidth) {
          for (var j_2: int = 0; j_2 < columnCount; j_2++) {
            if (expandColumn[j_2]) {
              if (widths[j_2] + delta_2 > minWidths[j_2]) {
                widths[last_2 = j_2] = widths[j_2] + delta_2;
              } else {
                widths[j_2] = minWidths[j_2];
                expandColumn[j_2] = false;
                count--;
              }
            }
          }
          if (last_2 > -1)
            widths[last_2] += remainder_2;
          for (var j_3: int = 0; j_3 < columnCount; j_3++) {
            for (var i_7: int = 0; i_7 < rowCount; i_7++) {
              var data_4: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_7, j_3, rowCount, columnCount, false);
              if (data_4 !== null) {
                var hSpan_3: int = Math__.max__II(1, Math__.min__II(data_4.horizontalSpan, columnCount));
                if (hSpan_3 > 1) {
                  if (data_4.widthHint != -1 || !data_4.grabExcessHorizontalSpace) {
                    var spanWidth_1: int = 0;
                    var spanExpandCount_1: int = 0;
                    for (var k_4: int = 0; k_4 < hSpan_3; k_4++) {
                      spanWidth_1 += widths[j_3 - k_4];
                      if (expandColumn[j_3 - k_4])
                        spanExpandCount_1++;
                    }
                    var w_2: int = data_4.cacheWidth + data_4.horizontalIndent - spanWidth_1 - (hSpan_3 - 1) * horizontalSpacing;
                    if (w_2 > 0) {
                      if (spanExpandCount_1 == 0) {
                        widths[j_3] += w_2;
                      } else {
                        var delta2: int = int(w_2 / spanExpandCount_1);
                        var remainder2: int = w_2 % spanExpandCount_1;
                        var last2: int = -1;
                        for (var k_5: int = 0; k_5 < hSpan_3; k_5++) {
                          if (expandColumn[j_3 - k_5]) {
                            widths[last2 = j_3 - k_5] += delta2;
                          }
                        }
                        if (last2 > -1)
                          widths[last2] += remainder2;
                      }
                    }
                  }
                }
              }
            }
          }
          if (count == 0)
            break;
          totalWidth = 0;
          for (var i_8: int = 0; i_8 < columnCount; i_8++) {
            totalWidth += widths[i_8];
          }
          delta_2 = int((availableWidth - totalWidth) / count);
          remainder_2 = (availableWidth - totalWidth) % count;
          last_2 = -1;
        }
      }
    }
    var flush: JavaArray = null;
    var flushLength: int = 0;
    if (width != -1) {
      for (var j_4: int = 0; j_4 < columnCount; j_4++) {
        for (var i_9: int = 0; i_9 < rowCount; i_9++) {
          var data_5: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_9, j_4, rowCount, columnCount, false);
          if (data_5 !== null) {
            if (data_5.heightHint == -1) {
              var child_2: IFigure = grid[i_9][j_4];
              var hSpan_4: int = Math__.max__II(1, Math__.min__II(data_5.horizontalSpan, columnCount));
              var currentWidth: int = 0;
              for (var k_6: int = 0; k_6 < hSpan_4; k_6++) {
                currentWidth += widths[j_4 - k_6];
              }
              currentWidth += (hSpan_4 - 1) * horizontalSpacing - data_5.horizontalIndent;
              if ((currentWidth != data_5.cacheWidth && data_5.horizontalAlignment == 4) || (data_5.cacheWidth > currentWidth)) {
                var trim: int = 0;
                var oldWidthHint: int = data_5.widthHint;
                data_5.widthHint = Math__.max__II(0, currentWidth - trim);
                data_5.cacheWidth = data_5.cacheHeight = -1;
                data_5.computeSize__Lorg_eclipse_draw2d_IFigure_2Z(child_2, false);
                data_5.widthHint = oldWidthHint;
                if (flush === null)
                  flush = new JavaArray("[Lorg/eclipse/draw2d/GridData;").lengths(children.size__());
                flush[flushLength++] = data_5;
              }
            }
          }
        }
      }
    }
    var availableHeight: int = height - verticalSpacing * (rowCount - 1) - marginHeight * 2;
    expandCount = 0;
    var heights: JavaArray = new JavaArray("[I").lengths(rowCount);
    var minHeights: JavaArray = new JavaArray("[I").lengths(rowCount);
    var expandRow: JavaArray = new JavaArray("[Z").lengths(rowCount);
    for (var i_10: int = 0; i_10 < rowCount; i_10++) {
      for (var j_5: int = 0; j_5 < columnCount; j_5++) {
        var data_6: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_10, j_5, rowCount, columnCount, true);
        if (data_6 !== null) {
          var vSpan_1: int = Math__.max__II(1, Math__.min__II(data_6.verticalSpan, rowCount));
          if (vSpan_1 == 1) {
            var h: int = data_6.cacheHeight;
            heights[i_10] = Math__.max__II(heights[i_10], h);
            if (data_6.grabExcessVerticalSpace) {
              if (!expandRow[i_10])
                expandCount++;
              expandRow[i_10] = true;
            }
            if (data_6.heightHint != -1 || !data_6.grabExcessVerticalSpace) {
              minHeights[i_10] = Math__.max__II(minHeights[i_10], h);
            }
          }
        }
      }
      for (var j_6: int = 0; j_6 < columnCount; j_6++) {
        var data_7: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_10, j_6, rowCount, columnCount, false);
        if (data_7 !== null) {
          var vSpan_2: int = Math__.max__II(1, Math__.min__II(data_7.verticalSpan, rowCount));
          if (vSpan_2 > 1) {
            var spanHeight: int = 0;
            var spanMinHeight: int = 0;
            var spanExpandCount_2: int = 0;
            for (var k_7: int = 0; k_7 < vSpan_2; k_7++) {
              spanHeight += heights[i_10 - k_7];
              spanMinHeight += minHeights[i_10 - k_7];
              if (expandRow[i_10 - k_7])
                spanExpandCount_2++;
            }
            if (data_7.grabExcessVerticalSpace && spanExpandCount_2 == 0) {
              expandCount++;
              expandRow[i_10] = true;
            }
            var h_1: int = data_7.cacheHeight - spanHeight - (vSpan_2 - 1) * verticalSpacing;
            if (h_1 > 0) {
              if (spanExpandCount_2 == 0) {
                heights[i_10] += h_1;
              } else {
                var delta_3: int = int(h_1 / spanExpandCount_2);
                var remainder_3: int = h_1 % spanExpandCount_2;
                var last_3: int = -1;
                for (var k_8: int = 0; k_8 < vSpan_2; k_8++) {
                  if (expandRow[i_10 - k_8]) {
                    heights[last_3 = i_10 - k_8] += delta_3;
                  }
                }
                if (last_3 > -1)
                  heights[last_3] += remainder_3;
              }
            }
            if (data_7.heightHint != -1 || !data_7.grabExcessVerticalSpace) {
              h_1 = data_7.cacheHeight - spanMinHeight - (vSpan_2 - 1) * verticalSpacing;
              if (h_1 > 0) {
                if (spanExpandCount_2 == 0) {
                  minHeights[i_10] += h_1;
                } else {
                  var delta_4: int = int(h_1 / spanExpandCount_2);
                  var remainder_4: int = h_1 % spanExpandCount_2;
                  var last_4: int = -1;
                  for (var k_9: int = 0; k_9 < vSpan_2; k_9++) {
                    if (expandRow[i_10 - k_9]) {
                      minHeights[last_4 = i_10 - k_9] += delta_4;
                    }
                  }
                  if (last_4 > -1)
                    minHeights[last_4] += remainder_4;
                }
              }
            }
          }
        }
      }
    }
    if (height != -1 && expandCount > 0) {
      var totalHeight: int = 0;
      for (var i_11: int = 0; i_11 < rowCount; i_11++) {
        totalHeight += heights[i_11];
      }
      var count_1: int = expandCount;
      var delta_5: int = int((availableHeight - totalHeight) / count_1);
      var remainder_5: int = (availableHeight - totalHeight) % count_1;
      var last_5: int = -1;
      while (totalHeight != availableHeight) {
        for (var i_12: int = 0; i_12 < rowCount; i_12++) {
          if (expandRow[i_12]) {
            if (heights[i_12] + delta_5 > minHeights[i_12]) {
              heights[last_5 = i_12] = heights[i_12] + delta_5;
            } else {
              heights[i_12] = minHeights[i_12];
              expandRow[i_12] = false;
              count_1--;
            }
          }
        }
        if (last_5 > -1)
          heights[last_5] += remainder_5;
        for (var i_13: int = 0; i_13 < rowCount; i_13++) {
          for (var j_7: int = 0; j_7 < columnCount; j_7++) {
            var data_8: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_13, j_7, rowCount, columnCount, false);
            if (data_8 !== null) {
              var vSpan_3: int = Math__.max__II(1, Math__.min__II(data_8.verticalSpan, rowCount));
              if (vSpan_3 > 1) {
                if (data_8.heightHint != -1 || !data_8.grabExcessVerticalSpace) {
                  var spanHeight_1: int = 0;
                  var spanExpandCount_3: int = 0;
                  for (var k_10: int = 0; k_10 < vSpan_3; k_10++) {
                    spanHeight_1 += heights[i_13 - k_10];
                    if (expandRow[i_13 - k_10])
                      spanExpandCount_3++;
                  }
                  var h_2: int = data_8.cacheHeight - spanHeight_1 - (vSpan_3 - 1) * verticalSpacing;
                  if (h_2 > 0) {
                    if (spanExpandCount_3 == 0) {
                      heights[i_13] += h_2;
                    } else {
                      var delta2_1: int = int(h_2 / spanExpandCount_3);
                      var remainder2_1: int = h_2 % spanExpandCount_3;
                      var last2_1: int = -1;
                      for (var k_11: int = 0; k_11 < vSpan_3; k_11++) {
                        if (expandRow[i_13 - k_11]) {
                          heights[last2_1 = i_13 - k_11] += delta2_1;
                        }
                      }
                      if (last2_1 > -1)
                        heights[last2_1] += remainder2_1;
                    }
                  }
                }
              }
            }
          }
        }
        if (count_1 == 0)
          break;
        totalHeight = 0;
        for (var i_14: int = 0; i_14 < rowCount; i_14++) {
          totalHeight += heights[i_14];
        }
        delta_5 = int((availableHeight - totalHeight) / count_1);
        remainder_5 = (availableHeight - totalHeight) % count_1;
        last_5 = -1;
      }
    }
    if (move) {
      var gridY: int = y + marginHeight;
      for (var i_15: int = 0; i_15 < rowCount; i_15++) {
        var gridX: int = x + marginWidth;
        for (var j_8: int = 0; j_8 < columnCount; j_8++) {
          var data_9: GridData = this.getData___3_3Lorg_eclipse_draw2d_IFigure_2IIIIZ(grid, i_15, j_8, rowCount, columnCount, true);
          if (data_9 !== null) {
            var hSpan_5: int = Math__.max__II(1, Math__.min__II(data_9.horizontalSpan, columnCount));
            var vSpan_4: int = Math__.max__II(1, data_9.verticalSpan);
            var cellWidth: int = 0;
            var cellHeight: int = 0;
            for (var k_12: int = 0; k_12 < hSpan_5; k_12++) {
              cellWidth += widths[j_8 + k_12];
            }
            for (var k_13: int = 0; k_13 < vSpan_4; k_13++) {
              cellHeight += heights[i_15 + k_13];
            }
            cellWidth += horizontalSpacing * (hSpan_5 - 1);
            var childX: int = gridX + data_9.horizontalIndent;
            var childWidth: int = Math__.min__II(data_9.cacheWidth, cellWidth);
            switch (data_9.horizontalAlignment) {
              case 16777216 :
              case 2 :
                childX = gridX + Math__.max__II(0, int((cellWidth - childWidth) / 2));
                break;
              case 131072 :
              case 16777224 :
              case 3 :
                childX = gridX + Math__.max__II(0, cellWidth - childWidth);
                break;
              case 4 :
                childWidth = cellWidth - data_9.horizontalIndent;
                break;
            }
            cellHeight += verticalSpacing * (vSpan_4 - 1);
            var childY: int = gridY;
            var childHeight: int = Math__.min__II(data_9.cacheHeight, cellHeight);
            switch (data_9.verticalAlignment) {
              case 16777216 :
              case 2 :
                childY = gridY + Math__.max__II(0, int((cellHeight - childHeight) / 2));
                break;
              case 1024 :
              case 16777224 :
              case 3 :
                childY = gridY + Math__.max__II(0, cellHeight - childHeight);
                break;
              case 4 :
                childHeight = cellHeight;
                break;
            }
            var child_3: IFigure = grid[i_15][j_8];
            if (child_3 !== null) {
              child_3.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [childX, childY, childWidth, childHeight])));
            }
          }
          gridX += widths[j_8] + horizontalSpacing;
        }
        gridY += heights[i_15] + verticalSpacing;
      }
    }
    for (var i_16: int = 0; i_16 < flushLength; i_16++) {
      flush[i_16].cacheWidth = flush[i_16].cacheHeight = -1;
    }
    var totalDefaultWidth: int = 0;
    var totalDefaultHeight: int = 0;
    for (var i_17: int = 0; i_17 < columnCount; i_17++) {
      totalDefaultWidth += widths[i_17];
    }
    for (var i_18: int = 0; i_18 < rowCount; i_18++) {
      totalDefaultHeight += heights[i_18];
    }
    totalDefaultWidth += horizontalSpacing * (columnCount - 1) + marginWidth * 2;
    totalDefaultHeight += verticalSpacing * (rowCount - 1) + marginHeight * 2;
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [totalDefaultWidth, totalDefaultHeight]));
  }
  public override function getConstraint__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): Object {
    return constraints.get__Ljava_lang_Object_2(child);
  }
  public override function setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure: IFigure, newConstraint: Object): void {
    super.setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure, newConstraint);
    if (newConstraint !== null) {
      constraints.put__Ljava_lang_Object_2Ljava_lang_Object_2(figure, newConstraint);
    }
    return;
  }
  public function GridLayout(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is int && vargs[1] is Boolean) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        GridLayout__();
        break;
      case 1:
        GridLayout__IZ(args1[0], args1[1]);
        break;
    }
  }
  public static const GridLayout__ : int = 0;
  public static const GridLayout__IZ : int = 1;
}
}
