package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class GroupBoxBorder extends AbstractLabeledBorder {
  public function GroupBoxBorder__(): Object {
    return this;
  }
  public function GroupBoxBorder__Ljava_lang_String_2(s: String): Object {
    return this;
  }
  public override function calculateInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets {
    var height: int = this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure).height;
    return new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__I, [height]));
  }
  public override function getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Dimension {
    var textSize: Dimension = this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(fig);
    return textSize.getCopy__().expand__II(textSize.height * 2, 0);
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure: IFigure, g: Graphics, insets_1: Insets): void {
    AbstractBorder.tempRect.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(AbstractBorder.getPaintRectangle__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2(figure, insets_1));
    var r: Rectangle = AbstractBorder.tempRect;
    if (r.isEmpty__())
      return;
    var textLoc: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [r.getTopLeft__(), this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure)]));
    r.crop__Lorg_eclipse_draw2d_geometry_Insets_2(new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__I, [int(this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(figure).height / 2)])));
    FigureUtilities.paintEtchedBorder__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Rectangle_2(g, r);
    textLoc.x += this.getInsets__Lorg_eclipse_draw2d_IFigure_2(figure).left;
    g.setFont__Lorg_eclipse_swt_graphics_Font_2(this.getFont__Lorg_eclipse_draw2d_IFigure_2(figure));
    g.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(this.getTextColor__());
    g.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(textLoc);
    g.fillText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(this.getLabel__(), textLoc.getTopLeft__());
  }
  public function GroupBoxBorder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.AbstractLabeledBorder.AbstractLabeledBorder__, []);
        break;
      case 1:
        var args1: Array = [args[0]];
        superArgs = new Arguments(org.eclipse.draw2d.AbstractLabeledBorder.AbstractLabeledBorder__Ljava_lang_String_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        GroupBoxBorder__();
        break;
      case 1:
        GroupBoxBorder__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const GroupBoxBorder__ : int = 0;
  public static const GroupBoxBorder__Ljava_lang_String_2 : int = 1;
}
}
