package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Image;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class ImageFigure extends Figure {
  private var img: Image;
  private var size: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
  private var alignment: int;
  public function ImageFigure__(): Object {
    return this;
  }
  public function ImageFigure__Lorg_eclipse_swt_graphics_Image_2(image: Image): Object {
    return this;
  }
  public function ImageFigure__Lorg_eclipse_swt_graphics_Image_2I(image: Image, alignment: int): Object {
    this.setImage__Lorg_eclipse_swt_graphics_Image_2(image);
    this.setAlignment__I(alignment);
    return this;
  }
  public function getImage__(): Image {
    return img;
  }
  public override function getPreferredSize__II(wHint: int, hHint: int): Dimension {
    if (this.getInsets__() === org.eclipse.draw2d.IFigure$$fields.NO_INSETS)
      return size;
    var i: Insets = this.getInsets__();
    return size.getExpanded__II(i.getWidth__(), i.getHeight__());
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    super.paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics);
    if (this.getImage__() === null)
      return;
    var x: int;
    var y: int;
    var area: Rectangle = this.getClientArea__();
    switch (alignment & 5) {
      case 1 :
        y = area.y;
        break;
      case 4 :
        y = area.y + area.height - size.height;
        break;
      default :
        y = int((area.height - size.height) / 2) + area.y;
        break;
    }
    switch (alignment & 24) {
      case 16 :
        x = area.x + area.width - size.width;
        break;
      case 8 :
        x = area.x;
        break;
      default :
        x = int((area.width - size.width) / 2) + area.x;
        break;
    }
    graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2II(this.getImage__(), x, y);
  }
  public function setAlignment__I(flag: int): void {
    alignment = flag;
  }
  public function setImage__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
    if (img === image)
      return;
    img = image;
    if (img !== null)
      size = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [image.getBounds__()])).getSize__();
    else
      size = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    this.revalidate__();
    this.repaint__();
  }
  public function ImageFigure(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Image) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 2 && vargs[0] is Image && vargs[1] is int) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        args2 = [null, 2];
        break;
      case 1:
        var args1: Array = [args[0]];
        args2 = [args1[0], 2];
        break;
      case 2:
        var args2: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        ImageFigure__Lorg_eclipse_swt_graphics_Image_2I(args2[0], args2[1]);
        ImageFigure__();
        break;
      case 1:
        ImageFigure__Lorg_eclipse_swt_graphics_Image_2I(args2[0], args2[1]);
        ImageFigure__Lorg_eclipse_swt_graphics_Image_2(args1[0]);
        break;
      case 2:
        ImageFigure__Lorg_eclipse_swt_graphics_Image_2I(args2[0], args2[1]);
        break;
    }
  }
  public static const ImageFigure__ : int = 0;
  public static const ImageFigure__Lorg_eclipse_swt_graphics_Image_2 : int = 1;
  public static const ImageFigure__Lorg_eclipse_swt_graphics_Image_2I : int = 2;
}
}
