package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ImageUtilities {
  public static function createRotatedImageOfString__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(string: String, font: Font, foreground: Color, background: Color): Image {
    var display: Display = Display.getCurrent__();
    if (display === null)
      SWT.error__I(22);
    var metrics: FontMetrics = FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(font);
    var strSize: Dimension = FigureUtilities.getStringExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(string, font);
    var srcImage: Image = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2II, [display, strSize.width, metrics.getAscent__()]));
    var gc: GC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2, [srcImage]));
    gc.setFont__Lorg_eclipse_swt_graphics_Font_2(font);
    gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(foreground);
    gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(background);
    gc.fillRectangle__Lorg_eclipse_swt_graphics_Rectangle_2(srcImage.getBounds__());
    gc.drawString__Ljava_lang_String_2II(string, 0, 0 - metrics.getLeading__());
    var result: Image = createRotatedImage__Lorg_eclipse_swt_graphics_Image_2(srcImage);
    gc.dispose__();
    srcImage.dispose__();
    return result;
  }
  public static function createRotatedImage__Lorg_eclipse_swt_graphics_Image_2(srcImage: Image): Image {
    var display: Display = Display.getCurrent__();
    if (display === null)
      SWT.error__I(22);
    var srcData: ImageData = srcImage.getImageData__();
    var destData: ImageData;
    if (srcData.depth < 8)
      destData = rotatePixelByPixel__Lorg_eclipse_swt_graphics_ImageData_2(srcData);
    else
      destData = rotateOptimized__Lorg_eclipse_swt_graphics_ImageData_2(srcData);
    return new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [display, destData]));
  }
  public static function createShadedImage__Lorg_eclipse_swt_graphics_Image_2Lorg_eclipse_swt_graphics_Color_2(fromImage: Image, shade: Color): ImageData {
    var r: Rectangle = fromImage.getBounds__();
    var data: ImageData = fromImage.getImageData__();
    var palette: PaletteData = data.palette;
    if (!palette.isDirect) {
      var rgbs: JavaArray = palette.getRGBs__();
      for (var i: int = 0; i < rgbs.length; i++) {
        if (data.transparentPixel != i) {
          var color: RGB = rgbs[i];
          color.red = determineShading__II(color.red, shade.getRed__());
          color.blue = determineShading__II(color.blue, shade.getBlue__());
          color.green = determineShading__II(color.green, shade.getGreen__());
        }
      }
      data.palette = new PaletteData(new Arguments(org.eclipse.swt.graphics.PaletteData.PaletteData___3Lorg_eclipse_swt_graphics_RGB_2, [rgbs]));
    } else {
      var scanline: JavaArray = new JavaArray("[I").lengths(r.width);
      var redMask: int = palette.redMask;
      var greenMask: int = palette.greenMask;
      var blueMask: int = palette.blueMask;
      var redShift: int = palette.redShift;
      var greenShift: int = palette.greenShift;
      var blueShift: int = palette.blueShift;
      for (var y: int = 0; y < r.height; y++) {
        data.getPixels__III_3II(0, y, r.width, scanline, 0);
        for (var x: int = 0; x < r.width; x++) {
          var pixel: int = scanline[x];
          var red: int = pixel & redMask;
          red = (redShift < 0) ? red >>> -redShift : red << redShift;
          var green: int = pixel & greenMask;
          green = (greenShift < 0) ? green >>> -greenShift : green << greenShift;
          var blue: int = pixel & blueMask;
          blue = (blueShift < 0) ? blue >>> -blueShift : blue << blueShift;
          red = determineShading__II(red, shade.getRed__());
          blue = determineShading__II(blue, shade.getBlue__());
          green = determineShading__II(green, shade.getGreen__());
          red = (redShift < 0) ? red << -redShift : red >> redShift;
          red &= redMask;
          green = (greenShift < 0) ? green << -greenShift : green >> greenShift;
          green &= greenMask;
          blue = (blueShift < 0) ? blue << -blueShift : blue >> blueShift;
          blue &= blueMask;
          scanline[x] = red | blue | green;
        }
        data.setPixels__III_3II(0, y, r.width, scanline, 0);
      }
    }
    return data;
  }
  private static function determineShading__II(origColor: int, shadeColor: int): int {
    return int((origColor + shadeColor) / 2);
  }
  private static function rotateOptimized__Lorg_eclipse_swt_graphics_ImageData_2(srcData: ImageData): ImageData {
    var bytesPerPixel: int = Math__.max__II(1, int(srcData.depth / 8));
    var destBytesPerLine: int = (int((srcData.height * bytesPerPixel - 1) / srcData.scanlinePad) + 1) * srcData.scanlinePad;
    var newData: JavaArray = new JavaArray("[B").lengths(destBytesPerLine * srcData.width);
    for (var srcY: int = 0; srcY < srcData.height; srcY++) {
      for (var srcX: int = 0; srcX < srcData.width; srcX++) {
        var destX: int = srcY;
        var destY: int = srcData.width - srcX - 1;
        var destIndex: int = (destY * destBytesPerLine) + (destX * bytesPerPixel);
        var srcIndex: int = (srcY * srcData.bytesPerLine) + (srcX * bytesPerPixel);
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
      }
    }
    return new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2I_3B, [srcData.height, srcData.width, srcData.depth, srcData.palette, srcData.scanlinePad, newData]));
  }
  private static function rotatePixelByPixel__Lorg_eclipse_swt_graphics_ImageData_2(srcData: ImageData): ImageData {
    var destData: ImageData = new ImageData(new Arguments(org.eclipse.swt.graphics.ImageData.ImageData__IIILorg_eclipse_swt_graphics_PaletteData_2, [srcData.height, srcData.width, srcData.depth, srcData.palette]));
    for (var y: int = 0; y < srcData.height; y++) {
      for (var x: int = 0; x < srcData.width; x++) {
        destData.setPixel__III(y, srcData.width - x - 1, srcData.getPixel__II(x, y));
      }
    }
    return destData;
  }
}
}
