package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class Label extends Figure implements PositionConstants {
  public static var ELLIPSIS: String = "...";
  private var icon: Image;
  private var text: String = "";
  private var subStringText: String;
  private var textSize: Dimension;
  private var subStringTextSize: Dimension;
  private var iconSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [0, 0]));
  private var iconLocation: Point;
  private var textLocation: Point;
  private var textAlignment: int = 2;
  private var iconAlignment: int = 2;
  private var labelAlignment: int = 2;
  private var textPlacement: int = 16;
  private var iconTextGap: int = 3;
  public function Label__(): Object {
    return this;
  }
  public function Label__Ljava_lang_String_2(s: String): Object {
    this.setText__Ljava_lang_String_2(s);
    return this;
  }
  public function Label__Lorg_eclipse_swt_graphics_Image_2(i: Image): Object {
    this.setIcon__Lorg_eclipse_swt_graphics_Image_2(i);
    return this;
  }
  public function Label__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Image_2(s: String, i: Image): Object {
    this.setText__Ljava_lang_String_2(s);
    this.setIcon__Lorg_eclipse_swt_graphics_Image_2(i);
    return this;
  }
  private function alignOnHeight__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(loc: Point, size: Dimension, alignment: int): void {
    var insets: Insets = this.getInsets__();
    switch (alignment) {
      case 8 :
        loc.y = insets.top;
        break;
      case 32 :
        loc.y = bounds.height - size.height - insets.bottom;
        break;
      default :
        loc.y = int((bounds.height - size.height) / 2);
    }
    return;
  }
  private function alignOnWidth__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(loc: Point, size: Dimension, alignment: int): void {
    var insets: Insets = this.getInsets__();
    switch (alignment) {
      case 1 :
        loc.x = insets.left;
        break;
      case 4 :
        loc.x = bounds.width - size.width - insets.right;
        break;
      default :
        loc.x = int((bounds.width - size.width) / 2);
    }
    return;
  }
  private function calculateAlignment__(): void {
    switch (textPlacement) {
      case 16 :
      case 8 :
        this.alignOnHeight__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(textLocation, this.getTextSize__(), textAlignment);
        this.alignOnHeight__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(iconLocation, this.getIconSize__(), iconAlignment);
        break;
      case 1 :
      case 4 :
        this.alignOnWidth__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(textLocation, this.getSubStringTextSize__(), textAlignment);
        this.alignOnWidth__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2I(iconLocation, this.getIconSize__(), iconAlignment);
        break;
    }
    return;
  }
  public function calculateLabelSize__Lorg_eclipse_draw2d_geometry_Dimension_2(txtSize: Dimension): Dimension {
    var gap: int = this.getIconTextGap__();
    if (this.getIcon__() === null || Object(this.getText__()).equals__Ljava_lang_Object_2(""))
      gap = 0;
    var d: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [0, 0]));
    if (textPlacement == 8 || textPlacement == 16) {
      d.width = this.getIconSize__().width + gap + txtSize.width;
      d.height = Math__.max__II(this.getIconSize__().height, txtSize.height);
    } else {
      d.width = Math__.max__II(this.getIconSize__().width, txtSize.width);
      d.height = this.getIconSize__().height + gap + txtSize.height;
    }
    return d;
  }
  private function calculateLocations__(): void {
    textLocation = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
    iconLocation = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
    this.calculatePlacement__();
    this.calculateAlignment__();
    var offset: Dimension = this.getSize__().getDifference__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getPreferredSize__());
    offset.width += this.getTextSize__().width - this.getSubStringTextSize__().width;
    switch (labelAlignment) {
      case 2 :
        offset.scale__D(0.5);
        break;
      case 1 :
        offset.scale__D(0.0);
        break;
      case 4 :
        offset.scale__D(1.0);
        break;
      case 8 :
        offset.height = 0;
        offset.scale__D(0.5);
        break;
      case 32 :
        offset.height = offset.height * 2;
        offset.scale__D(0.5);
        break;
      default :
        offset.scale__D(0.5);
        break;
    }
    switch (textPlacement) {
      case 16 :
      case 8 :
        offset.height = 0;
        break;
      case 1 :
      case 4 :
        offset.width = 0;
        break;
    }
    textLocation.translate__Lorg_eclipse_draw2d_geometry_Dimension_2(offset);
    iconLocation.translate__Lorg_eclipse_draw2d_geometry_Dimension_2(offset);
  }
  private function calculatePlacement__(): void {
    var gap: int = this.getIconTextGap__();
    if (icon === null || Object(text).equals__Ljava_lang_Object_2(""))
      gap = 0;
    var insets: Insets = this.getInsets__();
    switch (textPlacement) {
      case 16 :
        iconLocation.x = insets.left;
        textLocation.x = this.getIconSize__().width + gap + insets.left;
        break;
      case 8 :
        textLocation.x = insets.left;
        iconLocation.x = this.getSubStringTextSize__().width + gap + insets.left;
        break;
      case 1 :
        textLocation.y = insets.top;
        iconLocation.y = this.getTextSize__().height + gap + insets.top;
        break;
      case 4 :
        textLocation.y = this.getIconSize__().height + gap + insets.top;
        iconLocation.y = insets.top;
    }
  }
  public function calculateSubStringTextSize__(): Dimension {
    return this.getTextUtilities__().getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(this.getSubStringText__(), this.getFont__());
  }
  public function calculateTextSize__(): Dimension {
    return this.getTextUtilities__().getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(this.getText__(), this.getFont__());
  }
  private function clearLocations__(): void {
    iconLocation = textLocation = null;
  }
  public function getIcon__(): Image {
    return icon;
  }
  public function getIconAlignment__(): int {
    return iconAlignment;
  }
  public function getIconBounds__(): Rectangle {
    var bounds_1: Rectangle = this.getBounds__();
    return new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [bounds_1.getLocation__().translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getIconLocation__()), this.getIconSize__()]));
  }
  public function getIconLocation__(): Point {
    if (iconLocation === null)
      this.calculateLocations__();
    return iconLocation;
  }
  public function getIconTextGap__(): int {
    return iconTextGap;
  }
  public override function getMinimumSize__II(w: int, h: int): Dimension {
    if (minSize !== null)
      return minSize;
    minSize = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, []));
    if (this.getLayoutManager__() !== null)
      minSize.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getLayoutManager__().getMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(this, w, h));
    var labelSize: Dimension = this.calculateLabelSize__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getTextUtilities__().getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(this.getTruncationString__(), this.getFont__()).intersect__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getTextUtilities__().getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(this.getText__(), this.getFont__())));
    var insets: Insets = this.getInsets__();
    labelSize.expand__II(insets.getWidth__(), insets.getHeight__());
    minSize.union__Lorg_eclipse_draw2d_geometry_Dimension_2(labelSize);
    return minSize;
  }
  public override function getPreferredSize__II(wHint: int, hHint: int): Dimension {
    if (prefSize === null) {
      prefSize = this.calculateLabelSize__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getTextSize__());
      var insets: Insets = this.getInsets__();
      prefSize.expand__II(insets.getWidth__(), insets.getHeight__());
      if (this.getLayoutManager__() !== null)
        prefSize.union__Lorg_eclipse_draw2d_geometry_Dimension_2(this.getLayoutManager__().getPreferredSize__Lorg_eclipse_draw2d_IFigure_2II(this, wHint, hHint));
    }
    if (wHint >= 0 && wHint < prefSize.width) {
      var minSize_1: Dimension = this.getMinimumSize__II(wHint, hHint);
      var result: Dimension = prefSize.getCopy__();
      result.width = Math__.min__II(result.width, wHint);
      result.width = Math__.max__II(minSize_1.width, result.width);
      return result;
    }
    return prefSize;
  }
  public function getSubStringText__(): String {
    if (subStringText !== null)
      return subStringText;
    subStringText = text;
    var widthShrink: int = this.getPreferredSize__().width - this.getSize__().width;
    if (widthShrink <= 0)
      return subStringText;
    var effectiveSize: Dimension = this.getTextSize__().getExpanded__II(-widthShrink, 0);
    var currentFont: Font = this.getFont__();
    var dotsWidth: int = this.getTextUtilities__().getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(this.getTruncationString__(), currentFont).width;
    if (effectiveSize.width < dotsWidth)
      effectiveSize.width = dotsWidth;
    var subStringLength: int = this.getTextUtilities__().getLargestSubstringConfinedTo__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2I(text, currentFont, effectiveSize.width - dotsWidth);
    subStringText = Object(String).__init__Ljava_lang_String_2(Object(text).substring__II(0, subStringLength) + this.getTruncationString__());
    return subStringText;
  }
  public function getSubStringTextSize__(): Dimension {
    if (subStringTextSize === null)
      subStringTextSize = this.calculateSubStringTextSize__();
    return subStringTextSize;
  }
  public function getText__(): String {
    return text;
  }
  public function getTextAlignment__(): int {
    return textAlignment;
  }
  public function getTextBounds__(): Rectangle {
    var bounds_1: Rectangle = this.getBounds__();
    return new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [bounds_1.getLocation__().translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getTextLocation__()), textSize]));
  }
  public function getTextLocation__(): Point {
    if (textLocation !== null)
      return textLocation;
    this.calculateLocations__();
    return textLocation;
  }
  public function getTextPlacement__(): int {
    return textPlacement;
  }
  public function getTextSize__(): Dimension {
    if (textSize === null)
      textSize = this.calculateTextSize__();
    return textSize;
  }
  public override function invalidate__(): void {
    prefSize = null;
    minSize = null;
    this.clearLocations__();
    textSize = null;
    subStringTextSize = null;
    subStringText = null;
    super.invalidate__();
  }
  public function isTextTruncated__(): Boolean {
    return !Object(this.getSubStringText__()).equals__Ljava_lang_Object_2(this.getText__());
  }
  public override function paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.isOpaque__())
      super.paintFigure__Lorg_eclipse_draw2d_Graphics_2(graphics);
    var bounds_1: Rectangle = this.getBounds__();
    graphics.translate__II(bounds_1.x, bounds_1.y);
    if (icon !== null)
      graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2Lorg_eclipse_draw2d_geometry_Point_2(icon, this.getIconLocation__());
    if (!this.isEnabled__()) {
      graphics.translate__II(1, 1);
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonLightest);
      graphics.drawText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(this.getSubStringText__(), this.getTextLocation__());
      graphics.translate__II(-1, -1);
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
    }
    graphics.drawText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(this.getSubStringText__(), this.getTextLocation__());
    graphics.translate__II(-bounds_1.x, -bounds_1.y);
    return;
  }
  public function setIcon__Lorg_eclipse_swt_graphics_Image_2(image: Image): void {
    if (icon === image)
      return;
    icon = image;
    this.repaint__();
    if (icon === null)
      this.setIconDimension__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__, [])));
    else
      this.setIconDimension__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_swt_graphics_Image_2, [image])));
  }
  public function setIconAlignment__I(align: int): void {
    if (iconAlignment == align)
      return;
    iconAlignment = align;
    this.clearLocations__();
    this.repaint__();
  }
  public function setIconDimension__Lorg_eclipse_draw2d_geometry_Dimension_2(d: Dimension): void {
    if (d.equals__Ljava_lang_Object_2(this.getIconSize__()))
      return;
    iconSize = d;
    this.revalidate__();
  }
  public function setIconTextGap__I(gap: int): void {
    if (iconTextGap == gap)
      return;
    iconTextGap = gap;
    this.repaint__();
    this.revalidate__();
  }
  public function setLabelAlignment__I(align: int): void {
    if (labelAlignment == align)
      return;
    labelAlignment = align;
    this.clearLocations__();
    this.repaint__();
  }
  public function setText__Ljava_lang_String_2(s: String): void {
    if (s === null)
      s = "";
    if (Object(text).equals__Ljava_lang_Object_2(s))
      return;
    text = s;
    this.revalidate__();
    this.repaint__();
  }
  public function setTextAlignment__I(align: int): void {
    if (textAlignment == align)
      return;
    textAlignment = align;
    this.clearLocations__();
    this.repaint__();
  }
  public function setTextPlacement__I(where: int): void {
    if (textPlacement == where)
      return;
    textPlacement = where;
    this.revalidate__();
    this.repaint__();
  }
  public function getTextUtilities__(): TextUtilities {
    return TextUtilities.INSTANCE;
  }
  public function getTruncationString__(): String {
    return ELLIPSIS;
  }
  public function getIconSize__(): Dimension {
    return iconSize;
  }
  public function getLabelAlignment__(): int {
    return labelAlignment;
  }
  public function Label(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is Image) {
        args = vargs;
        id = 2;
      } else if (vargs.length == 2 && vargs[0] is String && vargs[1] is Image) {
        args = vargs;
        id = 3;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
      case 3:
        var args3: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        Label__();
        break;
      case 1:
        Label__Ljava_lang_String_2(args1[0]);
        break;
      case 2:
        Label__Lorg_eclipse_swt_graphics_Image_2(args2[0]);
        break;
      case 3:
        Label__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Image_2(args3[0], args3[1]);
        break;
    }
  }
  public static const Label__ : int = 0;
  public static const Label__Ljava_lang_String_2 : int = 1;
  public static const Label__Lorg_eclipse_swt_graphics_Image_2 : int = 2;
  public static const Label__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Image_2 : int = 3;
}
}
