package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class LightweightSystem {
  private var canvas: Canvas;
  internal var contents: IFigure;
  private var root: IFigure;
  private var dispatcher: EventDispatcher;
  private var manager: UpdateManager = new DeferredUpdateManager(new Arguments(org.eclipse.draw2d.DeferredUpdateManager.DeferredUpdateManager__, []));
  private var ignoreResize: int;
  public function LightweightSystem__Lorg_eclipse_swt_widgets_Canvas_2(c: Canvas): Object {
    this.setControl__Lorg_eclipse_swt_widgets_Canvas_2(c);
    return this;
  }
  public function LightweightSystem__(): Object {
    this.init__();
    return this;
  }
  public function addListeners__(): void {
    var handler: LightweightSystem$EventHandler = this.createEventHandler__();
    canvas.getAccessible__().addAccessibleListener__Lorg_eclipse_swt_accessibility_AccessibleListener_2(handler);
    canvas.getAccessible__().addAccessibleControlListener__Lorg_eclipse_swt_accessibility_AccessibleControlListener_2(handler);
    canvas.addMouseListener__Lorg_eclipse_swt_events_MouseListener_2(handler);
    canvas.addMouseMoveListener__Lorg_eclipse_swt_events_MouseMoveListener_2(handler);
    canvas.addMouseTrackListener__Lorg_eclipse_swt_events_MouseTrackListener_2(handler);
    canvas.addKeyListener__Lorg_eclipse_swt_events_KeyListener_2(handler);
    canvas.addTraverseListener__Lorg_eclipse_swt_events_TraverseListener_2(handler);
    canvas.addFocusListener__Lorg_eclipse_swt_events_FocusListener_2(handler);
    canvas.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(handler);
    canvas.addListener__ILorg_eclipse_swt_widgets_Listener_2(37, handler);
    canvas.addControlListener__Lorg_eclipse_swt_events_ControlListener_2(new org.eclipse.draw2d.LightweightSystem$1(this));
    canvas.addListener__ILorg_eclipse_swt_widgets_Listener_2(9, new org.eclipse.draw2d.LightweightSystem$2(this));
  }
  public function controlResized__(): void {
    if (ignoreResize > 0)
      return;
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [canvas.getClientArea__()]));
    r.setLocation__II(0, 0);
    root.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    root.revalidate__();
    this.getUpdateManager__().performUpdate__();
  }
  public function getEventDispatcher__(): EventDispatcher {
    if (dispatcher === null)
      this.setEventDispatcher__Lorg_eclipse_draw2d_EventDispatcher_2(new SWTEventDispatcher());
    return dispatcher;
  }
  public function getRootFigure__(): IFigure {
    return root;
  }
  public function createEventHandler__(): LightweightSystem$EventHandler {
    return this.internalCreateEventHandler__();
  }
  public function createRootFigure__(): LightweightSystem$RootFigure {
    var f: LightweightSystem$RootFigure = new LightweightSystem$RootFigure(this);
    f.addNotify__();
    f.setOpaque__Z(true);
    f.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new StackLayout());
    return f;
  }
  public function getUpdateManager__(): UpdateManager {
    return manager;
  }
  public function init__(): void {
    this.setRootPaneFigure__Lorg_eclipse_draw2d_LightweightSystem$RootFigure_2(this.createRootFigure__());
  }
  public function internalCreateEventHandler__(): LightweightSystem$EventHandler {
    return new LightweightSystem$EventHandler(this);
  }
  public function paint__Lorg_eclipse_swt_graphics_GC_2(gc: GC): void {
    this.getUpdateManager__().paint__Lorg_eclipse_swt_graphics_GC_2(gc);
  }
  public function setContents__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    if (contents !== null)
      root.remove__Lorg_eclipse_draw2d_IFigure_2(contents);
    contents = figure;
    root.add__Lorg_eclipse_draw2d_IFigure_2(contents);
  }
  public function setControl__Lorg_eclipse_swt_widgets_Canvas_2(c: Canvas): void {
    if (canvas === c)
      return;
    canvas = c;
    if ((c.getStyle__() & 536870912) != 0)
      this.getUpdateManager__().setGraphicsSource__Lorg_eclipse_draw2d_GraphicsSource_2(new NativeGraphicsSource(canvas));
    else
      this.getUpdateManager__().setGraphicsSource__Lorg_eclipse_draw2d_GraphicsSource_2(new BufferedGraphicsSource(canvas));
    this.getEventDispatcher__().setControl__Lorg_eclipse_swt_widgets_Control_2(c);
    this.addListeners__();
    var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [canvas.getClientArea__()]));
    r.setLocation__II(0, 0);
    root.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(r);
    root.revalidate__();
  }
  public function setEventDispatcher__Lorg_eclipse_draw2d_EventDispatcher_2(dispatcher_1: EventDispatcher): void {
    this.dispatcher = dispatcher_1;
    dispatcher_1.setRoot__Lorg_eclipse_draw2d_IFigure_2(root);
    dispatcher_1.setControl__Lorg_eclipse_swt_widgets_Control_2(canvas);
  }
  public function setIgnoreResize__Z(value: Boolean): void {
    if (value)
      ignoreResize++;
    else
      ignoreResize--;
  }
  public function setRootPaneFigure__Lorg_eclipse_draw2d_LightweightSystem$RootFigure_2(root_1: LightweightSystem$RootFigure): void {
    this.getUpdateManager__().setRoot__Lorg_eclipse_draw2d_IFigure_2(root_1);
    this.root = root_1;
  }
  public function setUpdateManager__Lorg_eclipse_draw2d_UpdateManager_2(um: UpdateManager): void {
    manager = um;
    manager.setRoot__Lorg_eclipse_draw2d_IFigure_2(root);
  }
  public static function access$0(arg0: LightweightSystem): Canvas {
    return arg0.canvas;
  }
  public function LightweightSystem(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Canvas) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 0) {
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        break;
      case 1:
        break;
    }
    super();
    switch (id) {
      case 0:
        LightweightSystem__();
        LightweightSystem__Lorg_eclipse_swt_widgets_Canvas_2(args0[0]);
        break;
      case 1:
        LightweightSystem__();
        break;
    }
  }
  public static const LightweightSystem__Lorg_eclipse_swt_widgets_Canvas_2 : int = 0;
  public static const LightweightSystem__ : int = 1;
}
}
