package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.lang.Math__;
import java.lang.Integer;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ManhattanConnectionRouter extends AbstractRouter {
  private var rowsUsed: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var colsUsed: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var reservedInfo: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  public static var UP: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [0, -1]));
  public static var DOWN: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [0, 1]));
  public static var LEFT: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [-1, 0]));
  public static var RIGHT: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__II, [1, 0]));
  public override function invalidate__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    this.removeReservedLines__Lorg_eclipse_draw2d_Connection_2(connection);
    return;
  }
  private function getColumnNear__Lorg_eclipse_draw2d_Connection_2III(connection: Connection, r: int, n: int, x: int): int {
    var min: int = Math__.min__II(n, x);
    var max: int = Math__.max__II(n, x);
    if (min > r) {
      max = min;
      min = r - (min - r);
    }
    if (max < r) {
      min = max;
      max = r + (r - max);
    }
    var proximity: int = 0;
    var direction: int = -1;
    if (r % 2 == 1)
      r--;
    var i: Integer;
    while (proximity < r) {
      i = new Integer(new Arguments(java.lang.Integer.Integer__I, [r + proximity * direction]));
      if (!colsUsed.containsKey__Ljava_lang_Object_2(i)) {
        colsUsed.put__Ljava_lang_Object_2Ljava_lang_Object_2(i, i);
        this.reserveColumn__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Integer_2(connection, i);
        return i.intValue__();
      }
      var j: int = i.intValue__();
      if (j <= min)
        return j + 2;
      if (j >= max)
        return j - 2;
      if (direction == 1)
        direction = -1;
      else {
        direction = 1;
        proximity += 2;
      }
    }
    return r;
  }
  public function getDirection__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_geometry_Point_2(r: Rectangle, p: Point): Ray {
    var i: int;
    var distance: int = Math__.abs__I(r.x - p.x);
    var direction: Ray;
    direction = LEFT;
    i = Math__.abs__I(r.y - p.y);
    if (i <= distance) {
      distance = i;
      direction = UP;
    }
    i = Math__.abs__I(r.bottom__() - p.y);
    if (i <= distance) {
      distance = i;
      direction = DOWN;
    }
    i = Math__.abs__I(r.right__() - p.x);
    if (i < distance) {
      distance = i;
      direction = RIGHT;
    }
    return direction;
  }
  public function getEndDirection__Lorg_eclipse_draw2d_Connection_2(conn: Connection): Ray {
    var anchor: ConnectionAnchor = conn.getTargetAnchor__();
    var p: Point = this.getEndPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    var rect: Rectangle;
    if (anchor.getOwner__() === null)
      rect = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [p.x - 1, p.y - 1, 2, 2]));
    else {
      rect = conn.getTargetAnchor__().getOwner__().getBounds__().getCopy__();
      conn.getTargetAnchor__().getOwner__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(rect);
    }
    return this.getDirection__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_geometry_Point_2(rect, p);
  }
  public function getRowNear__Lorg_eclipse_draw2d_Connection_2III(connection: Connection, r: int, n: int, x: int): int {
    var min: int = Math__.min__II(n, x);
    var max: int = Math__.max__II(n, x);
    if (min > r) {
      max = min;
      min = r - (min - r);
    }
    if (max < r) {
      min = max;
      max = r + (r - max);
    }
    var proximity: int = 0;
    var direction: int = -1;
    if (r % 2 == 1)
      r--;
    var i: Integer;
    while (proximity < r) {
      i = new Integer(new Arguments(java.lang.Integer.Integer__I, [r + proximity * direction]));
      if (!rowsUsed.containsKey__Ljava_lang_Object_2(i)) {
        rowsUsed.put__Ljava_lang_Object_2Ljava_lang_Object_2(i, i);
        this.reserveRow__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Integer_2(connection, i);
        return i.intValue__();
      }
      var j: int = i.intValue__();
      if (j <= min)
        return j + 2;
      if (j >= max)
        return j - 2;
      if (direction == 1)
        direction = -1;
      else {
        direction = 1;
        proximity += 2;
      }
    }
    return r;
  }
  public function getStartDirection__Lorg_eclipse_draw2d_Connection_2(conn: Connection): Ray {
    var anchor: ConnectionAnchor = conn.getSourceAnchor__();
    var p: Point = this.getStartPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    var rect: Rectangle;
    if (anchor.getOwner__() === null)
      rect = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [p.x - 1, p.y - 1, 2, 2]));
    else {
      rect = conn.getSourceAnchor__().getOwner__().getBounds__().getCopy__();
      conn.getSourceAnchor__().getOwner__().translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(rect);
    }
    return this.getDirection__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_geometry_Point_2(rect, p);
  }
  public function processPositions__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2Ljava_util_List_2ZLorg_eclipse_draw2d_Connection_2(start: Ray, end: Ray, positions: List, horizontal: Boolean, conn: Connection): void {
    this.removeReservedLines__Lorg_eclipse_draw2d_Connection_2(conn);
    var pos: JavaArray = new JavaArray("[I").lengths(positions.size__() + 2);
    if (horizontal)
      pos[0] = start.x;
    else
      pos[0] = start.y;
    var i: int;
    for (i = 0; i < positions.size__(); i++) {
      pos[i + 1] = (Integer(positions.get__I(i))).intValue__();
    }
    if (horizontal == (positions.size__() % 2 == 1))
      pos[++i] = end.x;
    else
      pos[++i] = end.y;
    var points: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [start.x, start.y])));
    var p: Point;
    var current: int;
    var prev: int;
    var min: int;
    var max: int;
    var adjust: Boolean;
    for (i = 2; i < pos.length - 1; i++) {
      horizontal = !horizontal;
      prev = pos[i - 1];
      current = pos[i];
      adjust = (i != pos.length - 2);
      if (horizontal) {
        if (adjust) {
          min = pos[i - 2];
          max = pos[i + 2];
          pos[i] = current = this.getRowNear__Lorg_eclipse_draw2d_Connection_2III(conn, current, min, max);
        }
        p = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [prev, current]));
      } else {
        if (adjust) {
          min = pos[i - 2];
          max = pos[i + 2];
          pos[i] = current = this.getColumnNear__Lorg_eclipse_draw2d_Connection_2III(conn, current, min, max);
        }
        p = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [current, prev]));
      }
      points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(p);
    }
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [end.x, end.y])));
    conn.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
    return;
  }
  public override function remove__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    this.removeReservedLines__Lorg_eclipse_draw2d_Connection_2(connection);
    return;
  }
  public function removeReservedLines__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    var rInfo: ManhattanConnectionRouter$ReservedInfo = ManhattanConnectionRouter$ReservedInfo(reservedInfo.get__Ljava_lang_Object_2(connection));
    if (rInfo === null)
      return;
    for (var i: int = 0; i < rInfo.reservedRows.size__(); i++) {
      rowsUsed.remove__Ljava_lang_Object_2(rInfo.reservedRows.get__I(i));
    }
    for (var i_1: int = 0; i_1 < rInfo.reservedCols.size__(); i_1++) {
      colsUsed.remove__Ljava_lang_Object_2(rInfo.reservedCols.get__I(i_1));
    }
    reservedInfo.remove__Ljava_lang_Object_2(connection);
    return;
  }
  public function reserveColumn__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Integer_2(connection: Connection, column: Integer): void {
    var info: ManhattanConnectionRouter$ReservedInfo = ManhattanConnectionRouter$ReservedInfo(reservedInfo.get__Ljava_lang_Object_2(connection));
    if (info === null) {
      info = new ManhattanConnectionRouter$ReservedInfo(this);
      reservedInfo.put__Ljava_lang_Object_2Ljava_lang_Object_2(connection, info);
    }
    info.reservedCols.add__Ljava_lang_Object_2(column);
    return;
  }
  public function reserveRow__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Integer_2(connection: Connection, row: Integer): void {
    var info: ManhattanConnectionRouter$ReservedInfo = ManhattanConnectionRouter$ReservedInfo(reservedInfo.get__Ljava_lang_Object_2(connection));
    if (info === null) {
      info = new ManhattanConnectionRouter$ReservedInfo(this);
      reservedInfo.put__Ljava_lang_Object_2Ljava_lang_Object_2(connection, info);
    }
    info.reservedRows.add__Ljava_lang_Object_2(row);
    return;
  }
  public override function route__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if ((conn.getSourceAnchor__() === null) || (conn.getTargetAnchor__() === null))
      return;
    var i: int;
    var startPoint: Point = this.getStartPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(startPoint);
    var endPoint: Point = this.getEndPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(endPoint);
    var start: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__Lorg_eclipse_draw2d_geometry_Point_2, [startPoint]));
    var end: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__Lorg_eclipse_draw2d_geometry_Point_2, [endPoint]));
    var average: Ray = start.getAveraged__Lorg_eclipse_draw2d_geometry_Ray_2(end);
    var direction: Ray = new Ray(new Arguments(org.eclipse.draw2d.geometry.Ray.Ray__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2, [start, end]));
    var startNormal: Ray = this.getStartDirection__Lorg_eclipse_draw2d_Connection_2(conn);
    var endNormal: Ray = this.getEndDirection__Lorg_eclipse_draw2d_Connection_2(conn);
    var positions: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__I, [5]));
    var horizontal: Boolean = startNormal.isHorizontal__();
    if (horizontal)
      positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [start.y])));
    else
      positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [start.x])));
    horizontal = !horizontal;
    if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(endNormal) == 0) {
      if ((startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) >= 0) && (endNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) <= 0)) {
      } else {
        if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) < 0)
          i = startNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(start.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(startNormal.getScaled__I(10)));
        else {
          if (horizontal)
            i = average.y;
          else
            i = average.x;
        }
        positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
        horizontal = !horizontal;
        if (endNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) > 0)
          i = endNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(end.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(endNormal.getScaled__I(10)));
        else {
          if (horizontal)
            i = average.y;
          else
            i = average.x;
        }
        positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
        horizontal = !horizontal;
      }
    } else {
      if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(endNormal) > 0) {
        if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) >= 0)
          i = startNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(start.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(startNormal.getScaled__I(10)));
        else
          i = endNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(end.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(endNormal.getScaled__I(10)));
        positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
        horizontal = !horizontal;
      } else {
        if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) < 0) {
          i = startNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(start.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(startNormal.getScaled__I(10)));
          positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
          horizontal = !horizontal;
        }
        if (horizontal)
          i = average.y;
        else
          i = average.x;
        positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
        horizontal = !horizontal;
        if (startNormal.dotProduct__Lorg_eclipse_draw2d_geometry_Ray_2(direction) < 0) {
          i = endNormal.similarity__Lorg_eclipse_draw2d_geometry_Ray_2(end.getAdded__Lorg_eclipse_draw2d_geometry_Ray_2(endNormal.getScaled__I(10)));
          positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [i])));
          horizontal = !horizontal;
        }
      }
    }
    if (horizontal)
      positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [end.y])));
    else
      positions.add__Ljava_lang_Object_2(new Integer(new Arguments(java.lang.Integer.Integer__I, [end.x])));
    this.processPositions__Lorg_eclipse_draw2d_geometry_Ray_2Lorg_eclipse_draw2d_geometry_Ray_2Ljava_util_List_2ZLorg_eclipse_draw2d_Connection_2(start, end, positions, startNormal.isHorizontal__(), conn);
    return;
  }
}
}
