package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
dynamic public class Polyline extends AbstractPointListShape {
  private var tolerance: int = 2;
  public static var LINEBOUNDS: Rectangle = Rectangle.SINGLETON;
  public function Polyline() {
    {
      this.setFill__Z(false);
      bounds = null;
    }
    return;
  }
  public override function containsPoint__II(x: int, y: int): Boolean {
    var tolerance_1: int = int(Math__.max__FF(this.getLineWidthFloat__() / 2.0, this.tolerance));
    LINEBOUNDS.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__());
    LINEBOUNDS.expand__II(tolerance_1, tolerance_1);
    if (!LINEBOUNDS.contains__II(x, y))
      return false;
    return this.shapeContainsPoint__II(x, y) || this.childrenContainsPoint__II(x, y);
  }
  public override function shapeContainsPoint__II(x: int, y: int): Boolean {
    return Geometry.polylineContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2III(points, x, y, tolerance);
  }
  public override function fillShape__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
  }
  public override function getBounds__(): Rectangle {
    if (bounds === null) {
      var expand: int = int((this.getLineWidthFloat__() / 2.0));
      bounds = this.getPoints__().getBounds__().getExpanded__II(expand, expand);
    }
    return bounds;
  }
  public override function isOpaque__(): Boolean {
    return false;
  }
  public override function outlineShape__Lorg_eclipse_draw2d_Graphics_2(g: Graphics): void {
    g.drawPolyline__Lorg_eclipse_draw2d_geometry_PointList_2(points);
  }
  public override function primTranslate__II(x: int, y: int): void {
  }
  public override function removeAllPoints__(): void {
    super.removeAllPoints__();
    bounds = null;
  }
  public override function setLineWidth__I(w: int): void {
    if (this.getLineWidthFloat__() == w) {
      return;
    }
    if (w < this.getLineWidthFloat__()) {
      this.erase__();
    }
    bounds = null;
    super.setLineWidthFloat__F(w);
    return;
  }
  public override function setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1: PointList): void {
    super.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1);
    this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("points", null, points_1);
    return;
  }
  public function setTolerance__I(tolerance_1: int): void {
    this.tolerance = tolerance_1;
    return;
  }
  public override function repaint__(): void {
    bounds = null;
    super.repaint__();
    return;
  }
}
}
