package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.List;
import java.util.ArrayList;
import java.lang.Arguments;
dynamic public class PolylineConnection extends Polyline implements Connection, AnchorListener {
  private var startAnchor: ConnectionAnchor;
  private var endAnchor: ConnectionAnchor;
  private var connectionRouter: ConnectionRouter = org.eclipse.draw2d.ConnectionRouter$$fields.NULL;
  private var startArrow: RotatableDecoration;
  private var endArrow: RotatableDecoration;
  public function PolylineConnection() {
    {
      this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new DelegatingLayout());
      this.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [0, 0])));
      this.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [100, 100])));
    }
    return;
  }
  public override function addNotify__(): void {
    super.addNotify__();
    this.hookSourceAnchor__();
    this.hookTargetAnchor__();
    return;
  }
  public function addRoutingListener__Lorg_eclipse_draw2d_RoutingListener_2(listener: RoutingListener): void {
    if (connectionRouter is PolylineConnection$RoutingNotifier) {
      var notifier: PolylineConnection$RoutingNotifier = PolylineConnection$RoutingNotifier(connectionRouter);
      notifier.listeners.add__Ljava_lang_Object_2(listener);
    } else
      connectionRouter = new PolylineConnection$RoutingNotifier(this, connectionRouter, listener);
    return;
  }
  public function anchorMoved__Lorg_eclipse_draw2d_ConnectionAnchor_2(anchor: ConnectionAnchor): void {
    this.revalidate__();
    return;
  }
  public override function getBounds__(): Rectangle {
    if (bounds === null) {
      super.getBounds__();
      for (var i: int = 0; i < this.getChildren__().size__(); i++) {
        var child: IFigure = IFigure(this.getChildren__().get__I(i));
        bounds.union__Lorg_eclipse_draw2d_geometry_Rectangle_2(child.getBounds__());
      }
    }
    return bounds;
  }
  public function getConnectionRouter__(): ConnectionRouter {
    if (connectionRouter is PolylineConnection$RoutingNotifier)
      return (PolylineConnection$RoutingNotifier(connectionRouter)).realRouter;
    return connectionRouter;
  }
  public function getRoutingConstraint__(): Object {
    if (this.getConnectionRouter__() !== null)
      return this.getConnectionRouter__().getConstraint__Lorg_eclipse_draw2d_Connection_2(this);
    else
      return null;
  }
  public function getSourceAnchor__(): ConnectionAnchor {
    return startAnchor;
  }
  public function getSourceDecoration__(): RotatableDecoration {
    return startArrow;
  }
  public function getTargetAnchor__(): ConnectionAnchor {
    return endAnchor;
  }
  public function getTargetDecoration__(): RotatableDecoration {
    return endArrow;
  }
  private function hookSourceAnchor__(): void {
    if (this.getSourceAnchor__() !== null)
      this.getSourceAnchor__().addAnchorListener__Lorg_eclipse_draw2d_AnchorListener_2(this);
  }
  private function hookTargetAnchor__(): void {
    if (this.getTargetAnchor__() !== null)
      this.getTargetAnchor__().addAnchorListener__Lorg_eclipse_draw2d_AnchorListener_2(this);
  }
  public override function layout__(): void {
    if (this.getSourceAnchor__() !== null && this.getTargetAnchor__() !== null)
      connectionRouter.route__Lorg_eclipse_draw2d_Connection_2(this);
    var oldBounds: Rectangle = bounds;
    super.layout__();
    bounds = null;
    if (!this.getBounds__().contains__Lorg_eclipse_draw2d_geometry_Rectangle_2(oldBounds)) {
      this.getParent__().translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(oldBounds);
      this.getUpdateManager__().addDirtyRegion__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getParent__(), oldBounds);
    }
    this.repaint__();
    this.fireFigureMoved__();
    return;
  }
  public override function removeNotify__(): void {
    this.unhookSourceAnchor__();
    this.unhookTargetAnchor__();
    connectionRouter.remove__Lorg_eclipse_draw2d_Connection_2(this);
    super.removeNotify__();
    return;
  }
  public function removeRoutingListener__Lorg_eclipse_draw2d_RoutingListener_2(listener: RoutingListener): void {
    if (connectionRouter is PolylineConnection$RoutingNotifier) {
      var notifier: PolylineConnection$RoutingNotifier = PolylineConnection$RoutingNotifier(connectionRouter);
      notifier.listeners.remove__Ljava_lang_Object_2(listener);
      if (notifier.listeners.isEmpty__())
        connectionRouter = notifier.realRouter;
    }
    return;
  }
  public override function revalidate__(): void {
    super.revalidate__();
    connectionRouter.invalidate__Lorg_eclipse_draw2d_Connection_2(this);
    return;
  }
  public function setConnectionRouter__Lorg_eclipse_draw2d_ConnectionRouter_2(cr: ConnectionRouter): void {
    if (cr === null)
      cr = org.eclipse.draw2d.ConnectionRouter$$fields.NULL;
    var oldRouter: ConnectionRouter = this.getConnectionRouter__();
    if (oldRouter !== cr) {
      connectionRouter.remove__Lorg_eclipse_draw2d_Connection_2(this);
      if (connectionRouter is PolylineConnection$RoutingNotifier)
        (PolylineConnection$RoutingNotifier(connectionRouter)).realRouter = cr;
      else
        connectionRouter = cr;
      this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("connectionRouter", oldRouter, cr);
      this.revalidate__();
    }
    return;
  }
  public function setRoutingConstraint__Ljava_lang_Object_2(cons: Object): void {
    if (connectionRouter !== null)
      connectionRouter.setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(this, cons);
    this.revalidate__();
    return;
  }
  public function setSourceAnchor__Lorg_eclipse_draw2d_ConnectionAnchor_2(anchor: ConnectionAnchor): void {
    if (anchor === startAnchor)
      return;
    this.unhookSourceAnchor__();
    startAnchor = anchor;
    if (this.getParent__() !== null)
      this.hookSourceAnchor__();
    this.revalidate__();
  }
  public function setSourceDecoration__Lorg_eclipse_draw2d_RotatableDecoration_2(dec: RotatableDecoration): void {
    if (startArrow === dec)
      return;
    if (startArrow !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(startArrow);
    startArrow = dec;
    if (startArrow !== null)
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(startArrow, new ArrowLocator(this, 2));
  }
  public function setTargetAnchor__Lorg_eclipse_draw2d_ConnectionAnchor_2(anchor: ConnectionAnchor): void {
    if (anchor === endAnchor)
      return;
    this.unhookTargetAnchor__();
    endAnchor = anchor;
    if (this.getParent__() !== null)
      this.hookTargetAnchor__();
    this.revalidate__();
  }
  public function setTargetDecoration__Lorg_eclipse_draw2d_RotatableDecoration_2(dec: RotatableDecoration): void {
    if (endArrow === dec)
      return;
    if (endArrow !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(endArrow);
    endArrow = dec;
    if (endArrow !== null)
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(endArrow, new ArrowLocator(this, 3));
  }
  private function unhookSourceAnchor__(): void {
    if (this.getSourceAnchor__() !== null)
      this.getSourceAnchor__().removeAnchorListener__Lorg_eclipse_draw2d_AnchorListener_2(this);
  }
  private function unhookTargetAnchor__(): void {
    if (this.getTargetAnchor__() !== null)
      this.getTargetAnchor__().removeAnchorListener__Lorg_eclipse_draw2d_AnchorListener_2(this);
  }
}
}
