package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Transform;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class PolylineDecoration extends Polyline implements RotatableDecoration {
  public static var TRIANGLE_TIP: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
  private var location: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
  private var template: PointList = TRIANGLE_TIP;
  private var transform: Transform = new Transform();

  __clinit();

  static private function __clinit(): void {
    {
      TRIANGLE_TIP.addPoint__II(-1, 1);
      TRIANGLE_TIP.addPoint__II(0, 0);
      TRIANGLE_TIP.addPoint__II(-1, -1);
    }
  }
  public function PolylineDecoration() {
    this.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.black);
    this.setScale__DD(7, 3);
    return;
  }
  public override function getPoints__(): PointList {
    if (points === null) {
      points = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
      for (var i: int = 0; i < template.size__(); i++)
        points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(transform.getTransformed__Lorg_eclipse_draw2d_geometry_Point_2(template.getPoint__I(i)));
    }
    return points;
  }
  public override function setLocation__Lorg_eclipse_draw2d_geometry_Point_2(p: Point): void {
    points = null;
    bounds = null;
    location.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(p);
    transform.setTranslation__DD(p.x, p.y);
  }
  public function setTemplate__Lorg_eclipse_draw2d_geometry_PointList_2(pl: PointList): void {
    this.erase__();
    template = pl;
    points = null;
    bounds = null;
    this.repaint__();
  }
  public function setScale__DD(x: Number, y: Number): void {
    points = null;
    bounds = null;
    transform.setScale__DD(x, y);
  }
  public function setReferencePoint__Lorg_eclipse_draw2d_geometry_Point_2(ref: Point): void {
    var pt: Point = Point.SINGLETON;
    pt.setLocation__Lorg_eclipse_draw2d_geometry_Point_2(ref);
    pt.negate__().translate__Lorg_eclipse_draw2d_geometry_Point_2(location);
    this.setRotation__D(Math__.atan2__DD(pt.y, pt.x));
  }
  public function setRotation__D(angle: Number): void {
    points = null;
    bounds = null;
    transform.setRotation__D(angle);
  }
}
}
