package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.draw2d.geometry.Dimension;
import java.lang.Arguments;
dynamic public class PopUpHelper {
  private var shell: Shell;
  private var lws: LightweightSystem;
  private var tipShowing: Boolean;
  public var control: Control;
  public var shellStyle: int;
  public function PopUpHelper__Lorg_eclipse_swt_widgets_Control_2(c: Control): Object {
    return this;
  }
  public function PopUpHelper__Lorg_eclipse_swt_widgets_Control_2I(c: Control, shellStyle: int): Object {
    control = c;
    this.shellStyle = shellStyle | 262144 | 1048576;
    return this;
  }
  public function createLightweightSystem__(): LightweightSystem {
    return new LightweightSystem(new Arguments(org.eclipse.draw2d.LightweightSystem.LightweightSystem__, []));
  }
  public function createShell__(): Shell {
    return new Shell(new Arguments(org.eclipse.swt.widgets.Shell.Shell__Lorg_eclipse_swt_widgets_Shell_2I, [control.getShell__(), shellStyle]));
  }
  public function dispose__(): void {
    if (this.isShowing__())
      this.hide__();
    if (shell !== null && !shell.isDisposed__())
      shell.dispose__();
  }
  public function getShell__(): Shell {
    if (shell === null) {
      shell = this.createShell__();
      this.hookShellListeners__();
    }
    return shell;
  }
  public function getShellTrimSize__(): Dimension {
    var trim: Rectangle = shell.computeTrim__IIII(0, 0, 0, 0);
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [trim.width, trim.height]));
  }
  public function getLightweightSystem__(): LightweightSystem {
    if (lws === null) {
      lws = this.createLightweightSystem__();
      lws.setControl__Lorg_eclipse_swt_widgets_Canvas_2(this.getShell__());
    }
    return lws;
  }
  public function hide__(): void {
    if (shell !== null && !shell.isDisposed__())
      shell.setVisible__Z(false);
    tipShowing = false;
  }
  public function hookShellListeners__(): void { } // abstract
  public function isShowing__(): Boolean {
    return tipShowing;
  }
  public function setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(c: Color): void {
    this.getShell__().setBackground__Lorg_eclipse_swt_graphics_Color_2(c);
  }
  public function setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(c: Color): void {
    this.getShell__().setForeground__Lorg_eclipse_swt_graphics_Color_2(c);
  }
  public function setShellBounds__IIII(x: int, y: int, width: int, height: int): void {
    this.getShell__().setBounds__IIII(x, y, width, height);
  }
  public function show__(): void {
    this.getShell__().setVisible__Z(true);
    tipShowing = true;
  }
  public function PopUpHelper(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Control) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Control && vargs[1] is int) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        args1 = [args0[0], 16384 | 8];
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PopUpHelper__Lorg_eclipse_swt_widgets_Control_2I(args1[0], args1[1]);
        PopUpHelper__Lorg_eclipse_swt_widgets_Control_2(args0[0]);
        break;
      case 1:
        PopUpHelper__Lorg_eclipse_swt_widgets_Control_2I(args1[0], args1[1]);
        break;
    }
  }
  public static const PopUpHelper__Lorg_eclipse_swt_widgets_Control_2 : int = 0;
  public static const PopUpHelper__Lorg_eclipse_swt_widgets_Control_2I : int = 1;
}
}
