package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class PrintFigureOperation extends PrintOperation {
  public static const TILE: int = 1;
  public static const FIT_PAGE: int = 2;
  public static const FIT_WIDTH: int = 3;
  public static const FIT_HEIGHT: int = 4;
  private var printSource: IFigure;
  private var oldBGColor: Color;
  private var printMode: int = 1;
  public function PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2(p: Printer): Object {
    return this;
  }
  public function PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2Lorg_eclipse_draw2d_IFigure_2(p: Printer, srcFigure: IFigure): Object {
    this.setPrintSource__Lorg_eclipse_draw2d_IFigure_2(srcFigure);
    return this;
  }
  public override function getGraphicsOrientation__(): int {
    return this.getPrintSource__().isMirrored__() ? 67108864 : 33554432;
  }
  public function getPrintMode__(): int {
    return printMode;
  }
  public function getPrintSource__(): IFigure {
    return printSource;
  }
  public override function preparePrintSource__(): void {
    oldBGColor = this.getPrintSource__().getLocalBackgroundColor__();
    this.getPrintSource__().setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white);
  }
  public override function printPages__(): void {
    var graphics: Graphics = this.getFreshPrinterGraphics__();
    var figure: IFigure = this.getPrintSource__();
    this.setupPrinterGraphicsFor__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_IFigure_2(graphics, figure);
    var bounds: Rectangle = figure.getBounds__();
    var x: int = bounds.x;
    var y: int = bounds.y;
    var clipRect: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
    while (y < bounds.y + bounds.height) {
      while (x < bounds.x + bounds.width) {
        graphics.pushState__();
        this.getPrinter__().startPage__();
        graphics.translate__II(-x, -y);
        graphics.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(clipRect);
        clipRect.setLocation__II(x, y);
        graphics.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(clipRect);
        figure.paint__Lorg_eclipse_draw2d_Graphics_2(graphics);
        this.getPrinter__().endPage__();
        graphics.popState__();
        x += clipRect.width;
      }
      x = bounds.x;
      y += clipRect.height;
    }
    return;
  }
  public override function restorePrintSource__(): void {
    this.getPrintSource__().setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(oldBGColor);
    oldBGColor = null;
    return;
  }
  public function setPrintMode__I(mode: int): void {
    printMode = mode;
    return;
  }
  public function setPrintSource__Lorg_eclipse_draw2d_IFigure_2(printSource_1: IFigure): void {
    this.printSource = printSource_1;
    return;
  }
  public function setupPrinterGraphicsFor__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_IFigure_2(graphics: Graphics, figure: IFigure): void {
    var dpiScale: Number = Number(this.getPrinter__().getDPI__().x) / Display.getCurrent__().getDPI__().x;
    var printRegion: Rectangle = this.getPrintRegion__();
    printRegion.width /= dpiScale;
    printRegion.height /= dpiScale;
    var bounds: Rectangle = figure.getBounds__();
    var xScale: Number = Number(printRegion.width) / bounds.width;
    var yScale: Number = Number(printRegion.height) / bounds.height;
    switch (this.getPrintMode__()) {
      case 2 :
        graphics.scale__D(Math__.min__DD(xScale, yScale) * dpiScale);
        break;
      case 3 :
        graphics.scale__D(xScale * dpiScale);
        break;
      case 4 :
        graphics.scale__D(yScale * dpiScale);
        break;
      default :
        graphics.scale__D(dpiScale);
    }
    graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(figure.getForegroundColor__());
    graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(figure.getBackgroundColor__());
    graphics.setFont__Lorg_eclipse_swt_graphics_Font_2(figure.getFont__());
    return;
  }
  public function PrintFigureOperation(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 1 && vargs[0] is Printer) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is Printer && vargs[1] is IFigure) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0]];
        var superArgs: Arguments;
        superArgs = new Arguments(org.eclipse.draw2d.PrintOperation.PrintOperation__Lorg_eclipse_swt_printing_Printer_2, [args0[0]]);
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        superArgs = new Arguments(org.eclipse.draw2d.PrintOperation.PrintOperation__Lorg_eclipse_swt_printing_Printer_2, [args1[0]]);
        break;
    }
    super(superArgs);
    switch (id) {
      case 0:
        PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2(args0[0]);
        break;
      case 1:
        PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2Lorg_eclipse_draw2d_IFigure_2(args1[0], args1[1]);
        break;
    }
  }
  public static const PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2 : int = 0;
  public static const PrintFigureOperation__Lorg_eclipse_swt_printing_Printer_2Lorg_eclipse_draw2d_IFigure_2 : int = 1;
}
}
