package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.Printer;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Point;
import java.lang.Arguments;
dynamic public class PrintOperation {
  private var printerGC: GC;
  private var printMargin: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [0, 0, 0, 0]));
  private var printer: Printer;
  private var printerGraphics: PrinterGraphics;
  private var g: SWTGraphics;
  public function PrintOperation__(): Object {
    return this;
  }
  public function PrintOperation__Lorg_eclipse_swt_printing_Printer_2(p: Printer): Object {
    this.setPrinter__Lorg_eclipse_swt_printing_Printer_2(p);
    return this;
  }
  public function cleanup__(): void {
    if (g !== null) {
      printerGraphics.dispose__();
      g.dispose__();
    }
    if (printerGC !== null)
      printerGC.dispose__();
    return;
  }
  public function getFreshPrinterGraphics__(): PrinterGraphics {
    if (printerGraphics !== null) {
      printerGraphics.dispose__();
      g.dispose__();
      printerGraphics = null;
      g = null;
    }
    g = new SWTGraphics(printerGC);
    printerGraphics = new PrinterGraphics(g, printer);
    this.setupGraphicsForPage__Lorg_eclipse_draw2d_PrinterGraphics_2(printerGraphics);
    return printerGraphics;
  }
  public function getGraphicsOrientation__(): int {
    return 33554432;
  }
  public function getPrinter__(): Printer {
    return printer;
  }
  public function getPrintRegion__(): org.eclipse.draw2d.geometry.Rectangle {
    var trim: org.eclipse.swt.graphics.Rectangle = printer.computeTrim__IIII(0, 0, 0, 0);
    var printerDPI: Point = printer.getDPI__();
    var notAvailable: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [-trim.y, -trim.x, trim.height + trim.y, trim.width + trim.x]));
    var userPreferred: Insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [int((printMargin.top * printerDPI.x) / 72), int((printMargin.left * printerDPI.x) / 72), int((printMargin.bottom * printerDPI.x) / 72), int((printMargin.right * printerDPI.x) / 72)]));
    var paperBounds: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_swt_graphics_Rectangle_2, [printer.getBounds__()]));
    var printRegion: org.eclipse.draw2d.geometry.Rectangle = paperBounds.getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(notAvailable);
    printRegion.intersect__Lorg_eclipse_draw2d_geometry_Rectangle_2(paperBounds.getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(userPreferred));
    printRegion.translate__II(trim.x, trim.y);
    return printRegion;
  }
  public function preparePrintSource__(): void {
  }
  public function printPages__(): void { } // abstract
  public function restorePrintSource__(): void {
  }
  public function run__Ljava_lang_String_2(jobName: String): void {
    this.preparePrintSource__();
    if (printer.startJob__Ljava_lang_String_2(jobName)) {
      printerGC = new GC(new Arguments(org.eclipse.swt.graphics.GC.GC__Lorg_eclipse_swt_graphics_Drawable_2I, [this.getPrinter__(), this.getGraphicsOrientation__()]));
      this.printPages__();
      printer.endJob__();
    }
    this.restorePrintSource__();
    this.cleanup__();
    return;
  }
  public function setPrinter__Lorg_eclipse_swt_printing_Printer_2(printer_1: Printer): void {
    this.printer = printer_1;
    return;
  }
  public function setPrintMargin__Lorg_eclipse_draw2d_geometry_Insets_2(margin: Insets): void {
    printMargin = margin;
    return;
  }
  public function setupGraphicsForPage__Lorg_eclipse_draw2d_PrinterGraphics_2(pg: PrinterGraphics): void {
    var printRegion: org.eclipse.draw2d.geometry.Rectangle = this.getPrintRegion__();
    pg.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(printRegion);
    pg.translate__Lorg_eclipse_draw2d_geometry_Point_2(printRegion.getTopLeft__());
    return;
  }
  public function PrintOperation(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Printer) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        PrintOperation__();
        break;
      case 1:
        PrintOperation__Lorg_eclipse_swt_printing_Printer_2(args1[0]);
        break;
    }
  }
  public static const PrintOperation__ : int = 0;
  public static const PrintOperation__Lorg_eclipse_swt_printing_Printer_2 : int = 1;
}
}
