package org.eclipse.draw2d {
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class PrinterGraphics extends ScaledGraphics {
  internal var imageCache: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  internal var printer: Printer;
  public function PrinterGraphics(g: Graphics, p: Printer) {
    super(g);
    printer = p;
    return;
  }
  public override function createFont__Lorg_eclipse_swt_graphics_FontData_2(data: FontData): Font {
    return new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [printer, data]));
  }
  private function printerImage__Lorg_eclipse_swt_graphics_Image_2(image: Image): Image {
    var result: Image = Image(imageCache.get__Ljava_lang_Object_2(image));
    if (result !== null)
      return result;
    result = new Image(new Arguments(org.eclipse.swt.graphics.Image.Image__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_ImageData_2, [printer, image.getImageData__()]));
    imageCache.put__Ljava_lang_Object_2Ljava_lang_Object_2(image, result);
    return result;
  }
  public override function dispose__(): void {
    super.dispose__();
    var iter: Iterator = Iterator(imageCache.values__().iterator__());
    while (iter.hasNext__()) {
      var printerImage: Image = (Image(iter.next__()));
      printerImage.dispose__();
    }
    imageCache.clear__();
    return;
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2II(srcImage: Image, x: int, y: int): void {
    super.drawImage__Lorg_eclipse_swt_graphics_Image_2II(this.printerImage__Lorg_eclipse_swt_graphics_Image_2(srcImage), x, y);
    return;
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage: Image, sx: int, sy: int, sw: int, sh: int, tx: int, ty: int, tw: int, th: int): void {
    super.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(this.printerImage__Lorg_eclipse_swt_graphics_Image_2(srcImage), sx, sy, sw, sh, tx, ty, tw, th);
    return;
  }
  public override function zoomFontHeight__I(height: int): int {
    return int((height * zoom * Display.getCurrent__().getDPI__().y / printer.getDPI__().y + 1.0E-7));
  }
  public function zoomLineWidth__I(w: int): int {
    return int((w * zoom));
  }
}
}
