package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import java.lang.Arguments;
dynamic public class RelativeBendpoint implements Bendpoint {
  private var connection: Connection;
  private var weight: Number = 0.5;
  private var d1: Dimension;
  private var d2: Dimension;
  public function RelativeBendpoint__(): Object {
    return this;
  }
  public function RelativeBendpoint__Lorg_eclipse_draw2d_Connection_2(conn: Connection): Object {
    this.setConnection__Lorg_eclipse_draw2d_Connection_2(conn);
    return this;
  }
  public function getConnection__(): Connection {
    return connection;
  }
  public function getLocation__(): Point {
    var a1: PrecisionPoint = new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2, [this.getConnection__().getSourceAnchor__().getReferencePoint__()]));
    var a2: PrecisionPoint = new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__Lorg_eclipse_draw2d_geometry_Point_2, [this.getConnection__().getTargetAnchor__().getReferencePoint__()]));
    this.getConnection__().translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(a1);
    this.getConnection__().translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(a2);
    return new PrecisionPoint(new Arguments(org.eclipse.draw2d.geometry.PrecisionPoint.PrecisionPoint__DD, [(a1.preciseX__() + d1.preciseWidth__()) * (1.0 - weight) + weight * (a2.preciseX__() + d2.preciseWidth__()), (a1.preciseY__() + d1.preciseHeight__()) * (1.0 - weight) + weight * (a2.preciseY__() + d2.preciseHeight__())]));
  }
  public function setConnection__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    connection = conn;
  }
  public function setRelativeDimensions__Lorg_eclipse_draw2d_geometry_Dimension_2Lorg_eclipse_draw2d_geometry_Dimension_2(dim1: Dimension, dim2: Dimension): void {
    d1 = dim1;
    d2 = dim2;
  }
  public function setWeight__F(w: Number): void {
    weight = w;
  }
  public function RelativeBendpoint(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is Connection) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        RelativeBendpoint__();
        break;
      case 1:
        RelativeBendpoint__Lorg_eclipse_draw2d_Connection_2(args1[0]);
        break;
    }
  }
  public static const RelativeBendpoint__ : int = 0;
  public static const RelativeBendpoint__Lorg_eclipse_draw2d_Connection_2 : int = 1;
}
}
