package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class RelativeLocator implements Locator {
  private var relativeX: Number = 0;
  private var relativeY: Number = 0;
  private var reference: IFigure;
  public function RelativeLocator__(): Object {
    relativeX = 0.0;
    relativeY = 0.0;
    return this;
  }
  public function RelativeLocator__Lorg_eclipse_draw2d_IFigure_2I(reference: IFigure, location: int): Object {
    this.setReferenceFigure__Lorg_eclipse_draw2d_IFigure_2(reference);
    switch (location & 5) {
      case 1 :
        relativeY = 0;
        break;
      case 4 :
        relativeY = 1.0;
        break;
      default :
        relativeY = 0.5;
    }
    switch (location & 24) {
      case 8 :
        relativeX = 0;
        break;
      case 16 :
        relativeX = 1.0;
        break;
      default :
        relativeX = 0.5;
    }
    return this;
  }
  public function RelativeLocator__Lorg_eclipse_draw2d_IFigure_2DD(reference: IFigure, relativeX: Number, relativeY: Number): Object {
    this.setReferenceFigure__Lorg_eclipse_draw2d_IFigure_2(reference);
    this.relativeX = relativeX;
    this.relativeY = relativeY;
    return this;
  }
  public function getReferenceBox__(): Rectangle {
    return this.getReferenceFigure__().getBounds__();
  }
  public function getReferenceFigure__(): IFigure {
    return reference;
  }
  public function relocate__Lorg_eclipse_draw2d_IFigure_2(target: IFigure): void {
    var reference_1: IFigure = this.getReferenceFigure__();
    var targetBounds: Rectangle = new PrecisionRectangle(new Arguments(org.eclipse.draw2d.geometry.PrecisionRectangle.PrecisionRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [this.getReferenceBox__().getResized__II(-1, -1)]));
    reference_1.translateToAbsolute__Lorg_eclipse_draw2d_geometry_Translatable_2(targetBounds);
    target.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(targetBounds);
    targetBounds.resize__II(1, 1);
    var targetSize: Dimension = target.getPreferredSize__();
    targetBounds.x += int((targetBounds.width * relativeX - (int((targetSize.width + 1) / 2))));
    targetBounds.y += int((targetBounds.height * relativeY - (int((targetSize.height + 1) / 2))));
    targetBounds.setSize__Lorg_eclipse_draw2d_geometry_Dimension_2(targetSize);
    target.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(targetBounds);
  }
  public function setReferenceFigure__Lorg_eclipse_draw2d_IFigure_2(reference_1: IFigure): void {
    this.reference = reference_1;
  }
  public function RelativeLocator(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 2 && vargs[0] is IFigure && vargs[1] is int) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 3 && vargs[0] is IFigure && vargs[1] is Number && vargs[2] is Number) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0], args[1]];
        break;
      case 2:
        var args2: Array = [args[0], args[1], args[2]];
        break;
    }
    super();
    switch (id) {
      case 0:
        RelativeLocator__();
        break;
      case 1:
        RelativeLocator__Lorg_eclipse_draw2d_IFigure_2I(args1[0], args1[1]);
        break;
      case 2:
        RelativeLocator__Lorg_eclipse_draw2d_IFigure_2DD(args2[0], args2[1], args2[2]);
        break;
    }
  }
  public static const RelativeLocator__ : int = 0;
  public static const RelativeLocator__Lorg_eclipse_draw2d_IFigure_2I : int = 1;
  public static const RelativeLocator__Lorg_eclipse_draw2d_IFigure_2DD : int = 2;
}
}
