package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class RoutingAnimator extends Animator implements RoutingListener {
  public static var INSTANCE: RoutingAnimator = new RoutingAnimator();
  public function RoutingAnimator() {
    return;
  }
  public override function playbackStarting__Lorg_eclipse_draw2d_IFigure_2(connection: IFigure): void {
    this.reconcileStates__Lorg_eclipse_draw2d_Connection_2(Connection(connection));
    return;
  }
  public override function getCurrentState__Lorg_eclipse_draw2d_IFigure_2(connection: IFigure): Object {
    return (Connection(connection)).getPoints__().getCopy__();
  }
  public static function getDefault__(): RoutingAnimator {
    return INSTANCE;
  }
  public function invalidate__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if (Animation.isInitialRecording__())
      Animation.hookAnimator__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(conn, this);
  }
  public override function playback__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Boolean {
    var conn: Connection = Connection(figure);
    var list1: PointList = PointList(Animation.getInitialState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(this, conn));
    var list2: PointList = PointList(Animation.getFinalState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(this, conn));
    if (list1 === null) {
      conn.setVisible__Z(false);
      return true;
    }
    var progress: Number = Animation.getProgress__();
    if (list1.size__() == list2.size__()) {
      var pt1: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
      var pt2: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
      var points: PointList = conn.getPoints__();
      points.removeAllPoints__();
      for (var i: int = 0; i < list1.size__(); i++) {
        list1.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt2, i);
        list2.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt1, i);
        pt1.x = Math__.round__F(pt1.x * progress + (1 - progress) * pt2.x);
        pt1.y = Math__.round__F(pt1.y * progress + (1 - progress) * pt2.y);
        points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(pt1);
      }
      conn.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
    }
    return true;
  }
  public function postRoute__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
    if (Animation.isFinalRecording__())
      Animation.hookNeedsCapture__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(connection, this);
  }
  private function reconcileStates__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    var points1: PointList = PointList(Animation.getInitialState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(this, conn));
    var points2: PointList = PointList(Animation.getFinalState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(this, conn));
    if (points1 !== null && points1.size__() != points2.size__()) {
      var p: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
      var q: Point = new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__, []));
      var size1: int = points1.size__() - 1;
      var size2: int = points2.size__() - 1;
      var i1: int = size1;
      var i2: int = size2;
      var current1: Number = 1.0;
      var current2: Number = 1.0;
      var prev1: Number = 1.0;
      var prev2: Number = 1.0;
      while (i1 > 0 || i2 > 0) {
        if (Math__.abs__D(current1 - current2) < 0.1 && i1 > 0 && i2 > 0) {
          prev1 = current1;
          prev2 = current2;
          i1--;
          i2--;
          current1 = Number(i1) / size1;
          current2 = Number(i2) / size2;
        } else if (current1 < current2) {
          points1.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p, i1);
          points1.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(q, i1 + 1);
          p.x = int((((q.x * (current2 - current1) + p.x * (prev1 - current2)) / (prev1 - current1))));
          p.y = int((((q.y * (current2 - current1) + p.y * (prev1 - current2)) / (prev1 - current1))));
          points1.insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p, i1 + 1);
          prev1 = prev2 = current2;
          i2--;
          current2 = Number(i2) / size2;
        } else {
          points2.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p, i2);
          points2.getPoint__Lorg_eclipse_draw2d_geometry_Point_2I(q, i2 + 1);
          p.x = int((((q.x * (current1 - current2) + p.x * (prev2 - current1)) / (prev2 - current2))));
          p.y = int((((q.y * (current1 - current2) + p.y * (prev2 - current1)) / (prev2 - current2))));
          points2.insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(p, i2 + 1);
          prev2 = prev1 = current1;
          i1--;
          current1 = Number(i1) / size1;
        }
      }
    }
    return;
  }
  public function remove__Lorg_eclipse_draw2d_Connection_2(connection: Connection): void {
  }
  public function route__Lorg_eclipse_draw2d_Connection_2(conn: Connection): Boolean {
    return Animation.isAnimating__() && Animation.hookPlayback__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(conn, this);
  }
  public function setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(connection: Connection, constraint: Object): void {
  }
}
}
