package org.eclipse.draw2d {
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import java.lang.RuntimeException;
import org.eclipse.swt.events.DisposeListener;
import java.lang.Arguments;
dynamic public class SWTEventDispatcher extends EventDispatcher {
  public static var ANY_BUTTON: int = SWT.BUTTON_MASK;
  private var figureTraverse: Boolean = true;
  private var captured: Boolean;
  private var root: IFigure;
  private var mouseTarget: IFigure;
  private var cursorTarget: IFigure;
  private var focusOwner: IFigure;
  private var hoverSource: IFigure;
  private var currentEvent: org.eclipse.draw2d.MouseEvent;
  private var cursor: Cursor;
  public var control: Control;
  private var toolTipHelper: ToolTipHelper;
  private var focusManager: FocusTraverseManager = new FocusTraverseManager();
  public override function dispatchFocusGained__Lorg_eclipse_swt_events_FocusEvent_2(e: org.eclipse.swt.events.FocusEvent): void {
    var currentFocusOwner: IFigure = this.getFocusTraverseManager__().getCurrentFocusOwner__();
    if (currentFocusOwner === null)
      currentFocusOwner = this.getFocusTraverseManager__().getNextFocusableFigure__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(root, focusOwner);
    this.setFocus__Lorg_eclipse_draw2d_IFigure_2(currentFocusOwner);
    return;
  }
  public override function dispatchFocusLost__Lorg_eclipse_swt_events_FocusEvent_2(e: org.eclipse.swt.events.FocusEvent): void {
    this.setFocus__Lorg_eclipse_draw2d_IFigure_2(null);
    return;
  }
  public override function dispatchKeyPressed__Lorg_eclipse_swt_events_KeyEvent_2(e: org.eclipse.swt.events.KeyEvent): void {
    if (focusOwner !== null) {
      var event: org.eclipse.draw2d.KeyEvent = new org.eclipse.draw2d.KeyEvent(this, focusOwner, e);
      focusOwner.handleKeyPressed__Lorg_eclipse_draw2d_KeyEvent_2(event);
    }
    return;
  }
  public override function dispatchKeyReleased__Lorg_eclipse_swt_events_KeyEvent_2(e: org.eclipse.swt.events.KeyEvent): void {
    if (focusOwner !== null) {
      var event: org.eclipse.draw2d.KeyEvent = new org.eclipse.draw2d.KeyEvent(this, focusOwner, e);
      focusOwner.handleKeyReleased__Lorg_eclipse_draw2d_KeyEvent_2(event);
    }
    return;
  }
  public override function dispatchKeyTraversed__Lorg_eclipse_swt_events_TraverseEvent_2(e: TraverseEvent): void {
    if (!figureTraverse)
      return;
    var nextFigure: IFigure = null;
    if (e.detail == 16)
      nextFigure = this.getFocusTraverseManager__().getNextFocusableFigure__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(root, focusOwner);
    else if (e.detail == 8)
      nextFigure = this.getFocusTraverseManager__().getPreviousFocusableFigure__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2(root, focusOwner);
    if (nextFigure !== null) {
      e.doit = false;
      this.setFocus__Lorg_eclipse_draw2d_IFigure_2(nextFigure);
    }
    return;
  }
  public override function dispatchMouseHover__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    if (mouseTarget !== null)
      mouseTarget.handleMouseHover__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
    if (hoverSource !== null) {
      toolTipHelper = this.getToolTipHelper__();
      var tip: IFigure = hoverSource.getToolTip__();
      var control_1: Control = Control(me.getSource__());
      var absolute: Point;
      absolute = control_1.toDisplay__Lorg_eclipse_swt_graphics_Point_2(new Point(me.x, me.y));
      toolTipHelper.displayToolTipNear__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(hoverSource, tip, absolute.x, absolute.y);
    }
    return;
  }
  public override function dispatchMouseDoubleClicked__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    if (mouseTarget !== null)
      mouseTarget.handleMouseDoubleClicked__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
    return;
  }
  public override function dispatchMouseEntered__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    return;
  }
  public override function dispatchMouseExited__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.setHoverSource__Lorg_eclipse_draw2d_Figure_2Lorg_eclipse_swt_events_MouseEvent_2(null, me);
    if (mouseTarget !== null) {
      currentEvent = new org.eclipse.draw2d.MouseEvent(me.x, me.y, this, mouseTarget, me.button, me.stateMask);
      mouseTarget.handleMouseExited__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
      this.releaseCapture__();
      mouseTarget = null;
    }
    return;
  }
  public override function dispatchMousePressed__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    if (mouseTarget !== null) {
      mouseTarget.handleMousePressed__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
      if (currentEvent.isConsumed__())
        this.setCapture__Lorg_eclipse_draw2d_IFigure_2(mouseTarget);
    }
    return;
  }
  public override function dispatchMouseMoved__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    if (mouseTarget !== null) {
      if ((me.stateMask & SWT.BUTTON_MASK) != 0)
        mouseTarget.handleMouseDragged__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
      else
        mouseTarget.handleMouseMoved__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
    }
    return;
  }
  public override function dispatchMouseReleased__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    if (mouseTarget !== null) {
      mouseTarget.handleMouseReleased__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
    }
    this.releaseCapture__();
    this.receive__Lorg_eclipse_swt_events_MouseEvent_2(me);
    return;
  }
  public override function getAccessibilityDispatcher__(): EventDispatcher$AccessibilityDispatcher {
    return null;
  }
  public function getCurrentEvent__(): org.eclipse.draw2d.MouseEvent {
    return currentEvent;
  }
  private function getCurrentToolTip__(): IFigure {
    if (hoverSource !== null)
      return hoverSource.getToolTip__();
    else
      return null;
  }
  public function getCursorTarget__(): IFigure {
    return cursorTarget;
  }
  public function getToolTipHelper__(): ToolTipHelper {
    if (toolTipHelper === null)
      toolTipHelper = new ToolTipHelper(control);
    return toolTipHelper;
  }
  public function getFocusTraverseManager__(): FocusTraverseManager {
    if (focusManager === null) {
      focusManager = new FocusTraverseManager();
    }
    return focusManager;
  }
  public override function getFocusOwner__(): IFigure {
    return focusOwner;
  }
  public function getMouseTarget__(): IFigure {
    return mouseTarget;
  }
  public function getRoot__(): IFigure {
    return root;
  }
  public override function isCaptured__(): Boolean {
    return captured;
  }
  private function receive__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    currentEvent = null;
    this.updateFigureUnderCursor__Lorg_eclipse_swt_events_MouseEvent_2(me);
    var state: int = me.stateMask;
    if (captured) {
      if (mouseTarget !== null)
        currentEvent = new org.eclipse.draw2d.MouseEvent(me.x, me.y, this, mouseTarget, me.button, state);
    } else {
      var f: IFigure = root.findMouseEventTargetAt__II(me.x, me.y);
      if (f === mouseTarget) {
        if (mouseTarget !== null)
          currentEvent = new org.eclipse.draw2d.MouseEvent(me.x, me.y, this, mouseTarget, me.button, state);
        return;
      }
      if (mouseTarget !== null) {
        currentEvent = new org.eclipse.draw2d.MouseEvent(me.x, me.y, this, mouseTarget, me.button, state);
        mouseTarget.handleMouseExited__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
      }
      this.setMouseTarget__Lorg_eclipse_draw2d_IFigure_2(f);
      if (mouseTarget !== null) {
        currentEvent = new org.eclipse.draw2d.MouseEvent(me.x, me.y, this, mouseTarget, me.button, state);
        mouseTarget.handleMouseEntered__Lorg_eclipse_draw2d_MouseEvent_2(currentEvent);
      }
    }
    return;
  }
  public override function releaseCapture__(): void {
    captured = false;
    return;
  }
  public override function requestFocus__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): void {
    this.setFocus__Lorg_eclipse_draw2d_IFigure_2(fig);
    return;
  }
  public override function requestRemoveFocus__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): void {
    if (this.getFocusOwner__() === fig)
      this.setFocus__Lorg_eclipse_draw2d_IFigure_2(null);
    if (mouseTarget === fig)
      mouseTarget = null;
    if (cursorTarget === fig)
      cursorTarget = null;
    if (hoverSource === fig)
      hoverSource = null;
    this.getFocusTraverseManager__().setCurrentFocusOwner__Lorg_eclipse_draw2d_IFigure_2(null);
    return;
  }
  public override function setCapture__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    captured = true;
    mouseTarget = figure;
    return;
  }
  public override function setControl__Lorg_eclipse_swt_widgets_Control_2(c: Control): void {
    if (c === control)
      return;
    if (control !== null && !control.isDisposed__())
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_String_2, ["Can not set control again once it has been set"]));
    if (c !== null)
      c.addDisposeListener__Lorg_eclipse_swt_events_DisposeListener_2(new org.eclipse.draw2d.SWTEventDispatcher$1(this));
    control = c;
  }
  public function setCursor__Lorg_eclipse_swt_graphics_Cursor_2(c: Cursor): void {
    if (c === null && cursor === null) {
      return;
    } else if ((c !== cursor) || (!c.equals__Ljava_lang_Object_2(cursor))) {
      cursor = c;
      if (control !== null && !control.isDisposed__())
        control.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(c);
    }
    return;
  }
  public function setEnableKeyTraversal__Z(traverse: Boolean): void {
    figureTraverse = traverse;
    return;
  }
  public function setFigureUnderCursor__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): void {
    if (cursorTarget === f)
      return;
    cursorTarget = f;
    this.updateCursor__();
  }
  public function setFocus__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): void {
    if (fig === focusOwner)
      return;
    var fe: org.eclipse.draw2d.FocusEvent = new org.eclipse.draw2d.FocusEvent(focusOwner, fig);
    var oldOwner: IFigure = focusOwner;
    focusOwner = fig;
    if (oldOwner !== null)
      oldOwner.handleFocusLost__Lorg_eclipse_draw2d_FocusEvent_2(fe);
    if (fig !== null)
      this.getFocusTraverseManager__().setCurrentFocusOwner__Lorg_eclipse_draw2d_IFigure_2(fig);
    if (focusOwner !== null)
      focusOwner.handleFocusGained__Lorg_eclipse_draw2d_FocusEvent_2(fe);
  }
  public function setHoverSource__Lorg_eclipse_draw2d_Figure_2Lorg_eclipse_swt_events_MouseEvent_2(figure: Figure, me: org.eclipse.swt.events.MouseEvent): void {
    hoverSource = figure;
    if (figure !== null) {
      var control_1: Control = Control(me.getSource__());
      var absolute: Point;
      absolute = control_1.toDisplay__Lorg_eclipse_swt_graphics_Point_2(new Point(me.x, me.y));
      toolTipHelper = this.getToolTipHelper__();
      toolTipHelper.updateToolTip__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(hoverSource, this.getCurrentToolTip__(), absolute.x, absolute.y);
    } else if (toolTipHelper !== null) {
      toolTipHelper.updateToolTip__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_IFigure_2II(hoverSource, this.getCurrentToolTip__(), me.x, me.y);
    }
    return;
  }
  public function setMouseTarget__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    mouseTarget = figure;
    return;
  }
  public override function setRoot__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    root = figure;
    return;
  }
  public override function updateCursor__(): void {
    var newCursor: Cursor = null;
    if (cursorTarget !== null)
      newCursor = cursorTarget.getCursor__();
    this.setCursor__Lorg_eclipse_swt_graphics_Cursor_2(newCursor);
    return;
  }
  public function updateFigureUnderCursor__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    if (!captured) {
      var f: IFigure = root.findFigureAt__II(me.x, me.y);
      this.setFigureUnderCursor__Lorg_eclipse_draw2d_IFigure_2(f);
      if (cursorTarget !== hoverSource)
        this.updateHoverSource__Lorg_eclipse_swt_events_MouseEvent_2(me);
    }
    return;
  }
  public function updateHoverSource__Lorg_eclipse_swt_events_MouseEvent_2(me: org.eclipse.swt.events.MouseEvent): void {
    if (cursorTarget !== null) {
      var sourceFound: Boolean = false;
      var source: Figure = Figure(cursorTarget);
      while (!sourceFound && source.getParent__() !== null) {
        if (source.getToolTip__() !== null)
          sourceFound = true;
        else
          source = Figure(source.getParent__());
      }
      this.setHoverSource__Lorg_eclipse_draw2d_Figure_2Lorg_eclipse_swt_events_MouseEvent_2(source, me);
    } else {
      this.setHoverSource__Lorg_eclipse_draw2d_Figure_2Lorg_eclipse_swt_events_MouseEvent_2(null, me);
    }
    return;
  }
  public static function access$0(arg0: SWTEventDispatcher): ToolTipHelper {
    return arg0.toolTipHelper;
  }
}
}
