package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Cloneable;
import java.lang.CloneNotSupportedException;
import java.util.List;
import java.util.ArrayList;
import java.lang.IllegalStateException;
import java.lang.RuntimeException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SWTGraphics$RectangleClipping implements SWTGraphics$Clipping {
  public var top: Number = 0;
  public var left: Number = 0;
  public var bottom: Number = 0;
  public var right: Number = 0;
  public function SWTGraphics$RectangleClipping__FFFF(left: Number, top: Number, right: Number, bottom: Number): Object {
    this.left = left;
    this.right = right;
    this.bottom = bottom;
    this.top = top;
    return this;
  }
  public function SWTGraphics$RectangleClipping__Lorg_eclipse_swt_graphics_Rectangle_2(rect: org.eclipse.swt.graphics.Rectangle): Object {
    left = rect.x;
    top = rect.y;
    right = rect.x + rect.width;
    bottom = rect.y + rect.height;
    return this;
  }
  public function SWTGraphics$RectangleClipping__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): Object {
    left = rect.x;
    top = rect.y;
    right = rect.right__();
    bottom = rect.bottom__();
    return this;
  }
  public function getBoundingBox__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    rect.x = int(left);
    rect.y = int(top);
    rect.width = int(Math__.ceil__D(right)) - rect.x;
    rect.height = int(Math__.ceil__D(bottom)) - rect.y;
    return rect;
  }
  public function getCopy__(): SWTGraphics$Clipping {
    return new SWTGraphics$RectangleClipping(new Arguments(org.eclipse.draw2d.SWTGraphics$RectangleClipping.SWTGraphics$RectangleClipping__FFFF, [left, top, right, bottom]));
  }
  public function intersect__IIII(left_1: int, top_1: int, right_1: int, bottom_1: int): void {
    this.left = Math__.max__FF(this.left, left_1);
    this.right = Math__.min__FF(this.right, right_1);
    this.top = Math__.max__FF(this.top, top_1);
    this.bottom = Math__.min__FF(this.bottom, bottom_1);
    if (right_1 < left_1 || bottom_1 < top_1) {
      this.right = left_1 - 1;
      this.bottom = top_1 - 1;
    }
    return;
  }
  public function scale__FF(horz: Number, vert: Number): void {
    left /= horz;
    right /= horz;
    top /= vert;
    bottom /= vert;
    return;
  }
  public function setOn__Lorg_eclipse_swt_graphics_GC_2II(gc: GC, translateX: int, translateY: int): void {
    var xInt: int = int(Math__.floor__D(left));
    var yInt: int = int(Math__.floor__D(top));
    gc.setClipping__IIII(xInt + translateX, yInt + translateY, int(Math__.ceil__D(right)) - xInt, int(Math__.ceil__D(bottom)) - yInt);
    return;
  }
  public function translate__FF(dx: Number, dy: Number): void {
    left += dx;
    right += dx;
    top += dy;
    bottom += dy;
    return;
  }
  public function SWTGraphics$RectangleClipping(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 4 && vargs[0] is Number && vargs[1] is Number && vargs[2] is Number && vargs[3] is Number) {
        args = vargs;
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.swt.graphics.Rectangle) {
        args = vargs;
        id = 1;
      } else if (vargs.length == 1 && vargs[0] is org.eclipse.draw2d.geometry.Rectangle) {
        args = vargs;
        id = 2;
      }
    }
    switch (id) {
      case 0:
        var args0: Array = [args[0], args[1], args[2], args[3]];
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
      case 2:
        var args2: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        SWTGraphics$RectangleClipping__FFFF(args0[0], args0[1], args0[2], args0[3]);
        break;
      case 1:
        SWTGraphics$RectangleClipping__Lorg_eclipse_swt_graphics_Rectangle_2(args1[0]);
        break;
      case 2:
        SWTGraphics$RectangleClipping__Lorg_eclipse_draw2d_geometry_Rectangle_2(args2[0]);
        break;
    }
  }
  public static const SWTGraphics$RectangleClipping__FFFF : int = 0;
  public static const SWTGraphics$RectangleClipping__Lorg_eclipse_swt_graphics_Rectangle_2 : int = 1;
  public static const SWTGraphics$RectangleClipping__Lorg_eclipse_draw2d_geometry_Rectangle_2 : int = 2;
}
}
