package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Cloneable;
import java.lang.CloneNotSupportedException;
import java.util.List;
import java.util.ArrayList;
import java.lang.IllegalStateException;
import java.lang.RuntimeException;
import java.lang.System;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SWTGraphics extends Graphics {
  public static var AA_MASK: int;
  public static var AA_SHIFT: int;
  public static const AA_WHOLE_NUMBER: int = 1;
  public static var ADVANCED_GRAPHICS_MASK: int;
  public static var ADVANCED_HINTS_DEFAULTS: int;
  public static var ADVANCED_HINTS_MASK: int;
  public static var ADVANCED_SHIFT: int;
  public static var FILL_RULE_MASK: int;
  public static var FILL_RULE_SHIFT: int;
  public static const FILL_RULE_WHOLE_NUMBER: int = -1;
  public static var INTERPOLATION_MASK: int;
  public static var INTERPOLATION_SHIFT: int;
  public static const INTERPOLATION_WHOLE_NUMBER: int = 1;
  public static var TEXT_AA_MASK: int;
  public static var TEXT_AA_SHIFT: int;
  public static var XOR_MASK: int;
  public static var XOR_SHIFT: int;
  private var appliedState: SWTGraphics$LazyState = new SWTGraphics$LazyState();
  private var currentState: SWTGraphics$State = new SWTGraphics$State();
  private var elementsNeedUpdate: Boolean;
  private var gc: GC;
  private var sharedClipping: Boolean;
  private var stack: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  private var stackPointer: int = 0;
  internal var transform: Transform;
  private var translateX: int = 0;
  private var translateY: int = 0;

  __clinit();

  static private function __clinit(): void {
    {
      XOR_SHIFT = 3;
      AA_SHIFT = 8;
      TEXT_AA_SHIFT = 10;
      INTERPOLATION_SHIFT = 12;
      FILL_RULE_SHIFT = 14;
      ADVANCED_SHIFT = 15;
      AA_MASK = 3 << AA_SHIFT;
      FILL_RULE_MASK = 1 << FILL_RULE_SHIFT;
      INTERPOLATION_MASK = 3 << INTERPOLATION_SHIFT;
      TEXT_AA_MASK = 3 << TEXT_AA_SHIFT;
      XOR_MASK = 1 << XOR_SHIFT;
      ADVANCED_GRAPHICS_MASK = 1 << ADVANCED_SHIFT;
      ADVANCED_HINTS_MASK = TEXT_AA_MASK | AA_MASK | INTERPOLATION_MASK;
      ADVANCED_HINTS_DEFAULTS = ((-1 + 1) << TEXT_AA_SHIFT) | ((-1 + 1) << AA_SHIFT) | ((-1 + 1) << INTERPOLATION_SHIFT);
    }
  }
  public function SWTGraphics(gc: GC) {
    this.gc = gc;
    this.init__();
    return;
  }
  public function checkFill__(): void {
    if (!currentState.bgColor.equals__Ljava_lang_Object_2(appliedState.bgColor) && currentState.bgPattern === null) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(appliedState.bgColor = currentState.bgColor);
    }
    this.checkGC__();
    return;
  }
  public function checkGC__(): void {
    if (appliedState.relativeClip !== currentState.relativeClip) {
      appliedState.relativeClip = currentState.relativeClip;
      currentState.relativeClip.setOn__Lorg_eclipse_swt_graphics_GC_2II(gc, translateX, translateY);
    }
    if (appliedState.graphicHints != currentState.graphicHints) {
      SWTGraphics.reconcileHints__Lorg_eclipse_swt_graphics_GC_2II(gc, appliedState.graphicHints, currentState.graphicHints);
      appliedState.graphicHints = currentState.graphicHints;
    }
    return;
  }
  public function checkPaint__(): void {
    this.checkGC__();
    if (!currentState.fgColor.equals__Ljava_lang_Object_2(appliedState.fgColor) && currentState.fgPattern === null) {
      gc.setForeground__Lorg_eclipse_swt_graphics_Color_2(appliedState.fgColor = currentState.fgColor);
    }
    var lineAttributes: LineAttributes = currentState.lineAttributes;
    if (!Object(appliedState.lineAttributes).equals__Ljava_lang_Object_2(lineAttributes)) {
      if (this.getAdvanced__()) {
        gc.setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes);
      } else {
        gc.setLineWidth__I(int(lineAttributes.width));
        gc.setLineCap__I(lineAttributes.cap);
        gc.setLineJoin__I(lineAttributes.join);
        gc.setLineStyle__I(lineAttributes.style);
        if (lineAttributes.dash !== null) {
          gc.setLineDash___3I(SWTGraphics.convertFloatArrayToInt___3F(lineAttributes.dash));
        }
      }
      appliedState.lineAttributes = SWTGraphics.clone__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes);
    }
    if (!currentState.bgColor.equals__Ljava_lang_Object_2(appliedState.bgColor) && currentState.bgPattern === null) {
      gc.setBackground__Lorg_eclipse_swt_graphics_Color_2(appliedState.bgColor = currentState.bgColor);
    }
    return;
  }
  private function checkSharedClipping__(): void {
    if (sharedClipping) {
      sharedClipping = false;
      var previouslyApplied: Boolean = (appliedState === currentState.relativeClip);
      currentState.relativeClip = currentState.relativeClip.getCopy__();
      if (previouslyApplied) {
        appliedState.relativeClip = currentState.relativeClip;
      }
    }
    return;
  }
  public function checkText__(): void {
    this.checkPaint__();
    if (!appliedState.font.equals__Ljava_lang_Object_2(currentState.font)) {
      gc.setFont__Lorg_eclipse_swt_graphics_Font_2(appliedState.font = currentState.font);
    }
    return;
  }
  public override function clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): void {
    if (currentState.relativeClip === null) {
      throw new IllegalStateException(new Arguments(java.lang.IllegalStateException.IllegalStateException__Ljava_lang_String_2, ["The current clipping area does not support intersection."]));
    }
    this.checkSharedClipping__();
    currentState.relativeClip.intersect__IIII(rect.x, rect.y, rect.right__(), rect.bottom__());
    appliedState.relativeClip = null;
    return;
  }
  public override function dispose__(): void {
    while (stackPointer > 0) {
      this.popState__();
    }
    if (transform !== null) {
      transform.dispose__();
    }
    return;
  }
  public override function drawArc__IIIIII(x: int, y: int, width: int, height: int, offset: int, length: int): void {
    this.checkPaint__();
    gc.drawArc__IIIIII(x + translateX, y + translateY, width, height, offset, length);
    return;
  }
  public override function drawFocus__IIII(x: int, y: int, w: int, h: int): void {
    this.checkPaint__();
    gc.drawFocus__IIII(x + translateX, y + translateY, w + 1, h + 1);
    return;
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2II(srcImage: Image, x: int, y: int): void {
    this.checkGC__();
    gc.drawImage__Lorg_eclipse_swt_graphics_Image_2II(srcImage, x + translateX, y + translateY);
    return;
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage: Image, x1: int, y1: int, w1: int, h1: int, x2: int, y2: int, w2: int, h2: int): void {
    this.checkGC__();
    gc.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage, x1, y1, w1, h1, x2 + translateX, y2 + translateY, w2, h2);
    return;
  }
  public override function drawLine__IIII(x1: int, y1: int, x2: int, y2: int): void {
    this.checkPaint__();
    gc.drawLine__IIII(x1 + translateX, y1 + translateY, x2 + translateX, y2 + translateY);
    return;
  }
  public override function drawOval__IIII(x: int, y: int, width: int, height: int): void {
    this.checkPaint__();
    gc.drawOval__IIII(x + translateX, y + translateY, width, height);
    return;
  }
  public override function drawPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    this.checkPaint__();
    this.initTransform__Z(false);
    gc.drawPath__Lorg_eclipse_swt_graphics_Path_2(path);
    return;
  }
  public override function drawPoint__II(x: int, y: int): void {
    this.checkPaint__();
    gc.drawPoint__II(x + translateX, y + translateY);
    return;
  }
  public override function drawPolygon___3I(points: JavaArray): void {
    this.checkPaint__();
    try {
      this.translatePointArray___3III(points, translateX, translateY);
      gc.drawPolygon___3I(points);
    } finally {
      this.translatePointArray___3III(points, -translateX, -translateY);
    }
    return;
  }
  public override function drawPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    this.drawPolygon___3I(points.toIntArray__());
    return;
  }
  public override function drawPolyline___3I(points: JavaArray): void {
    this.checkPaint__();
    try {
      this.translatePointArray___3III(points, translateX, translateY);
      gc.drawPolyline___3I(points);
    } finally {
      this.translatePointArray___3III(points, -translateX, -translateY);
    }
    return;
  }
  public override function drawPolyline__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    this.drawPolyline___3I(points.toIntArray__());
    return;
  }
  public override function drawRectangle__IIII(x: int, y: int, width: int, height: int): void {
    this.checkPaint__();
    gc.drawRectangle__IIII(x + translateX, y + translateY, width, height);
    return;
  }
  public override function drawRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(r: org.eclipse.draw2d.geometry.Rectangle, arcWidth: int, arcHeight: int): void {
    this.checkPaint__();
    gc.drawRoundRectangle__IIIIII(r.x + translateX, r.y + translateY, r.width, r.height, arcWidth, arcHeight);
    return;
  }
  public override function drawString__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    this.checkText__();
    gc.drawString__Ljava_lang_String_2IIZ(s, x + translateX, y + translateY, true);
    return;
  }
  public override function drawText__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    this.checkText__();
    gc.drawText__Ljava_lang_String_2IIZ(s, x + translateX, y + translateY, true);
    return;
  }
  public override function drawTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(layout: TextLayout, x: int, y: int, selectionStart: int, selectionEnd: int, selectionForeground: Color, selectionBackground: Color): void {
    this.checkText__();
    layout.draw__Lorg_eclipse_swt_graphics_GC_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(gc, x + translateX, y + translateY, selectionStart, selectionEnd, selectionForeground, selectionBackground);
    return;
  }
  public override function fillArc__IIIIII(x: int, y: int, width: int, height: int, offset: int, length: int): void {
    this.checkFill__();
    gc.fillArc__IIIIII(x + translateX, y + translateY, width, height, offset, length);
    return;
  }
  public override function fillGradient__IIIIZ(x: int, y: int, w: int, h: int, vertical: Boolean): void {
    this.checkPaint__();
    gc.fillGradientRectangle__IIIIZ(x + translateX, y + translateY, w, h, vertical);
    return;
  }
  public override function fillOval__IIII(x: int, y: int, width: int, height: int): void {
    this.checkFill__();
    gc.fillOval__IIII(x + translateX, y + translateY, width, height);
    return;
  }
  public override function fillPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    this.checkFill__();
    this.initTransform__Z(false);
    gc.fillPath__Lorg_eclipse_swt_graphics_Path_2(path);
    return;
  }
  public override function fillPolygon___3I(points: JavaArray): void {
    this.checkFill__();
    try {
      this.translatePointArray___3III(points, translateX, translateY);
      gc.fillPolygon___3I(points);
    } finally {
      this.translatePointArray___3III(points, -translateX, -translateY);
    }
    return;
  }
  public override function fillPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    this.fillPolygon___3I(points.toIntArray__());
    return;
  }
  public override function fillRectangle__IIII(x: int, y: int, width: int, height: int): void {
    this.checkFill__();
    gc.fillRectangle__IIII(x + translateX, y + translateY, width, height);
    return;
  }
  public override function fillRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(r: org.eclipse.draw2d.geometry.Rectangle, arcWidth: int, arcHeight: int): void {
    this.checkFill__();
    gc.fillRoundRectangle__IIIIII(r.x + translateX, r.y + translateY, r.width, r.height, arcWidth, arcHeight);
    return;
  }
  public override function fillString__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    this.checkText__();
    gc.drawString__Ljava_lang_String_2IIZ(s, x + translateX, y + translateY, false);
    return;
  }
  public override function fillText__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    this.checkText__();
    gc.drawText__Ljava_lang_String_2IIZ(s, x + translateX, y + translateY, false);
    return;
  }
  public override function getAlpha__(): int {
    return currentState.alpha;
  }
  public override function getAntialias__(): int {
    return ((currentState.graphicHints & AA_MASK) >> AA_SHIFT) - 1;
  }
  public override function getAdvanced__(): Boolean {
    return (currentState.graphicHints & ADVANCED_GRAPHICS_MASK) != 0;
  }
  public override function getBackgroundColor__(): Color {
    return currentState.bgColor;
  }
  public override function getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    if (currentState.relativeClip !== null) {
      currentState.relativeClip.getBoundingBox__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
      return rect;
    } else {
      throw new IllegalStateException(new Arguments(java.lang.IllegalStateException.IllegalStateException__Ljava_lang_String_2, ["Clipping can no longer be queried due to transformations"]));
    }
    return null;
  }
  public override function getFillRule__(): int {
    return ((currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1;
  }
  public override function getFont__(): Font {
    return currentState.font;
  }
  public override function getFontMetrics__(): FontMetrics {
    this.checkText__();
    return gc.getFontMetrics__();
  }
  public override function getForegroundColor__(): Color {
    return currentState.fgColor;
  }
  public override function getInterpolation__(): int {
    return ((currentState.graphicHints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1;
  }
  public function getLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes: LineAttributes): void {
    SWTGraphics.copyLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes, currentState.lineAttributes);
  }
  public override function getLineCap__(): int {
    return currentState.lineAttributes.cap;
  }
  public override function getLineJoin__(): int {
    return currentState.lineAttributes.join;
  }
  public override function getLineStyle__(): int {
    return currentState.lineAttributes.style;
  }
  public override function getLineWidth__(): int {
    return int(currentState.lineAttributes.width);
  }
  public override function getLineWidthFloat__(): Number {
    return currentState.lineAttributes.width;
  }
  public override function getLineMiterLimit__(): Number {
    return currentState.lineAttributes.miterLimit;
  }
  public function getLineDash__(): JavaArray {
    return JavaArray(Object(currentState.lineAttributes.dash).clone__());
  }
  public function getLineDashOffset__(): Number {
    return currentState.lineAttributes.dashOffset;
  }
  public override function getTextAntialias__(): int {
    return ((currentState.graphicHints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1;
  }
  public override function getXORMode__(): Boolean {
    return (currentState.graphicHints & XOR_MASK) != 0;
  }
  public function init__(): void {
    currentState.bgColor = appliedState.bgColor = gc.getBackground__();
    currentState.fgColor = appliedState.fgColor = gc.getForeground__();
    currentState.font = appliedState.font = gc.getFont__();
    currentState.lineAttributes = gc.getLineAttributes__();
    appliedState.lineAttributes = SWTGraphics.clone__Lorg_eclipse_swt_graphics_LineAttributes_2(currentState.lineAttributes);
    currentState.graphicHints |= gc.getLineStyle__();
    currentState.graphicHints |= gc.getAdvanced__() ? ADVANCED_GRAPHICS_MASK : 0;
    currentState.graphicHints |= gc.getXORMode__() ? XOR_MASK : 0;
    appliedState.graphicHints = currentState.graphicHints;
    currentState.relativeClip = new SWTGraphics$RectangleClipping(new Arguments(org.eclipse.draw2d.SWTGraphics$RectangleClipping.SWTGraphics$RectangleClipping__Lorg_eclipse_swt_graphics_Rectangle_2, [gc.getClipping__()]));
    currentState.alpha = gc.getAlpha__();
  }
  private function initTransform__Z(force: Boolean): void {
    if (!force && translateX == 0 && translateY == 0) {
      return;
    }
    if (transform === null) {
      transform = new Transform(new Arguments(org.eclipse.swt.graphics.Transform.Transform__Lorg_eclipse_swt_graphics_Device_2, [Display.getCurrent__()]));
      elementsNeedUpdate = true;
      transform.translate__FF(translateX, translateY);
      translateX = 0;
      translateY = 0;
      gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
      currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
    }
    return;
  }
  public override function popState__(): void {
    stackPointer--;
    this.restoreState__Lorg_eclipse_draw2d_SWTGraphics$State_2(SWTGraphics$State(stack.get__I(stackPointer)));
    return;
  }
  public override function pushState__(): void {
    if (currentState.relativeClip === null) {
      throw new IllegalStateException(new Arguments(java.lang.IllegalStateException.IllegalStateException__Ljava_lang_String_2, ["The clipping has been modified ina way that cannot be saved and restored."]));
    }
    try {
      var s: SWTGraphics$State;
      currentState.dx = translateX;
      currentState.dy = translateY;
      if (elementsNeedUpdate) {
        elementsNeedUpdate = false;
        transform.getElements___3F(currentState.affineMatrix = new JavaArray("[F").lengths(6));
      }
      if (stack.size__() > stackPointer) {
        s = SWTGraphics$State(stack.get__I(stackPointer));
        s.copyFrom__Lorg_eclipse_draw2d_SWTGraphics$State_2(currentState);
      } else {
        stack.add__Ljava_lang_Object_2(currentState.clone__());
      }
      sharedClipping = true;
      stackPointer++;
    } catch (e : CloneNotSupportedException) {
      throw new RuntimeException(new Arguments(java.lang.RuntimeException.RuntimeException__Ljava_lang_Throwable_2, [e]));
    }
    return;
  }
  private static function reconcileHints__Lorg_eclipse_swt_graphics_GC_2II(gc: GC, applied: int, hints: int): void {
    var changes: int = hints ^ applied;
    if ((changes & XOR_MASK) != 0) {
      gc.setXORMode__Z((hints & XOR_MASK) != 0);
    }
    changes &= ~XOR_MASK;
    if (changes != 0) {
      if ((changes & INTERPOLATION_MASK) != 0) {
        gc.setInterpolation__I(((hints & INTERPOLATION_MASK) >> INTERPOLATION_SHIFT) - 1);
      }
      if ((changes & FILL_RULE_MASK) != 0) {
        gc.setFillRule__I(((hints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
      }
      if ((changes & AA_MASK) != 0) {
        gc.setAntialias__I(((hints & AA_MASK) >> AA_SHIFT) - 1);
      }
      if ((changes & TEXT_AA_MASK) != 0) {
        gc.setTextAntialias__I(((hints & TEXT_AA_MASK) >> TEXT_AA_SHIFT) - 1);
      }
      if ((changes & ADVANCED_GRAPHICS_MASK) != 0) {
        if ((hints & ADVANCED_GRAPHICS_MASK) != 0 && !gc.getAdvanced__()) {
          gc.setAdvanced__Z(true);
        }
      }
    }
    return;
  }
  public override function restoreState__(): void {
    this.restoreState__Lorg_eclipse_draw2d_SWTGraphics$State_2(SWTGraphics$State(stack.get__I(stackPointer - 1)));
    return;
  }
  public function restoreState__Lorg_eclipse_draw2d_SWTGraphics$State_2(s: SWTGraphics$State): void {
    this.setAffineMatrix___3F(s.affineMatrix);
    currentState.relativeClip = s.relativeClip;
    sharedClipping = true;
    if (gc.getAdvanced__() && (s.graphicHints & ADVANCED_GRAPHICS_MASK) == 0) {
      appliedState.relativeClip = null;
      gc.setAdvanced__Z(false);
      appliedState.graphicHints &= ~ADVANCED_HINTS_MASK;
      appliedState.graphicHints |= ADVANCED_HINTS_DEFAULTS;
    }
    this.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(s.bgColor);
    this.setBackgroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(s.bgPattern);
    this.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(s.fgColor);
    this.setForegroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(s.fgPattern);
    this.setAlpha__I(s.alpha);
    this.setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(s.lineAttributes);
    this.setFont__Lorg_eclipse_swt_graphics_Font_2(s.font);
    this.setGraphicHints__I(s.graphicHints);
    translateX = currentState.dx = s.dx;
    translateY = currentState.dy = s.dy;
    return;
  }
  public override function rotate__F(degrees: Number): void {
    this.checkGC__();
    this.initTransform__Z(true);
    transform.rotate__F(degrees);
    gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    elementsNeedUpdate = true;
    appliedState.relativeClip = currentState.relativeClip = null;
    return;
  }
  public override function scale__D(factor: Number): void {
    this.scale__FF(Number(factor), Number(factor));
    return;
  }
  public override function scale__FF(horizontal: Number, vertical: Number): void {
    this.checkGC__();
    this.initTransform__Z(true);
    transform.scale__FF(horizontal, vertical);
    gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    elementsNeedUpdate = true;
    this.checkSharedClipping__();
    if (currentState.relativeClip !== null)
      currentState.relativeClip.scale__FF(horizontal, vertical);
    return;
  }
  private function setAffineMatrix___3F(m: JavaArray): void {
    if (!elementsNeedUpdate && currentState.affineMatrix === m)
      return;
    currentState.affineMatrix = m;
    if (m !== null)
      transform.setElements__FFFFFF(m[0], m[1], m[2], m[3], m[4], m[5]);
    else if (transform !== null) {
      transform.dispose__();
      transform = null;
      elementsNeedUpdate = false;
    }
    gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    return;
  }
  public override function setAlpha__I(alpha: int): void {
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
    if (currentState.alpha != alpha)
      gc.setAlpha__I(this.currentState.alpha = alpha);
    return;
  }
  public override function setAntialias__I(value: int): void {
    currentState.graphicHints &= ~AA_MASK;
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | (value + 1) << AA_SHIFT;
    return;
  }
  public override function setAdvanced__Z(value: Boolean): void {
    if (value) {
      currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
    } else {
      currentState.graphicHints &= ~ADVANCED_GRAPHICS_MASK;
    }
    return;
  }
  public override function setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    currentState.bgColor = color;
    if (currentState.bgPattern !== null) {
      currentState.bgPattern = null;
      appliedState.bgColor = null;
    }
    return;
  }
  public override function setBackgroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern: Pattern): void {
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
    if (currentState.bgPattern === pattern) {
      return;
    }
    currentState.bgPattern = pattern;
    if (pattern !== null) {
      this.initTransform__Z(true);
    }
    gc.setBackgroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern);
    return;
  }
  public override function setClip__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    this.initTransform__Z(false);
    if (((appliedState.graphicHints ^ currentState.graphicHints) & FILL_RULE_MASK) != 0) {
      gc.setFillRule__I(((currentState.graphicHints & FILL_RULE_MASK) >> FILL_RULE_SHIFT) - -1);
      appliedState.graphicHints ^= FILL_RULE_MASK;
    }
    gc.setClipping__Lorg_eclipse_swt_graphics_Path_2(path);
    appliedState.relativeClip = currentState.relativeClip = null;
    return;
  }
  public override function setClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): void {
    currentState.relativeClip = new SWTGraphics$RectangleClipping(new Arguments(org.eclipse.draw2d.SWTGraphics$RectangleClipping.SWTGraphics$RectangleClipping__Lorg_eclipse_draw2d_geometry_Rectangle_2, [rect]));
    return;
  }
  public override function setFillRule__I(rule: int): void {
    currentState.graphicHints &= ~FILL_RULE_MASK;
    currentState.graphicHints |= (rule + -1) << FILL_RULE_SHIFT;
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): void {
    currentState.font = f;
    return;
  }
  public override function setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    currentState.fgColor = color;
    if (currentState.fgPattern !== null) {
      currentState.fgPattern = null;
      appliedState.fgColor = null;
    }
    return;
  }
  public override function setForegroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern: Pattern): void {
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK;
    if (currentState.fgPattern === pattern) {
      return;
    }
    currentState.fgPattern = pattern;
    if (pattern !== null) {
      this.initTransform__Z(true);
    }
    gc.setForegroundPattern__Lorg_eclipse_swt_graphics_Pattern_2(pattern);
    return;
  }
  private function setGraphicHints__I(hints: int): void {
    currentState.graphicHints = hints;
    return;
  }
  public override function setInterpolation__I(interpolation: int): void {
    currentState.graphicHints &= ~INTERPOLATION_MASK;
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | (interpolation + 1) << INTERPOLATION_SHIFT;
    return;
  }
  public override function setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(lineAttributes: LineAttributes): void {
    SWTGraphics.copyLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2Lorg_eclipse_swt_graphics_LineAttributes_2(currentState.lineAttributes, lineAttributes);
    return;
  }
  public override function setLineCap__I(value: int): void {
    currentState.lineAttributes.cap = value;
    return;
  }
  public override function setLineDash___3I(dashes: JavaArray): void {
    var fArray: JavaArray = null;
    if (dashes !== null) {
      fArray = new JavaArray("[F").lengths(dashes.length);
      for (var i: int = 0; i < dashes.length; i++) {
        fArray[i] = dashes[i];
      }
    }
    this.setLineDash___3F(fArray);
    return;
  }
  public override function setLineDash___3F(value: JavaArray): void {
    if (value !== null) {
      for (var i: int = 0; i < value.length; i++) {
        if (value[i] <= 0) {
          SWT.error__I(5);
        }
      }
      currentState.lineAttributes.dash = JavaArray(Object(value).clone__());
      currentState.lineAttributes.style = 6;
    } else {
      currentState.lineAttributes.dash = null;
      currentState.lineAttributes.style = 1;
    }
    return;
  }
  public function setLineDashOffset__F(value: Number): void {
    currentState.lineAttributes.dashOffset = value;
    return;
  }
  public override function setLineJoin__I(value: int): void {
    currentState.lineAttributes.join = value;
    return;
  }
  public override function setLineStyle__I(value: int): void {
    currentState.lineAttributes.style = value;
    return;
  }
  public override function setLineWidth__I(width: int): void {
    currentState.lineAttributes.width = width;
    return;
  }
  public override function setLineWidthFloat__F(value: Number): void {
    currentState.lineAttributes.width = value;
    return;
  }
  public override function setLineMiterLimit__F(value: Number): void {
    currentState.lineAttributes.miterLimit = value;
    return;
  }
  public override function setTextAntialias__I(value: int): void {
    currentState.graphicHints &= ~TEXT_AA_MASK;
    currentState.graphicHints |= ADVANCED_GRAPHICS_MASK | (value + 1) << TEXT_AA_SHIFT;
    return;
  }
  public override function setXORMode__Z(xor: Boolean): void {
    currentState.graphicHints &= ~XOR_MASK;
    if (xor) {
      currentState.graphicHints |= XOR_MASK;
    }
    return;
  }
  public override function shear__FF(horz: Number, vert: Number): void {
    this.checkGC__();
    this.initTransform__Z(true);
    var matrix: JavaArray = new JavaArray("[F").lengths(6);
    transform.getElements___3F(matrix);
    transform.setElements__FFFFFF(matrix[0] + matrix[2] * vert, matrix[1] + matrix[3] * vert, matrix[0] * horz + matrix[2], matrix[1] * horz + matrix[3], matrix[4], matrix[5]);
    gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    elementsNeedUpdate = true;
    appliedState.relativeClip = currentState.relativeClip = null;
    return;
  }
  public override function translate__II(dx: int, dy: int): void {
    if (dx == 0 && dy == 0)
      return;
    if (transform !== null) {
      this.checkGC__();
      transform.translate__FF(dx, dy);
      elementsNeedUpdate = true;
      gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    } else {
      translateX += dx;
      translateY += dy;
    }
    this.checkSharedClipping__();
    if (currentState.relativeClip !== null)
      currentState.relativeClip.translate__FF(-dx, -dy);
    return;
  }
  public override function translate__FF(dx: Number, dy: Number): void {
    this.initTransform__Z(true);
    this.checkGC__();
    transform.translate__FF(dx, dy);
    elementsNeedUpdate = true;
    gc.setTransform__Lorg_eclipse_swt_graphics_Transform_2(transform);
    this.checkSharedClipping__();
    if (currentState.relativeClip !== null)
      currentState.relativeClip.translate__FF(-dx, -dy);
    return;
  }
  private function translatePointArray___3III(points: JavaArray, translateX_1: int, translateY_1: int): void {
    if (translateX_1 == 0 && translateY_1 == 0)
      return;
    for (var i: int = 0; (i + 1) < points.length; i += 2) {
      points[i] += translateX_1;
      points[i + 1] += translateY_1;
    }
    return;
  }
  public static function clone__Lorg_eclipse_swt_graphics_LineAttributes_2(src: LineAttributes): LineAttributes {
    var dashClone: JavaArray = null;
    if (src.dash !== null) {
      dashClone = new JavaArray("[F").lengths(src.dash.length);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(src.dash, 0, dashClone, 0, dashClone.length);
    }
    return new LineAttributes(new Arguments(org.eclipse.swt.graphics.LineAttributes.LineAttributes__FIII_3FFF, [src.width, src.cap, src.join, src.style, dashClone, src.dashOffset, src.miterLimit]));
  }
  public static function copyLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2Lorg_eclipse_swt_graphics_LineAttributes_2(dest: LineAttributes, src: LineAttributes): void {
    if (dest !== src) {
      dest.cap = src.cap;
      dest.join = src.join;
      dest.miterLimit = src.miterLimit;
      dest.style = src.style;
      dest.width = src.width;
      if (src.dash === null) {
        dest.dash = null;
      } else {
        if ((dest.dash === null) || (dest.dash.length != src.dash.length)) {
          dest.dash = new JavaArray("[F").lengths(src.dash.length);
        }
        System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(src.dash, 0, dest.dash, 0, src.dash.length);
      }
    }
    return;
  }
  private static function convertFloatArrayToInt___3F(fArray: JavaArray): JavaArray {
    var iArray: JavaArray = null;
    if (fArray !== null) {
      var arrayLen: int = fArray.length;
      iArray = new JavaArray("[I").lengths(arrayLen);
      for (var i: int = 0; i < arrayLen; i++) {
        iArray[i] = int(fArray[i]);
      }
    }
    return iArray;
  }
}
}
