package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
dynamic public class ScalableFreeformLayeredPane extends FreeformLayeredPane implements ScalableFigure {
  private var scale: Number = 1.0;
  public override function getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): Rectangle {
    super.getClientArea__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    rect.width /= scale;
    rect.height /= scale;
    rect.x /= scale;
    rect.y /= scale;
    return rect;
  }
  public function getScale__(): Number {
    return scale;
  }
  public override function isCoordinateSystem__(): Boolean {
    return true;
  }
  public override function paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    if (this.getChildren__().isEmpty__())
      return;
    if (scale == 1.0) {
      super.paintClientArea__Lorg_eclipse_draw2d_Graphics_2(graphics);
    } else {
      var g: ScaledGraphics = new ScaledGraphics(graphics);
      var optimizeClip: Boolean = this.getBorder__() === null || this.getBorder__().isOpaque__();
      if (!optimizeClip)
        g.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getBounds__().getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(this.getInsets__()));
      g.scale__D(scale);
      g.pushState__();
      this.paintChildren__Lorg_eclipse_draw2d_Graphics_2(g);
      g.dispose__();
      graphics.restoreState__();
    }
    return;
  }
  public function setScale__D(newZoom: Number): void {
    if (scale == newZoom)
      return;
    scale = newZoom;
    this.superFireMoved__();
    this.getFreeformHelper__().invalidate__();
    this.repaint__();
  }
  public override function translateToParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    t.performScale__D(scale);
  }
  public override function translateFromParent__Lorg_eclipse_draw2d_geometry_Translatable_2(t: Translatable): void {
    t.performScale__D(1 / scale);
  }
  public override function useLocalCoordinates__(): Boolean {
    return false;
  }
}
}
