package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ScalablePolygonShape extends AbstractPointListShape {
  public static var TEMPLATEBOUNDS: Rectangle = Rectangle.SINGLETON;
  private var scaledPoints: PointList;
  public override function shapeContainsPoint__II(x: int, y: int): Boolean {
    var location: Point = this.getLocation__();
    return Geometry.polygonContainsPoint__Lorg_eclipse_draw2d_geometry_PointList_2II(this.getScaledPoints__(), x - location.x, y - location.y);
  }
  public override function fillShape__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    graphics.pushState__();
    graphics.translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getLocation__());
    graphics.fillPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(this.getScaledPoints__());
    graphics.popState__();
  }
  public override function outlineShape__Lorg_eclipse_draw2d_Graphics_2(graphics: Graphics): void {
    graphics.pushState__();
    graphics.translate__Lorg_eclipse_draw2d_geometry_Point_2(this.getLocation__());
    graphics.drawPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(this.getScaledPoints__());
    graphics.popState__();
  }
  private function getTemplateBounds__(): Rectangle {
    TEMPLATEBOUNDS.setLocation__II(0, 0);
    TEMPLATEBOUNDS.setSize__II(0, 0);
    var intArray: JavaArray = points.toIntArray__();
    for (var i: int = 0; i < intArray.length;) {
      var x: int = intArray[i++];
      if (x > TEMPLATEBOUNDS.width) {
        TEMPLATEBOUNDS.width = x;
      }
      var y: int = intArray[i++];
      if (y > TEMPLATEBOUNDS.height) {
        TEMPLATEBOUNDS.height = y;
      }
    }
    return TEMPLATEBOUNDS;
  }
  public function getScaledPoints__(): PointList {
    if (scaledPoints !== null) {
      return scaledPoints;
    }
    var pointsBounds: Rectangle = this.getTemplateBounds__();
    var actualBounds: Rectangle = this.getBounds__();
    var xScale: Number = actualBounds.width > lineWidth ? (Number(actualBounds.width) - lineWidth) / pointsBounds.width : 0;
    var yScale: Number = actualBounds.height > lineWidth ? (Number(actualBounds.height) - lineWidth) / pointsBounds.height : 0;
    var halfLineWidth: Number = (Number(lineWidth)) / 2;
    var pointsArray: JavaArray = points.getCopy__().toIntArray__();
    for (var i: int = 0; i < pointsArray.length; i = i + 2) {
      pointsArray[i] = int((Math__.floor__D(pointsArray[i] * xScale) + halfLineWidth));
      pointsArray[i + 1] = int((Math__.floor__D(pointsArray[i + 1] * yScale) + halfLineWidth));
    }
    return scaledPoints = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList___3I, [pointsArray]));
  }
  public override function addPoint__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): void {
    scaledPoints = null;
    super.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(pt);
  }
  public override function insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt: Point, index: int): void {
    scaledPoints = null;
    super.insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt, index);
  }
  public override function removeAllPoints__(): void {
    scaledPoints = null;
    super.removeAllPoints__();
  }
  public override function removePoint__I(index: int): void {
    scaledPoints = null;
    super.removePoint__I(index);
  }
  public override function setStart__Lorg_eclipse_draw2d_geometry_Point_2(start: Point): void {
    scaledPoints = null;
    super.setStart__Lorg_eclipse_draw2d_geometry_Point_2(start);
  }
  public override function setEnd__Lorg_eclipse_draw2d_geometry_Point_2(end: Point): void {
    scaledPoints = null;
    super.setEnd__Lorg_eclipse_draw2d_geometry_Point_2(end);
  }
  public override function setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt: Point, index: int): void {
    scaledPoints = null;
    super.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt, index);
  }
  public override function setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1: PointList): void {
    scaledPoints = null;
    super.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1);
  }
  public override function setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: Rectangle): void {
    scaledPoints = null;
    super.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
  }
  public override function setLineWidth__I(w: int): void {
    scaledPoints = null;
    super.setLineWidth__I(w);
  }
}
}
