package org.eclipse.draw2d {
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class ScaledGraphics extends Graphics {
  public static var intArrayCache: JavaArray = new JavaArray("[[I").lengths(8);
  private var tempRECT: org.eclipse.draw2d.geometry.Rectangle = new org.eclipse.draw2d.geometry.Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__, []));
  private var allowText: Boolean = true;
  private var fontCache: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var fontDataCache: Map = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
  private var fontKey: ScaledGraphics$FontKey = new ScaledGraphics$FontKey(new Arguments(org.eclipse.draw2d.ScaledGraphics$FontKey.ScaledGraphics$FontKey__, []));
  private var fractionalX: Number = 0;
  private var fractionalY: Number = 0;
  private var graphics: Graphics;
  private var localCache: ScaledGraphics$FontHeightCache = new ScaledGraphics$FontHeightCache();
  private var localFont: Font;
  private var localLineWidth: Number = 0;
  private var stack: List = new ArrayList(new Arguments(java.util.ArrayList.ArrayList__, []));
  private var stackPointer: int = 0;
  private var targetCache: ScaledGraphics$FontHeightCache = new ScaledGraphics$FontHeightCache();
  internal var zoom: Number = 1.0;

  __clinit();

  static private function __clinit(): void {
    {
      for (var i: int = 0; i < intArrayCache.length; i++)
        intArrayCache[i] = new JavaArray("[I").lengths(i + 1);
    }
  }
  public function ScaledGraphics(g: Graphics) {
    graphics = g;
    localFont = g.getFont__();
    localLineWidth = g.getLineWidthFloat__();
    return;
  }
  public override function clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(r: org.eclipse.draw2d.geometry.Rectangle): void {
    graphics.clipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomClipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(r));
    return;
  }
  public function createFont__Lorg_eclipse_swt_graphics_FontData_2(data: FontData): Font {
    return new Font(new Arguments(org.eclipse.swt.graphics.Font.Font__Lorg_eclipse_swt_graphics_Device_2Lorg_eclipse_swt_graphics_FontData_2, [Display.getCurrent__(), data]));
  }
  private function createScaledPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): Path {
    var p: PathData = path.getPathData__();
    for (var i: int = 0; i < p.points.length; i += 2) {
      p.points[i] = Number((p.points[i] * zoom + fractionalX));
      p.points[i + 1] = Number((p.points[i + 1] * zoom + fractionalY));
    }
    var scaledPath: Path = new Path(path.getDevice__());
    var index: int = 0;
    for (var i_1: int = 0; i_1 < p.types.length; i_1++) {
      var type: int = p.types[i_1];
      switch (type) {
        case 1 :
          scaledPath.moveTo__FF(p.points[index], p.points[index + 1]);
          index += 2;
          break;
        case 2 :
          scaledPath.lineTo__FF(p.points[index], p.points[index + 1]);
          index += 2;
          break;
        case 4 :
          scaledPath.cubicTo__FFFFFF(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3], p.points[index + 4], p.points[index + 5]);
          index += 6;
          break;
        case 3 :
          scaledPath.quadTo__FFFF(p.points[index], p.points[index + 1], p.points[index + 2], p.points[index + 3]);
          index += 4;
          break;
        case 5 :
          scaledPath.close__();
          break;
      }
    }
    return scaledPath;
  }
  public override function dispose__(): void {
    while (stackPointer > 0) {
      this.popState__();
    }
    var iter: Iterator = Iterator(fontCache.values__().iterator__());
    while (iter.hasNext__()) {
      var font: Font = (Font(iter.next__()));
      font.dispose__();
    }
    return;
  }
  public override function drawArc__IIIIII(x: int, y: int, w: int, h: int, offset: int, sweep: int): void {
    var z: org.eclipse.draw2d.geometry.Rectangle = this.zoomRect__IIII(x, y, w, h);
    if (z.isEmpty__() || sweep == 0)
      return;
    graphics.drawArc__Lorg_eclipse_draw2d_geometry_Rectangle_2II(z, offset, sweep);
  }
  public override function drawFocus__IIII(x: int, y: int, w: int, h: int): void {
    graphics.drawFocus__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomRect__IIII(x, y, w, h));
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2II(srcImage: Image, x: int, y: int): void {
    var size: org.eclipse.swt.graphics.Rectangle = srcImage.getBounds__();
    graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage, 0, 0, size.width, size.height, int((Math__.floor__D((x * zoom + fractionalX)))), int((Math__.floor__D((y * zoom + fractionalY)))), int((Math__.floor__D((size.width * zoom + fractionalX)))), int((Math__.floor__D((size.height * zoom + fractionalY)))));
  }
  public override function drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage: Image, sx: int, sy: int, sw: int, sh: int, tx: int, ty: int, tw: int, th: int): void {
    var t: org.eclipse.draw2d.geometry.Rectangle = this.zoomRect__IIII(tx, ty, tw, th);
    if (!t.isEmpty__())
      graphics.drawImage__Lorg_eclipse_swt_graphics_Image_2IIIIIIII(srcImage, sx, sy, sw, sh, t.x, t.y, t.width, t.height);
  }
  public override function drawLine__IIII(x1: int, y1: int, x2: int, y2: int): void {
    graphics.drawLine__IIII(int((Math__.floor__D((x1 * zoom + fractionalX)))), int((Math__.floor__D((y1 * zoom + fractionalY)))), int((Math__.floor__D((x2 * zoom + fractionalX)))), int((Math__.floor__D((y2 * zoom + fractionalY)))));
  }
  public override function drawOval__IIII(x: int, y: int, w: int, h: int): void {
    graphics.drawOval__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomRect__IIII(x, y, w, h));
  }
  public override function drawPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    var scaledPath: Path = this.createScaledPath__Lorg_eclipse_swt_graphics_Path_2(path);
    try {
      graphics.drawPath__Lorg_eclipse_swt_graphics_Path_2(scaledPath);
    } finally {
      scaledPath.dispose__();
    }
    return;
  }
  public override function drawPoint__II(x: int, y: int): void {
    graphics.drawPoint__II(int(Math__.floor__D(x * zoom + fractionalX)), int(Math__.floor__D(y * zoom + fractionalY)));
    return;
  }
  public override function drawPolygon___3I(points: JavaArray): void {
    graphics.drawPolygon___3I(this.zoomPointList___3I(points));
    return;
  }
  public override function drawPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    graphics.drawPolygon___3I(this.zoomPointList___3I(points.toIntArray__()));
    return;
  }
  public override function drawPolyline___3I(points: JavaArray): void {
    graphics.drawPolyline___3I(this.zoomPointList___3I(points));
    return;
  }
  public override function drawPolyline__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    graphics.drawPolyline___3I(this.zoomPointList___3I(points.toIntArray__()));
    return;
  }
  public override function drawRectangle__IIII(x: int, y: int, w: int, h: int): void {
    graphics.drawRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomRect__IIII(x, y, w, h));
    return;
  }
  public override function drawRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(r: org.eclipse.draw2d.geometry.Rectangle, arcWidth: int, arcHeight: int): void {
    graphics.drawRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(this.zoomRect__IIII(r.x, r.y, r.width, r.height), int((arcWidth * zoom)), int((arcHeight * zoom)));
    return;
  }
  public override function drawString__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    if (allowText)
      graphics.drawString__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(s, this.zoomTextPoint__II(x, y));
    return;
  }
  public override function drawText__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    if (allowText)
      graphics.drawText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(s, this.zoomTextPoint__II(x, y));
    return;
  }
  public override function drawText__Ljava_lang_String_2III(s: String, x: int, y: int, style: int): void {
    if (allowText)
      graphics.drawText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2I(s, this.zoomTextPoint__II(x, y), style);
    return;
  }
  public override function drawTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(layout: TextLayout, x: int, y: int, selectionStart: int, selectionEnd: int, selectionForeground: Color, selectionBackground: Color): void {
    var scaled: TextLayout = this.zoomTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout);
    graphics.drawTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2IIIILorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(scaled, int(Math__.floor__D(x * zoom + fractionalX)), int(Math__.floor__D(y * zoom + fractionalY)), selectionStart, selectionEnd, selectionBackground, selectionForeground);
    scaled.dispose__();
    return;
  }
  public override function fillArc__IIIIII(x: int, y: int, w: int, h: int, offset: int, sweep: int): void {
    var z: org.eclipse.draw2d.geometry.Rectangle = this.zoomFillRect__IIII(x, y, w, h);
    if (z.isEmpty__() || sweep == 0)
      return;
    graphics.fillArc__Lorg_eclipse_draw2d_geometry_Rectangle_2II(z, offset, sweep);
  }
  public override function fillGradient__IIIIZ(x: int, y: int, w: int, h: int, vertical: Boolean): void {
    graphics.fillGradient__Lorg_eclipse_draw2d_geometry_Rectangle_2Z(this.zoomFillRect__IIII(x, y, w, h), vertical);
  }
  public override function fillOval__IIII(x: int, y: int, w: int, h: int): void {
    graphics.fillOval__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomFillRect__IIII(x, y, w, h));
  }
  public override function fillPath__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    var scaledPath: Path = this.createScaledPath__Lorg_eclipse_swt_graphics_Path_2(path);
    try {
      graphics.fillPath__Lorg_eclipse_swt_graphics_Path_2(scaledPath);
    } finally {
      scaledPath.dispose__();
    }
    return;
  }
  public override function fillPolygon___3I(points: JavaArray): void {
    graphics.fillPolygon___3I(this.zoomPointList___3I(points));
    return;
  }
  public override function fillPolygon__Lorg_eclipse_draw2d_geometry_PointList_2(points: PointList): void {
    graphics.fillPolygon___3I(this.zoomPointList___3I(points.toIntArray__()));
    return;
  }
  public override function fillRectangle__IIII(x: int, y: int, w: int, h: int): void {
    graphics.fillRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomFillRect__IIII(x, y, w, h));
    return;
  }
  public override function fillRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(r: org.eclipse.draw2d.geometry.Rectangle, arcWidth: int, arcHeight: int): void {
    graphics.fillRoundRectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2II(this.zoomFillRect__IIII(r.x, r.y, r.width, r.height), int((arcWidth * zoom)), int((arcHeight * zoom)));
    return;
  }
  public override function fillString__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    if (allowText)
      graphics.fillString__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(s, this.zoomTextPoint__II(x, y));
    return;
  }
  public override function fillText__Ljava_lang_String_2II(s: String, x: int, y: int): void {
    if (allowText)
      graphics.fillText__Ljava_lang_String_2Lorg_eclipse_draw2d_geometry_Point_2(s, this.zoomTextPoint__II(x, y));
    return;
  }
  public override function getAbsoluteScale__(): Number {
    return zoom * graphics.getAbsoluteScale__();
  }
  public override function getAlpha__(): int {
    return graphics.getAlpha__();
  }
  public override function getAntialias__(): int {
    return graphics.getAntialias__();
  }
  public override function getBackgroundColor__(): Color {
    return graphics.getBackgroundColor__();
  }
  public function getCachedFont__Lorg_eclipse_draw2d_ScaledGraphics$FontKey_2(key: ScaledGraphics$FontKey): Font {
    var font: Font = Font(fontCache.get__Ljava_lang_Object_2(key));
    if (font !== null)
      return font;
    key = new ScaledGraphics$FontKey(new Arguments(org.eclipse.draw2d.ScaledGraphics$FontKey.ScaledGraphics$FontKey__Lorg_eclipse_swt_graphics_Font_2I, [key.font, key.height]));
    var data: FontData = key.font.getFontData__()[0];
    data.setHeight__I(key.height);
    var zoomedFont: Font = this.createFont__Lorg_eclipse_swt_graphics_FontData_2(data);
    fontCache.put__Ljava_lang_Object_2Ljava_lang_Object_2(key, zoomedFont);
    return zoomedFont;
  }
  public function getCachedFontData__Lorg_eclipse_swt_graphics_Font_2(f: Font): FontData {
    var data: FontData = FontData(fontDataCache.get__Ljava_lang_Object_2(f));
    if (data !== null)
      return data;
    data = this.getLocalFont__().getFontData__()[0];
    fontDataCache.put__Ljava_lang_Object_2Ljava_lang_Object_2(f, data);
    return data;
  }
  public override function getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    graphics.getClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(rect);
    var x: int = int((rect.x / zoom));
    var y: int = int((rect.y / zoom));
    rect.width = int(Math__.ceil__D(rect.right__() / zoom)) - x;
    rect.height = int(Math__.ceil__D(rect.bottom__() / zoom)) - y;
    rect.x = x;
    rect.y = y;
    return rect;
  }
  public override function getFillRule__(): int {
    return graphics.getFillRule__();
  }
  public override function getFont__(): Font {
    return this.getLocalFont__();
  }
  public override function getFontMetrics__(): FontMetrics {
    return FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(localFont);
  }
  public override function getForegroundColor__(): Color {
    return graphics.getForegroundColor__();
  }
  public override function getInterpolation__(): int {
    return graphics.getInterpolation__();
  }
  public override function getLineCap__(): int {
    return graphics.getLineCap__();
  }
  public override function getLineJoin__(): int {
    return graphics.getLineJoin__();
  }
  public override function getLineStyle__(): int {
    return graphics.getLineStyle__();
  }
  public override function getLineMiterLimit__(): Number {
    return graphics.getLineMiterLimit__();
  }
  public override function getLineWidth__(): int {
    return int(this.getLocalLineWidth__());
  }
  public override function getLineWidthFloat__(): Number {
    return this.getLocalLineWidth__();
  }
  private function getLocalFont__(): Font {
    return localFont;
  }
  private function getLocalLineWidth__(): Number {
    return localLineWidth;
  }
  public override function getTextAntialias__(): int {
    return graphics.getTextAntialias__();
  }
  public override function getXORMode__(): Boolean {
    return graphics.getXORMode__();
  }
  public override function popState__(): void {
    graphics.popState__();
    stackPointer--;
    this.restoreLocalState__Lorg_eclipse_draw2d_ScaledGraphics$State_2(ScaledGraphics$State(stack.get__I(stackPointer)));
  }
  public override function pushState__(): void {
    var s: ScaledGraphics$State;
    if (stack.size__() > stackPointer) {
      s = ScaledGraphics$State(stack.get__I(stackPointer));
      s.setValues__DDDLorg_eclipse_swt_graphics_Font_2F(zoom, fractionalX, fractionalY, this.getLocalFont__(), localLineWidth);
    } else {
      stack.add__Ljava_lang_Object_2(new ScaledGraphics$State(new Arguments(org.eclipse.draw2d.ScaledGraphics$State.ScaledGraphics$State__DDDLorg_eclipse_swt_graphics_Font_2F, [zoom, fractionalX, fractionalY, this.getLocalFont__(), localLineWidth])));
    }
    stackPointer++;
    graphics.pushState__();
    return;
  }
  private function restoreLocalState__Lorg_eclipse_draw2d_ScaledGraphics$State_2(state: ScaledGraphics$State): void {
    this.fractionalX = state.appliedX;
    this.fractionalY = state.appliedY;
    this.setScale__D(state.zoom);
    this.setLocalFont__Lorg_eclipse_swt_graphics_Font_2(state.font);
    this.setLocalLineWidth__F(state.lineWidth);
    return;
  }
  public override function restoreState__(): void {
    graphics.restoreState__();
    this.restoreLocalState__Lorg_eclipse_draw2d_ScaledGraphics$State_2(ScaledGraphics$State(stack.get__I(stackPointer - 1)));
    return;
  }
  public override function scale__D(amount: Number): void {
    this.setScale__D(zoom * amount);
    return;
  }
  public override function setAlpha__I(alpha: int): void {
    graphics.setAlpha__I(alpha);
    return;
  }
  public override function setAntialias__I(value: int): void {
    graphics.setAntialias__I(value);
    return;
  }
  public override function setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(rgb: Color): void {
    graphics.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(rgb);
    return;
  }
  public override function setClip__Lorg_eclipse_swt_graphics_Path_2(path: Path): void {
    var scaledPath: Path = this.createScaledPath__Lorg_eclipse_swt_graphics_Path_2(path);
    try {
      graphics.setClip__Lorg_eclipse_swt_graphics_Path_2(scaledPath);
    } finally {
      scaledPath.dispose__();
    }
    return;
  }
  public override function setClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(r: org.eclipse.draw2d.geometry.Rectangle): void {
    graphics.setClip__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.zoomClipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(r));
    return;
  }
  public override function setFillRule__I(rule: int): void {
    graphics.setFillRule__I(rule);
    return;
  }
  public override function setFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): void {
    this.setLocalFont__Lorg_eclipse_swt_graphics_Font_2(f);
    return;
  }
  public override function setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(rgb: Color): void {
    graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(rgb);
    return;
  }
  public override function setInterpolation__I(interpolation: int): void {
    graphics.setInterpolation__I(interpolation);
    return;
  }
  public override function setLineCap__I(cap: int): void {
    graphics.setLineCap__I(cap);
    return;
  }
  public override function setLineDash___3I(dash: JavaArray): void {
    graphics.setLineDash___3I(dash);
    return;
  }
  public override function setLineJoin__I(join: int): void {
    graphics.setLineJoin__I(join);
    return;
  }
  public override function setLineStyle__I(style: int): void {
    graphics.setLineStyle__I(style);
    return;
  }
  public override function setLineMiterLimit__F(value: Number): void {
    graphics.setLineMiterLimit__F(value);
    return;
  }
  public override function setLineWidth__I(width: int): void {
    this.setLocalLineWidth__F(width);
    return;
  }
  public override function setLineWidthFloat__F(width: Number): void {
    this.setLocalLineWidth__F(width);
    return;
  }
  private function setLocalFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): void {
    localFont = f;
    graphics.setFont__Lorg_eclipse_swt_graphics_Font_2(this.zoomFont__Lorg_eclipse_swt_graphics_Font_2(f));
    return;
  }
  private function setLocalLineWidth__F(width: Number): void {
    localLineWidth = width;
    graphics.setLineWidthFloat__F(this.zoomLineWidth__F(width));
    return;
  }
  public function setScale__D(value: Number): void {
    if (zoom == value)
      return;
    this.zoom = value;
    graphics.setFont__Lorg_eclipse_swt_graphics_Font_2(this.zoomFont__Lorg_eclipse_swt_graphics_Font_2(this.getLocalFont__()));
    graphics.setLineWidthFloat__F(this.zoomLineWidth__F(localLineWidth));
  }
  public override function setTextAntialias__I(value: int): void {
    graphics.setTextAntialias__I(value);
  }
  public override function setXORMode__Z(b: Boolean): void {
    graphics.setXORMode__Z(b);
  }
  public override function translate__II(dx: int, dy: int): void {
    var dxFloat: Number = dx * zoom + fractionalX;
    var dyFloat: Number = dy * zoom + fractionalY;
    fractionalX = dxFloat - Math__.floor__D(dxFloat);
    fractionalY = dyFloat - Math__.floor__D(dyFloat);
    graphics.translate__II(int(Math__.floor__D(dxFloat)), int(Math__.floor__D(dyFloat)));
  }
  public override function translate__FF(dx: Number, dy: Number): void {
    var dxFloat: Number = dx * zoom + fractionalX;
    var dyFloat: Number = dy * zoom + fractionalY;
    fractionalX = dxFloat - Math__.floor__D(dxFloat);
    fractionalY = dyFloat - Math__.floor__D(dyFloat);
    graphics.translate__II(int(Math__.floor__D(dxFloat)), int(Math__.floor__D(dyFloat)));
  }
  private function zoomClipRect__Lorg_eclipse_draw2d_geometry_Rectangle_2(r: org.eclipse.draw2d.geometry.Rectangle): org.eclipse.draw2d.geometry.Rectangle {
    tempRECT.x = int((Math__.floor__D(r.x * zoom + fractionalX)));
    tempRECT.y = int((Math__.floor__D(r.y * zoom + fractionalY)));
    tempRECT.width = int((Math__.ceil__D(((r.x + r.width) * zoom + fractionalX)))) - tempRECT.x;
    tempRECT.height = int((Math__.ceil__D(((r.y + r.height) * zoom + fractionalY)))) - tempRECT.y;
    return tempRECT;
  }
  private function zoomFillRect__IIII(x: int, y: int, w: int, h: int): org.eclipse.draw2d.geometry.Rectangle {
    tempRECT.x = int((Math__.floor__D((x * zoom + fractionalX))));
    tempRECT.y = int((Math__.floor__D((y * zoom + fractionalY))));
    tempRECT.width = int((Math__.floor__D(((x + w - 1) * zoom + fractionalX)))) - tempRECT.x + 1;
    tempRECT.height = int((Math__.floor__D(((y + h - 1) * zoom + fractionalY)))) - tempRECT.y + 1;
    return tempRECT;
  }
  public function zoomFont__Lorg_eclipse_swt_graphics_Font_2(f: Font): Font {
    if (f === null)
      f = Display.getCurrent__().getSystemFont__();
    var data: FontData = this.getCachedFontData__Lorg_eclipse_swt_graphics_Font_2(f);
    var zoomedFontHeight: int = this.zoomFontHeight__I(data.getHeight__());
    allowText = zoomedFontHeight > 0;
    fontKey.setValues__Lorg_eclipse_swt_graphics_Font_2I(f, zoomedFontHeight);
    return this.getCachedFont__Lorg_eclipse_draw2d_ScaledGraphics$FontKey_2(fontKey);
  }
  public function zoomFontHeight__I(height: int): int {
    return int((zoom * height));
  }
  public function zoomLineWidth__F(w: Number): Number {
    return w;
  }
  private function zoomPointList___3I(points: JavaArray): JavaArray {
    var scaled: JavaArray = null;
    for (var i: int = 0; i < intArrayCache.length; i++) {
      if (intArrayCache[i].length == points.length) {
        scaled = intArrayCache[i];
        if (i != 0) {
          var temp: JavaArray = intArrayCache[i - 1];
          intArrayCache[i - 1] = scaled;
          intArrayCache[i] = temp;
        }
      }
    }
    if (scaled === null) {
      intArrayCache[intArrayCache.length - 1] = new JavaArray("[I").lengths(points.length);
      scaled = intArrayCache[intArrayCache.length - 1];
    }
    for (var i_1: int = 0; (i_1 + 1) < points.length; i_1 += 2) {
      scaled[i_1] = int((Math__.floor__D((points[i_1] * zoom + fractionalX))));
      scaled[i_1 + 1] = int((Math__.floor__D((points[i_1 + 1] * zoom + fractionalY))));
    }
    return scaled;
  }
  private function zoomRect__IIII(x: int, y: int, w: int, h: int): org.eclipse.draw2d.geometry.Rectangle {
    tempRECT.x = int((Math__.floor__D(x * zoom + fractionalX)));
    tempRECT.y = int((Math__.floor__D(y * zoom + fractionalY)));
    tempRECT.width = int((Math__.floor__D(((x + w) * zoom + fractionalX)))) - tempRECT.x;
    tempRECT.height = int((Math__.floor__D(((y + h) * zoom + fractionalY)))) - tempRECT.y;
    return tempRECT;
  }
  private function zoomTextLayout__Lorg_eclipse_swt_graphics_TextLayout_2(layout: TextLayout): TextLayout {
    var zoomed: TextLayout = new TextLayout(Display.getCurrent__());
    zoomed.setText__Ljava_lang_String_2(layout.getText__());
    var zoomWidth: int = -1;
    if (layout.getWidth__() != -1)
      zoomWidth = (int((layout.getWidth__() * zoom)));
    if (zoomWidth < -1 || zoomWidth == 0)
      return null;
    zoomed.setFont__Lorg_eclipse_swt_graphics_Font_2(this.zoomFont__Lorg_eclipse_swt_graphics_Font_2(layout.getFont__()));
    zoomed.setAlignment__I(layout.getAlignment__());
    zoomed.setAscent__I(layout.getAscent__());
    zoomed.setDescent__I(layout.getDescent__());
    zoomed.setOrientation__I(layout.getOrientation__());
    zoomed.setSegments___3I(layout.getSegments__());
    zoomed.setSpacing__I(layout.getSpacing__());
    zoomed.setTabs___3I(layout.getTabs__());
    zoomed.setWidth__I(zoomWidth);
    var length: int = Object(layout.getText__()).length__();
    if (length > 0) {
      var start: int = 0;
      var offset: int = 1;
      var style: TextStyle = null;
      var lastStyle: TextStyle = layout.getStyle__I(0);
      for (; offset <= length; offset++) {
        if (offset != length && (style = layout.getStyle__I(offset)) === lastStyle)
          continue;
        var end: int = offset - 1;
        if (lastStyle !== null) {
          var zoomedStyle: TextStyle = new TextStyle(new Arguments(org.eclipse.swt.graphics.TextStyle.TextStyle__Lorg_eclipse_swt_graphics_Font_2Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2, [this.zoomFont__Lorg_eclipse_swt_graphics_Font_2(lastStyle.font), lastStyle.foreground, lastStyle.background]));
          zoomedStyle.metrics = lastStyle.metrics;
          zoomedStyle.rise = lastStyle.rise;
          zoomedStyle.strikeout = lastStyle.strikeout;
          zoomedStyle.underline = lastStyle.underline;
          zoomed.setStyle__Lorg_eclipse_swt_graphics_TextStyle_2II(zoomedStyle, start, end);
        }
        lastStyle = style;
        start = offset;
      }
    }
    return zoomed;
  }
  private function zoomTextPoint__II(x: int, y: int): Point {
    if (localCache.font !== localFont) {
      var metric: FontMetrics = FigureUtilities.getFontMetrics__Lorg_eclipse_swt_graphics_Font_2(localFont);
      localCache.height = metric.getHeight__() - metric.getDescent__();
      localCache.font = localFont;
    }
    if (targetCache.font !== graphics.getFont__()) {
      var metric_1: FontMetrics = graphics.getFontMetrics__();
      targetCache.font = graphics.getFont__();
      targetCache.height = metric_1.getHeight__() - metric_1.getDescent__();
    }
    return new Point(new Arguments(org.eclipse.draw2d.geometry.Point.Point__II, [(int((Math__.floor__D((x * zoom) + fractionalX)))), int((Math__.floor__D((y + localCache.height - 1) * zoom - targetCache.height + 1 + fractionalY)))]));
  }
  public override function setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(attributes: LineAttributes): void {
    graphics.setLineAttributes__Lorg_eclipse_swt_graphics_LineAttributes_2(attributes);
  }
}
}
