package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Color;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
import java.lang.JavaArray;
dynamic public class SchemeBorder extends AbstractBorder implements ColorConstants {
  public var scheme: SchemeBorder$Scheme = null;
  public static var DARKEST_DARKER: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(org.eclipse.draw2d.ColorConstants$$fields.buttonDarkest, org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
  public static var LIGHTER_DARKER: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(org.eclipse.draw2d.ColorConstants$$fields.buttonLightest, org.eclipse.draw2d.ColorConstants$$fields.buttonDarker);
  public static var DARKER_LIGHTER: JavaArray = new JavaArray("[Lorg/eclipse/swt/graphics/Color;").values(org.eclipse.draw2d.ColorConstants$$fields.buttonDarker, org.eclipse.draw2d.ColorConstants$$fields.buttonLightest);
  public function SchemeBorder__(): Object {
    return this;
  }
  public function SchemeBorder__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2(scheme: SchemeBorder$Scheme): Object {
    this.setScheme__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2(scheme);
    return this;
  }
  public override function getInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets {
    return this.getScheme__().getInsets__();
  }
  public function getScheme__(): SchemeBorder$Scheme {
    return scheme;
  }
  public override function isOpaque__(): Boolean {
    return true;
  }
  public function setScheme__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2(scheme_1: SchemeBorder$Scheme): void {
    this.scheme = scheme_1;
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(figure: IFigure, g: Graphics, insets: Insets): void {
    var tl: JavaArray = scheme.getHighlight__();
    var br: JavaArray = scheme.getShadow__();
    this.paint__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2_3Lorg_eclipse_swt_graphics_Color_2_3Lorg_eclipse_swt_graphics_Color_2(g, figure, insets, tl, br);
  }
  public function paint__Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2_3Lorg_eclipse_swt_graphics_Color_2_3Lorg_eclipse_swt_graphics_Color_2(graphics: Graphics, fig: IFigure, insets: Insets, tl: JavaArray, br: JavaArray): void {
    graphics.setLineWidth__I(1);
    graphics.setLineStyle__I(1);
    graphics.setXORMode__Z(false);
    var rect: Rectangle = AbstractBorder.getPaintRectangle__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_geometry_Insets_2(fig, insets);
    var top: int = rect.y;
    var left: int = rect.x;
    var bottom: int = rect.bottom__() - 1;
    var right: int = rect.right__() - 1;
    var color: Color;
    for (var i: int = 0; i < br.length; i++) {
      color = br[i];
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(color);
      graphics.drawLine__IIII(right - i, bottom - i, right - i, top + i);
      graphics.drawLine__IIII(right - i, bottom - i, left + i, bottom - i);
    }
    right--;
    bottom--;
    for (var i_1: int = 0; i_1 < tl.length; i_1++) {
      color = tl[i_1];
      graphics.setForegroundColor__Lorg_eclipse_swt_graphics_Color_2(color);
      graphics.drawLine__IIII(left + i_1, top + i_1, right - i_1, top + i_1);
      graphics.drawLine__IIII(left + i_1, top + i_1, left + i_1, bottom - i_1);
    }
    return;
  }
  public function SchemeBorder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is SchemeBorder$Scheme) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        SchemeBorder__();
        break;
      case 1:
        SchemeBorder__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2(args1[0]);
        break;
    }
  }
  public static const SchemeBorder__ : int = 0;
  public static const SchemeBorder__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2 : int = 1;
}
}
