package org.eclipse.draw2d {
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.lang.Arguments;
dynamic public class ScrollBar extends Figure implements Orientable, PropertyChangeListener {
  public static var ORIENTATION_FLAG: int = Figure.MAX_FLAG << 1;
  public static var MAX_FLAG: int = ORIENTATION_FLAG;
  public static var COLOR_TRACK: Color = FigureUtilities.mixColors__Lorg_eclipse_swt_graphics_Color_2Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.white, org.eclipse.draw2d.ColorConstants$$fields.button);
  private var rangeModel: RangeModel = null;
  private var thumb: IFigure;
  private var pageUp: Clickable;
  private var pageDown: Clickable;
  private var buttonUp: Clickable;
  private var buttonDown: Clickable;
  public var thumbDragger: ScrollBar$ThumbDragger = new ScrollBar$ThumbDragger(ScrollBar(this));
  private var isHorizontal: Boolean = false;
  private var pageIncrement: int = 50;
  private var stepIncrement: int = 10;
  public var transposer: Transposer = new Transposer();
  public function ScrollBar() {
    {
      this.setRangeModel__Lorg_eclipse_draw2d_RangeModel_2(new DefaultRangeModel());
    }
    this.initialize__();
    return;
  }
  public function createDefaultUpButton__(): Clickable {
    var buttonUp_1: Button = new ArrowButton(new Arguments(org.eclipse.draw2d.ArrowButton.ArrowButton__, []));
    buttonUp_1.setBorder__Lorg_eclipse_draw2d_Border_2(new ButtonBorder(new Arguments(org.eclipse.draw2d.ButtonBorder.ButtonBorder__Lorg_eclipse_draw2d_ButtonBorder$ButtonScheme_2, [org.eclipse.draw2d.ButtonBorder$SCHEMES$$fields.BUTTON_SCROLLBAR])));
    return buttonUp_1;
  }
  public function createDefaultDownButton__(): Clickable {
    var buttonDown_1: Button = new ArrowButton(new Arguments(org.eclipse.draw2d.ArrowButton.ArrowButton__, []));
    buttonDown_1.setBorder__Lorg_eclipse_draw2d_Border_2(new ButtonBorder(new Arguments(org.eclipse.draw2d.ButtonBorder.ButtonBorder__Lorg_eclipse_draw2d_ButtonBorder$ButtonScheme_2, [org.eclipse.draw2d.ButtonBorder$SCHEMES$$fields.BUTTON_SCROLLBAR])));
    return buttonDown_1;
  }
  public function createPageDown__(): Clickable {
    return this.createPageUp__();
  }
  public function createPageUp__(): Clickable {
    var clickable: Clickable = new Clickable(new Arguments(org.eclipse.draw2d.Clickable.Clickable__, []));
    clickable.setOpaque__Z(true);
    clickable.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(COLOR_TRACK);
    clickable.setRequestFocusEnabled__Z(false);
    clickable.setFocusTraversable__Z(false);
    clickable.addChangeListener__Lorg_eclipse_draw2d_ChangeListener_2(new org.eclipse.draw2d.ScrollBar$1(this, clickable));
    return clickable;
  }
  public function createDefaultThumb__(): IFigure {
    var thumb_1: Panel = new Panel();
    thumb_1.setMinimumSize__Lorg_eclipse_draw2d_geometry_Dimension_2(new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [6, 6])));
    thumb_1.setBackgroundColor__Lorg_eclipse_swt_graphics_Color_2(org.eclipse.draw2d.ColorConstants$$fields.button);
    thumb_1.setBorder__Lorg_eclipse_draw2d_Border_2(new SchemeBorder(new Arguments(org.eclipse.draw2d.SchemeBorder.SchemeBorder__Lorg_eclipse_draw2d_SchemeBorder$Scheme_2, [org.eclipse.draw2d.SchemeBorder$SCHEMES$$fields.BUTTON_CONTRAST])));
    return thumb_1;
  }
  public function getButtonUp__(): IFigure {
    return buttonUp;
  }
  public function getButtonDown__(): IFigure {
    return buttonDown;
  }
  public function getExtent__(): int {
    return this.getRangeModel__().getExtent__();
  }
  public function getMinimum__(): int {
    return this.getRangeModel__().getMinimum__();
  }
  public function getMaximum__(): int {
    return this.getRangeModel__().getMaximum__();
  }
  public function getPageDown__(): IFigure {
    return pageDown;
  }
  public function getPageIncrement__(): int {
    return pageIncrement;
  }
  public function getPageUp__(): IFigure {
    return pageUp;
  }
  public function getRangeModel__(): RangeModel {
    return rangeModel;
  }
  public function getStepIncrement__(): int {
    return stepIncrement;
  }
  public function getThumb__(): IFigure {
    return thumb;
  }
  public function getValue__(): int {
    return this.getRangeModel__().getValue__();
  }
  public function getValueRange__(): int {
    return this.getMaximum__() - this.getExtent__() - this.getMinimum__();
  }
  public function initialize__(): void {
    this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new ScrollBarLayout(transposer));
    this.setUpClickable__Lorg_eclipse_draw2d_Clickable_2(this.createDefaultUpButton__());
    this.setDownClickable__Lorg_eclipse_draw2d_Clickable_2(this.createDefaultDownButton__());
    this.setPageUp__Lorg_eclipse_draw2d_Clickable_2(this.createPageUp__());
    this.setPageDown__Lorg_eclipse_draw2d_Clickable_2(this.createPageDown__());
    this.setThumb__Lorg_eclipse_draw2d_IFigure_2(this.createDefaultThumb__());
  }
  public function isHorizontal__(): Boolean {
    return isHorizontal;
  }
  private function pageDown__(): void {
    this.setValue__I(this.getValue__() + this.getPageIncrement__());
  }
  private function pageUp__(): void {
    this.setValue__I(this.getValue__() - this.getPageIncrement__());
  }
  public function propertyChange__Ljava_beans_PropertyChangeEvent_2(event: PropertyChangeEvent): void {
    if (event.getSource__() is RangeModel) {
      this.setEnabled__Z(this.getRangeModel__().isEnabled__());
      if (Object("value").equals__Ljava_lang_Object_2(event.getPropertyName__())) {
        this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("value", event.getOldValue__(), event.getNewValue__());
        this.revalidate__();
      }
      if (Object("minimum").equals__Ljava_lang_Object_2(event.getPropertyName__())) {
        this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("value", event.getOldValue__(), event.getNewValue__());
        this.revalidate__();
      }
      if (Object("maximum").equals__Ljava_lang_Object_2(event.getPropertyName__())) {
        this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("value", event.getOldValue__(), event.getNewValue__());
        this.revalidate__();
      }
      if (Object("extent").equals__Ljava_lang_Object_2(event.getPropertyName__())) {
        this.firePropertyChange__Ljava_lang_String_2Ljava_lang_Object_2Ljava_lang_Object_2("value", event.getOldValue__(), event.getNewValue__());
        this.revalidate__();
      }
    }
    return;
  }
  public override function revalidate__(): void {
    this.invalidate__();
    this.getUpdateManager__().addInvalidFigure__Lorg_eclipse_draw2d_IFigure_2(this);
    return;
  }
  public function setDirection__I(direction: int): void {
  }
  public function setDownClickable__Lorg_eclipse_draw2d_Clickable_2(down: Clickable): void {
    if (buttonDown !== null) {
      this.remove__Lorg_eclipse_draw2d_IFigure_2(buttonDown);
    }
    buttonDown = down;
    if (buttonDown !== null) {
      if (buttonDown is Orientable)
        (Orientable(buttonDown)).setDirection__I(this.isHorizontal__() ? 16 : 4);
      buttonDown.setFiringMethod__I(1);
      buttonDown.addActionListener__Lorg_eclipse_draw2d_ActionListener_2(new org.eclipse.draw2d.ScrollBar$2(this));
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(buttonDown, "down arrow");
    }
    return;
  }
  public function setUpClickable__Lorg_eclipse_draw2d_Clickable_2(up: Clickable): void {
    if (buttonUp !== null) {
      this.remove__Lorg_eclipse_draw2d_IFigure_2(buttonUp);
    }
    buttonUp = up;
    if (up !== null) {
      if (up is Orientable)
        (Orientable(up)).setDirection__I(this.isHorizontal__() ? 8 : 1);
      buttonUp.setFiringMethod__I(1);
      buttonUp.addActionListener__Lorg_eclipse_draw2d_ActionListener_2(new org.eclipse.draw2d.ScrollBar$3(this));
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(buttonUp, "up arrow");
    }
    return;
  }
  public override function setEnabled__Z(value: Boolean): void {
    if (this.isEnabled__() == value)
      return;
    super.setEnabled__Z(value);
    this.setChildrenEnabled__Z(value);
    if (this.getThumb__() !== null) {
      this.getThumb__().setVisible__Z(value);
      this.revalidate__();
    }
    return;
  }
  public function setExtent__I(ext: int): void {
    if (this.getExtent__() == ext)
      return;
    this.getRangeModel__().setExtent__I(ext);
  }
  public function setHorizontal__Z(value: Boolean): void {
    this.setOrientation__I(value ? 0 : 1);
  }
  public function setMaximum__I(max: int): void {
    if (this.getMaximum__() == max)
      return;
    this.getRangeModel__().setMaximum__I(max);
  }
  public function setMinimum__I(min: int): void {
    if (this.getMinimum__() == min)
      return;
    this.getRangeModel__().setMinimum__I(min);
  }
  public function setOrientation__I(value: int): void {
    if ((value == 0) == this.isHorizontal__())
      return;
    isHorizontal = value == 0;
    transposer.setEnabled__Z(isHorizontal);
    this.setChildrenOrientation__I(value);
    super.revalidate__();
  }
  public function setPageIncrement__I(increment: int): void {
    pageIncrement = increment;
  }
  public function setPageDown__Lorg_eclipse_draw2d_Clickable_2(down: Clickable): void {
    if (pageDown !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(pageDown);
    pageDown = down;
    if (pageDown !== null) {
      pageDown.setFiringMethod__I(1);
      pageDown.addActionListener__Lorg_eclipse_draw2d_ActionListener_2(new org.eclipse.draw2d.ScrollBar$4(this));
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(down, "page_down");
    }
    return;
  }
  public function setPageUp__Lorg_eclipse_draw2d_Clickable_2(up: Clickable): void {
    if (pageUp !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(pageUp);
    pageUp = up;
    if (pageUp !== null) {
      pageUp.setFiringMethod__I(1);
      pageUp.addActionListener__Lorg_eclipse_draw2d_ActionListener_2(new org.eclipse.draw2d.ScrollBar$5(this));
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(pageUp, "page_up");
    }
    return;
  }
  public function setRangeModel__Lorg_eclipse_draw2d_RangeModel_2(rangeModel_1: RangeModel): void {
    if (this.rangeModel !== null)
      this.rangeModel.removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
    this.rangeModel = rangeModel_1;
    rangeModel_1.addPropertyChangeListener__Ljava_beans_PropertyChangeListener_2(this);
    return;
  }
  public function setStepIncrement__I(increment: int): void {
    stepIncrement = increment;
    return;
  }
  public function setThumb__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    if (thumb !== null) {
      thumb.removeMouseListener__Lorg_eclipse_draw2d_MouseListener_2(thumbDragger);
      thumb.removeMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(thumbDragger);
      this.remove__Lorg_eclipse_draw2d_IFigure_2(thumb);
    }
    thumb = figure;
    if (thumb !== null) {
      thumb.addMouseListener__Lorg_eclipse_draw2d_MouseListener_2(thumbDragger);
      thumb.addMouseMotionListener__Lorg_eclipse_draw2d_MouseMotionListener_2(thumbDragger);
      this.add__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(thumb, "thumb");
    }
    return;
  }
  public function setValue__I(v: int): void {
    this.getRangeModel__().setValue__I(v);
    return;
  }
  public function stepDown__(): void {
    this.setValue__I(this.getValue__() + this.getStepIncrement__());
    return;
  }
  public function stepUp__(): void {
    this.setValue__I(this.getValue__() - this.getStepIncrement__());
    return;
  }
  public static function access$0(): Color {
    return COLOR_TRACK;
  }
  public static function access$1(arg0: ScrollBar): void {
    arg0.pageDown__();
  }
  public static function access$2(arg0: ScrollBar): void {
    arg0.pageUp__();
  }
}
}
