package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ScrollBarLayout extends AbstractLayout {
  public static const UP_ARROW: String = "up arrow";
  public static const DOWN_ARROW: String = "down arrow";
  public static const THUMB: String = "thumb";
  public static const PAGE_UP: String = "page_up";
  public static const PAGE_DOWN: String = "page_down";
  internal var up: IFigure;
  internal var down: IFigure;
  internal var thumb: IFigure;
  internal var pageUp: IFigure;
  internal var pageDown: IFigure;
  public var transposer: Transposer;
  public function ScrollBarLayout(t: Transposer) {
    transposer = t;
    return;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(figure: IFigure, constraint: Object): void {
    if (Object(constraint).equals__Ljava_lang_Object_2("up arrow"))
      up = figure;
    else if (Object(constraint).equals__Ljava_lang_Object_2("down arrow"))
      down = figure;
    else if (Object(constraint).equals__Ljava_lang_Object_2("thumb"))
      thumb = figure;
    else if (Object(constraint).equals__Ljava_lang_Object_2("page_up"))
      pageUp = figure;
    else if (Object(constraint).equals__Ljava_lang_Object_2("page_down"))
      pageDown = figure;
    return;
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(parent: IFigure, w: int, h: int): Dimension {
    var insets: Insets = transposer.t__Lorg_eclipse_draw2d_geometry_Insets_2(parent.getInsets__());
    var d: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [16, 16 * 4]));
    d.expand__II(insets.getWidth__(), insets.getHeight__());
    return transposer.t__Lorg_eclipse_draw2d_geometry_Dimension_2(d);
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    var scrollBar: ScrollBar = ScrollBar(parent);
    var trackBounds: Rectangle = this.layoutButtons__Lorg_eclipse_draw2d_ScrollBar_2(scrollBar);
    var extent: int = scrollBar.getExtent__();
    var max: int = scrollBar.getMaximum__();
    var min: int = scrollBar.getMinimum__();
    var totalRange: int = max - min;
    var valueRange: int = totalRange - extent;
    if ((valueRange < 1) || (!scrollBar.isEnabled__())) {
      var boundsUpper: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [trackBounds]));
      var boundsLower: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Rectangle_2, [trackBounds]));
      boundsUpper.height /= 2;
      boundsLower.y += boundsUpper.height;
      boundsLower.height = trackBounds.height - boundsUpper.height;
      if (pageUp !== null)
        pageUp.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(boundsUpper));
      if (pageDown !== null)
        pageDown.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(boundsLower));
      return;
    }
    if (totalRange == 0)
      return;
    var thumbHeight: int = Math__.max__II(thumb === null ? 0 : thumb.getMinimumSize__().height, int(trackBounds.height * extent / totalRange));
    if (thumb !== null)
      thumb.setVisible__Z(trackBounds.height > thumbHeight);
    var thumbY: int = trackBounds.y + int((trackBounds.height - thumbHeight) * (scrollBar.getValue__() - min) / valueRange);
    var thumbBounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [trackBounds.x, thumbY, trackBounds.width, thumbHeight]));
    if (thumb !== null)
      thumb.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(thumbBounds));
    if (pageUp !== null)
      pageUp.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [trackBounds.x, trackBounds.y, trackBounds.width, thumbBounds.y - trackBounds.y]))));
    if (pageDown !== null)
      pageDown.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [trackBounds.x, thumbBounds.y + thumbHeight, trackBounds.width, trackBounds.bottom__() - thumbBounds.bottom__()]))));
  }
  public function layoutButtons__Lorg_eclipse_draw2d_ScrollBar_2(scrollBar: ScrollBar): Rectangle {
    var bounds: Rectangle = transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(scrollBar.getClientArea__());
    var buttonSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [bounds.width, Math__.min__II(bounds.width, int(bounds.height / 2))]));
    if (up !== null)
      up.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [bounds.getTopLeft__(), buttonSize]))));
    if (down !== null) {
      var r: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [bounds.x, bounds.bottom__() - buttonSize.height, buttonSize.width, buttonSize.height]));
      down.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(transposer.t__Lorg_eclipse_draw2d_geometry_Rectangle_2(r));
    }
    var trackBounds: Rectangle = bounds.getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__IIII, [(up === null) ? 0 : buttonSize.height, 0, (down === null) ? 0 : buttonSize.height, 0])));
    return trackBounds;
  }
  public override function remove__Lorg_eclipse_draw2d_IFigure_2(child: IFigure): void {
    if (child === up) {
      up = null;
    } else if (child === down) {
      down = null;
    } else if (child === thumb) {
      thumb = null;
    } else if (child === pageUp) {
      pageUp = null;
    } else if (child === pageDown) {
      pageDown = null;
    }
    return;
  }
}
}
