package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Point;
import java.lang.Arguments;
dynamic public class ScrollPane extends Figure {
  public static const NEVER: int = 0;
  public static const AUTOMATIC: int = 1;
  public static const ALWAYS: int = 2;
  public var viewport: Viewport;
  public var hBar: ScrollBar;
  public var vBar: ScrollBar;
  private var hVisibility: int = 1;
  private var vVisibility: int = 1;
  public function ScrollPane() {
    this.setLayoutManager__Lorg_eclipse_draw2d_LayoutManager_2(new ScrollPaneLayout());
    return;
  }
  public function createHorizontalScrollBar__(): void {
    var bar: ScrollBar = new ScrollBar();
    bar.setHorizontal__Z(true);
    this.setHorizontalScrollBar__Lorg_eclipse_draw2d_ScrollBar_2(bar);
    return;
  }
  public function createViewport__(): void {
    this.setViewport__Lorg_eclipse_draw2d_Viewport_2(new Viewport(new Arguments(org.eclipse.draw2d.Viewport.Viewport__, [])));
    return;
  }
  public function createVerticalScrollBar__(): void {
    var bar: ScrollBar = new ScrollBar();
    this.setVerticalScrollBar__Lorg_eclipse_draw2d_ScrollBar_2(bar);
    return;
  }
  public function getHorizontalScrollBar__(): ScrollBar {
    if (hBar === null)
      this.createHorizontalScrollBar__();
    return hBar;
  }
  public function getHorizontalScrollBarVisibility__(): int {
    return hVisibility;
  }
  public function getVerticalScrollBar__(): ScrollBar {
    if (vBar === null)
      this.createVerticalScrollBar__();
    return vBar;
  }
  public function getVerticalScrollBarVisibility__(): int {
    return vVisibility;
  }
  public function getContents__(): IFigure {
    return this.getView__();
  }
  public function getView__(): IFigure {
    return this.getViewport__().getContents__();
  }
  public function getViewport__(): Viewport {
    if (viewport === null)
      this.createViewport__();
    return viewport;
  }
  public override function isOpaque__(): Boolean {
    return true;
  }
  public function scrollHorizontalTo__I(x: int): void {
    this.getViewport__().setHorizontalLocation__I(x);
  }
  public function scrollTo__Lorg_eclipse_draw2d_geometry_Point_2(location: Point): void {
    this.scrollHorizontalTo__I(location.x);
    this.scrollVerticalTo__I(location.y);
  }
  public function scrollVerticalTo__I(y: int): void {
    this.getViewport__().setVerticalLocation__I(y);
  }
  public function setContents__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    this.setView__Lorg_eclipse_draw2d_IFigure_2(figure);
  }
  public function setHorizontalScrollBar__Lorg_eclipse_draw2d_ScrollBar_2(bar: ScrollBar): void {
    if (hBar !== null) {
      this.remove__Lorg_eclipse_draw2d_IFigure_2(hBar);
      hBar.getRangeModel__().removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(hBar);
    }
    hBar = bar;
    if (hBar !== null) {
      this.add__Lorg_eclipse_draw2d_IFigure_2(hBar);
      hBar.setRangeModel__Lorg_eclipse_draw2d_RangeModel_2(this.getViewport__().getHorizontalRangeModel__());
    }
    return;
  }
  public function setHorizontalScrollBarVisibility__I(v: int): void {
    if (hVisibility == v)
      return;
    hVisibility = v;
    this.revalidate__();
  }
  public function setScrollBarVisibility__I(v: int): void {
    this.setHorizontalScrollBarVisibility__I(v);
    this.setVerticalScrollBarVisibility__I(v);
  }
  public function setVerticalScrollBar__Lorg_eclipse_draw2d_ScrollBar_2(bar: ScrollBar): void {
    if (vBar !== null) {
      this.remove__Lorg_eclipse_draw2d_IFigure_2(vBar);
      vBar.getRangeModel__().removePropertyChangeListener__Ljava_beans_PropertyChangeListener_2(vBar);
    }
    vBar = bar;
    if (vBar !== null) {
      this.add__Lorg_eclipse_draw2d_IFigure_2(vBar);
      vBar.setRangeModel__Lorg_eclipse_draw2d_RangeModel_2(this.getViewport__().getVerticalRangeModel__());
    }
    return;
  }
  public function setVerticalScrollBarVisibility__I(v: int): void {
    if (vVisibility == v)
      return;
    vVisibility = v;
    this.revalidate__();
  }
  public function setView__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): void {
    this.getViewport__().setContents__Lorg_eclipse_draw2d_IFigure_2(figure);
  }
  public function setViewport__Lorg_eclipse_draw2d_Viewport_2(vp: Viewport): void {
    if (viewport !== null)
      this.remove__Lorg_eclipse_draw2d_IFigure_2(viewport);
    viewport = vp;
    if (vp !== null)
      this.add__Lorg_eclipse_draw2d_IFigure_2I(vp, 0);
  }
  public override function validate__(): void {
    super.validate__();
    this.getHorizontalScrollBar__().validate__();
    this.getVerticalScrollBar__().validate__();
  }
}
}
