package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ScrollPaneLayout extends AbstractHintLayout {
  public static const NEVER: int = 0;
  public static const AUTO: int = 1;
  public static const ALWAYS: int = 2;
  public override function calculateMinimumSize__Lorg_eclipse_draw2d_IFigure_2II(figure: IFigure, w: int, h: int): Dimension {
    var scrollpane: ScrollPane = ScrollPane(figure);
    var insets: Insets = scrollpane.getInsets__();
    var d: Dimension = scrollpane.getViewport__().getMinimumSize__II(w, h);
    return d.getExpanded__II(insets.getWidth__(), insets.getHeight__());
  }
  public override function calculatePreferredSize__Lorg_eclipse_draw2d_IFigure_2II(container: IFigure, wHint: int, hHint: int): Dimension {
    var scrollpane: ScrollPane = ScrollPane(container);
    var hBar: ScrollBar = scrollpane.getHorizontalScrollBar__();
    var vBar: ScrollBar = scrollpane.getVerticalScrollBar__();
    var insets: Insets = scrollpane.getInsets__();
    var reservedWidth: int = insets.getWidth__();
    var reservedHeight: int = insets.getHeight__();
    if (scrollpane.getVerticalScrollBarVisibility__() != 0)
      reservedWidth += vBar.getPreferredSize__().width;
    if (scrollpane.getHorizontalScrollBarVisibility__() != 0)
      reservedHeight += hBar.getPreferredSize__().height;
    if (wHint > -1)
      wHint = Math__.max__II(0, wHint - reservedWidth);
    if (hHint > -1)
      hHint = Math__.max__II(0, hHint - reservedHeight);
    return scrollpane.getViewport__().getPreferredSize__II(wHint, hHint).getExpanded__II(reservedWidth, reservedHeight);
  }
  public override function layout__Lorg_eclipse_draw2d_IFigure_2(parent: IFigure): void {
    var scrollpane: ScrollPane = ScrollPane(parent);
    var viewport: Viewport = scrollpane.getViewport__();
    var hBar: ScrollBar = scrollpane.getHorizontalScrollBar__();
    var vBar: ScrollBar = scrollpane.getVerticalScrollBar__();
    var result: ScrollPaneSolver$Result = ScrollPaneSolver.solve__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_Viewport_2IIII(parent.getClientArea__(), viewport, scrollpane.getHorizontalScrollBarVisibility__(), scrollpane.getVerticalScrollBarVisibility__(), vBar.getPreferredSize__().width, hBar.getPreferredSize__().height);
    if (result.showV) {
      vBar.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [result.viewportArea.right__(), result.viewportArea.y, result.insets.right, result.viewportArea.height])));
    }
    if (result.showH) {
      hBar.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__IIII, [result.viewportArea.x, result.viewportArea.bottom__(), result.viewportArea.width, result.insets.bottom])));
    }
    vBar.setVisible__Z(result.showV);
    hBar.setVisible__Z(result.showH);
    var vStepInc: int = vBar.getStepIncrement__();
    var vPageInc: int = vBar.getRangeModel__().getExtent__() - vStepInc;
    if (vPageInc < vStepInc)
      vPageInc = vStepInc;
    vBar.setPageIncrement__I(vPageInc);
    var hStepInc: int = hBar.getStepIncrement__();
    var hPageInc: int = hBar.getRangeModel__().getExtent__() - hStepInc;
    if (hPageInc < hStepInc)
      hPageInc = hStepInc;
    hBar.setPageIncrement__I(hPageInc);
    return;
  }
}
}
