package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Math__;
import java.lang.Arguments;
dynamic public class ScrollPaneSolver {
  public static const NEVER: int = 0;
  public static const AUTOMATIC: int = 1;
  public static const ALWAYS: int = 2;
  public static function solve__Lorg_eclipse_draw2d_geometry_Rectangle_2Lorg_eclipse_draw2d_Viewport_2IIII(clientArea: Rectangle, viewport: Viewport, hVis: int, vVis: int, vBarWidth: int, hBarHeight: int): ScrollPaneSolver$Result {
    var result: ScrollPaneSolver$Result = new ScrollPaneSolver$Result();
    result.insets = new Insets(new Arguments(org.eclipse.draw2d.geometry.Insets.Insets__, []));
    result.insets.bottom = hBarHeight;
    result.insets.right = vBarWidth;
    var available: Dimension = clientArea.getSize__();
    var guaranteed: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [available])).shrink__II((vVis == 0 ? 0 : result.insets.right), (hVis == 0 ? 0 : result.insets.bottom));
    guaranteed.width = Math__.max__II(guaranteed.width, 0);
    guaranteed.height = Math__.max__II(guaranteed.height, 0);
    var wHint: int = guaranteed.width;
    var hHint: int = guaranteed.height;
    var preferred: Dimension = viewport.getPreferredSize__II(wHint, hHint).getCopy__();
    var viewportInsets: Insets = viewport.getInsets__();
    var viewportMinSize: Dimension = new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__II, [viewportInsets.getWidth__(), viewportInsets.getHeight__()]));
    if (viewport.getContents__() !== null) {
      if (viewport.getContentsTracksHeight__() && hHint > -1)
        hHint = Math__.max__II(0, hHint - viewportInsets.getHeight__());
      if (viewport.getContentsTracksWidth__() && wHint > -1)
        wHint = Math__.max__II(0, wHint - viewportInsets.getWidth__());
      viewportMinSize.expand__Lorg_eclipse_draw2d_geometry_Dimension_2(viewport.getContents__().getMinimumSize__II(wHint, hHint));
    }
    if (viewport.getContentsTracksHeight__())
      preferred.height = viewportMinSize.height;
    if (viewport.getContentsTracksWidth__())
      preferred.width = viewportMinSize.width;
    var none: Boolean = available.contains__Lorg_eclipse_draw2d_geometry_Dimension_2(preferred);
    var both: Boolean = !none && preferred.containsProper__Lorg_eclipse_draw2d_geometry_Dimension_2(guaranteed);
    var showV: Boolean = both || preferred.height > available.height;
    var showH: Boolean = both || preferred.width > available.width;
    result.showV = vVis != 0 && (showV || vVis == 2);
    result.showH = hVis != 0 && (showH || hVis == 2);
    if (!result.showV)
      result.insets.right = 0;
    if (!result.showH)
      result.insets.bottom = 0;
    result.viewportArea = clientArea.getCropped__Lorg_eclipse_draw2d_geometry_Insets_2(result.insets);
    viewport.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(result.viewportArea);
    return result;
  }
}
}
